/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.targets;

import com.android.io.CancellableFileIo;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.PackageParserUtils;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.meta.SysImgFactory;
import com.android.sdklib.repository.targets.SystemImage;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SystemImageManager {
    private final RepoManager mRepoManager;
    private final DetailsTypes.SysImgDetailsType mValidator;
    public static final String SYS_IMG_NAME = "system.img";
    private static final int MAX_DEPTH = 4;
    private Multimap<LocalPackage, SystemImage> mPackageToImage;
    private Map<Path, SystemImage> mPathToImage;
    private Table<IdDisplay, AndroidVersion, Multimap<IdDisplay, SystemImage>> mValuesToImage;

    public SystemImageManager(RepoManager mgr, SysImgFactory factory) {
        this.mRepoManager = mgr;
        this.mValidator = factory.createSysImgDetailsType();
    }

    public Collection<SystemImage> getImages() {
        if (this.mPackageToImage == null) {
            this.init();
        }
        return this.mPackageToImage.values();
    }

    public Multimap<LocalPackage, SystemImage> getImageMap() {
        if (this.mPackageToImage == null) {
            this.init();
        }
        return this.mPackageToImage;
    }

    public Collection<SystemImage> lookup(IdDisplay tag, AndroidVersion version, IdDisplay vendor) {
        Multimap m;
        if (this.mValuesToImage == null) {
            this.init();
        }
        return (m = (Multimap)this.mValuesToImage.get((Object)tag, (Object)version)) == null ? ImmutableList.of() : m.get((Object)vendor);
    }

    private void init() {
        Multimap<LocalPackage, SystemImage> images = this.buildImageMap();
        HashBasedTable valuesToImage = HashBasedTable.create();
        HashMap pathToImages = Maps.newHashMap();
        for (SystemImage img : images.values()) {
            AndroidVersion version;
            IdDisplay vendor = img.getAddonVendor();
            IdDisplay tag = img.getTag();
            Multimap vendorImageMap = (Multimap)valuesToImage.get((Object)tag, (Object)(version = img.getAndroidVersion()));
            if (vendorImageMap == null) {
                vendorImageMap = HashMultimap.create();
                valuesToImage.put((Object)tag, (Object)version, (Object)vendorImageMap);
            }
            vendorImageMap.put((Object)vendor, (Object)img);
            pathToImages.put(img.getLocation(), img);
        }
        this.mValuesToImage = valuesToImage;
        this.mPackageToImage = images;
        this.mPathToImage = pathToImages;
    }

    private Multimap<LocalPackage, SystemImage> buildImageMap() {
        HashMultimap result = HashMultimap.create();
        HashMap platformSkins = Maps.newHashMap();
        Collection packages = this.mRepoManager.getPackages().getLocalPackages().values();
        for (LocalPackage p : packages) {
            Path skinDir;
            if (!(p.getTypeDetails() instanceof DetailsTypes.PlatformDetailsType) || !CancellableFileIo.exists((Path)(skinDir = p.getLocation().resolve("skins")), (LinkOption[])new LinkOption[0])) continue;
            platformSkins.put(((DetailsTypes.PlatformDetailsType)p.getTypeDetails()).getAndroidVersion(), skinDir);
        }
        for (LocalPackage p : packages) {
            TypeDetails typeDetails = p.getTypeDetails();
            if (!(typeDetails instanceof DetailsTypes.SysImgDetailsType) && !(typeDetails instanceof DetailsTypes.PlatformDetailsType) && !(typeDetails instanceof DetailsTypes.AddonDetailsType)) continue;
            this.collectImages(p.getLocation(), p, platformSkins, (Multimap<LocalPackage, SystemImage>)result);
        }
        return result;
    }

    private void collectImages(Path dir, final LocalPackage p, final Map<AndroidVersion, Path> platformSkins, final Multimap<LocalPackage, SystemImage> collector) {
        try {
            CancellableFileIo.walkFileTree((Path)dir, (Set)ImmutableSet.of(), (int)4, (FileVisitor)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    String name = dir.getFileName().toString();
                    if (name.equals("data") || name.equals("samples") || name.equals("skins")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (file.toString().endsWith(SystemImageManager.SYS_IMG_NAME) && file.getFileName().toString().equals(SystemImageManager.SYS_IMG_NAME)) {
                        collector.put((Object)p, (Object)SystemImageManager.this.createSysImg(p, file.getParent(), platformSkins));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private SystemImage createSysImg(LocalPackage p, Path dir, Map<AndroidVersion, Path> platformSkins) {
        String containingDir = dir.getFileName().toString();
        TypeDetails details = p.getTypeDetails();
        AndroidVersion version = null;
        if (details instanceof DetailsTypes.ApiDetailsType) {
            version = ((DetailsTypes.ApiDetailsType)details).getAndroidVersion();
        }
        String abi = details instanceof DetailsTypes.SysImgDetailsType ? ((DetailsTypes.SysImgDetailsType)details).getAbi() : (this.mValidator.isValidAbi(containingDir) ? containingDir : "armeabi");
        IdDisplay vendor = null;
        if (details instanceof DetailsTypes.AddonDetailsType) {
            vendor = ((DetailsTypes.AddonDetailsType)details).getVendor();
        } else if (details instanceof DetailsTypes.SysImgDetailsType) {
            vendor = ((DetailsTypes.SysImgDetailsType)details).getVendor();
        }
        Path skinDir = dir.resolve("skins");
        if (CancellableFileIo.notExists((Path)skinDir, (LinkOption[])new LinkOption[0]) && version != null) {
            skinDir = platformSkins.get(version);
        }
        Path[] skins = skinDir != null ? PackageParserUtils.parseSkinFolder(skinDir).toArray(new Path[0]) : new Path[]{};
        return new SystemImage(dir, (Iterable<IdDisplay>)SystemImageTags.getTags((RepoPackage)p), vendor, abi, skins, (RepoPackage)p);
    }

    public ISystemImage getImageAt(Path imageDir) {
        if (this.mPathToImage == null) {
            this.init();
        }
        return this.mPathToImage.get(imageDir);
    }

    public void clearCache() {
        this.mPackageToImage = null;
        this.mPathToImage = null;
    }
}

