/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.host.icebox;

import com.android.tools.utp.plugins.host.icebox.EmulatorGrpcInfo;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0000\u001a\n\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0002\"\u001c\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"DEFAULT_EMULATOR_GRPC_INFO", "Lcom/android/tools/utp/plugins/host/icebox/EmulatorGrpcInfo;", "getDEFAULT_EMULATOR_GRPC_INFO$annotations", "()V", "getDEFAULT_EMULATOR_GRPC_INFO", "()Lcom/android/tools/utp/plugins/host/icebox/EmulatorGrpcInfo;", "DEFAULT_EMULATOR_GRPC_PORT", "", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "computeRegistrationDirectoryContainer", "Ljava/nio/file/Path;", "findGrpcInfo", "deviceSerial", "", "file", "getUid", "android-test-plugin-host-retention"})
public final class IceboxConfigUtilsKt {
    public static final int DEFAULT_EMULATOR_GRPC_PORT = 8554;
    private static final Logger LOG = Logger.getLogger("IceboxConfigUtils");
    @NotNull
    private static final EmulatorGrpcInfo DEFAULT_EMULATOR_GRPC_INFO = new EmulatorGrpcInfo(8554, null);

    @NotNull
    public static final EmulatorGrpcInfo getDEFAULT_EMULATOR_GRPC_INFO() {
        return DEFAULT_EMULATOR_GRPC_INFO;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDEFAULT_EMULATOR_GRPC_INFO$annotations() {
    }

    private static final Path computeRegistrationDirectoryContainer() {
        String string;
        String object = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProperty(\"os.name\")");
        String string2 = object;
        String[] stringArray = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"ROOT");
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3.toLowerCase((Locale)stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        String os = string4;
        if (StringsKt.startsWith$default((String)os, (String)"mac", (boolean)false, (int)2, null)) {
            String string5 = System.getenv("HOME");
            String string6 = string5 == null ? "/" : string5;
            String[] stringArray2 = new String[]{"Library", "Caches", "TemporaryItems"};
            return Paths.get(string6, stringArray2);
        }
        if (StringsKt.startsWith$default((String)os, (String)"win", (boolean)false, (int)2, null)) {
            String string7 = System.getenv("LOCALAPPDATA");
            String string8 = string7 == null ? "/" : string7;
            String[] stringArray3 = new String[]{"Temp"};
            return Paths.get(string8, stringArray3);
        }
        stringArray = new String[]{System.getenv("XDG_RUNTIME_DIR"), Intrinsics.stringPlus((String)"/run/user/", (Object)IceboxConfigUtilsKt.getUid()), System.getenv("ANDROID_EMULATOR_HOME"), System.getenv("ANDROID_PREFS_ROOT"), System.getenv("ANDROID_SDK_HOME"), Intrinsics.stringPlus((String)((string = System.getenv("HOME")) == null ? "/" : string), (Object)".android"), System.getProperty("android.emulator.home")};
        for (String dirstr : stringArray) {
            if (dirstr == null) continue;
            try {
                Path dir = Paths.get(dirstr, new String[0]);
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                return dir;
            }
            catch (InvalidPathException exception) {
                LOG.finer("Failed to parse dir " + dirstr + ", exception " + exception);
            }
        }
        String[] stringArray4 = new String[]{Intrinsics.stringPlus((String)"android-", (Object)System.getProperty("USER"))};
        return Paths.get(FileUtils.getTempDirectory().getAbsolutePath(), stringArray4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getUid() {
        try {
            String userName = System.getProperty("user.name");
            String command = Intrinsics.stringPlus((String)"id -u ", (Object)userName);
            Process process = Runtime.getRuntime().exec(command);
            Closeable closeable = process.getInputStream();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Object object = ByteStreamsKt.readBytes((InputStream)it);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                boolean bl4 = false;
                object = new String((byte[])object, charset);
                boolean bl5 = false;
                String result = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                object = result;
                bl5 = false;
                if (object.length() == 0) {
                    String string = null;
                    return string;
                }
                String string = result;
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static final EmulatorGrpcInfo findGrpcInfo(@NotNull String deviceSerial, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)deviceSerial, (String)"deviceSerial");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        int currentGrpcPort = 0;
        currentGrpcPort = 8554;
        String currentGrpcToken = null;
        boolean matchedAvd = false;
        Iterable<String> iterable = Files.readAllLines(file);
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"readAllLines(file)");
        iterable = iterable;
        boolean bl = false;
        Iterator<String> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            String serial;
            int n;
            String string;
            String string2;
            String line = string2 = iterator.next();
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)line, (String)"line");
            if (StringsKt.startsWith$default((String)line, (String)"grpc.port=", (boolean)false, (int)2, null)) {
                string = line;
                int n2 = "grpc.port=".length();
                n = 0;
                String string3 = string.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                currentGrpcPort = Integer.parseInt(string3, 10);
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"grpc.token=", (boolean)false, (int)2, null)) {
                string = line;
                int n3 = "grpc.token=".length();
                n = 0;
                Intrinsics.checkNotNullExpressionValue((Object)string.substring(n3), (String)"(this as java.lang.String).substring(startIndex)");
                continue;
            }
            if (!StringsKt.startsWith$default((String)line, (String)"port.serial=", (boolean)false, (int)2, null)) continue;
            String string4 = line;
            n = "port.serial=".length();
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)string4.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
            matchedAvd = Intrinsics.areEqual((Object)Intrinsics.stringPlus((String)"emulator-", (Object)serial), (Object)deviceSerial);
        }
        if (matchedAvd) {
            return new EmulatorGrpcInfo(currentGrpcPort, currentGrpcToken);
        }
        return null;
    }

    public static final /* synthetic */ Path access$computeRegistrationDirectoryContainer() {
        return IceboxConfigUtilsKt.computeRegistrationDirectoryContainer();
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

