/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Entry;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipMap;
import com.android.zipflinger.ZipSourceEntry;
import com.android.zipflinger.ZipSourceEntryDeflater;
import com.android.zipflinger.ZipSourceEntryInflater;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ZipSource {
    public static final int COMPRESSION_NO_CHANGE = -2;
    private final File file;
    private FileChannel channel;
    private ZipMap map;
    private final List<Source> selectedEntries = new ArrayList<Source>();

    public ZipSource(File file) throws IOException {
        this.map = ZipMap.from(file, false);
        this.file = file;
    }

    public Source select(String entryName, String newName) {
        return this.select(entryName, newName, -2);
    }

    public Source select(String entryName, String newName, int compressionLevel) {
        Entry entry = this.map.getEntries().get(entryName);
        if (entry == null) {
            throw new IllegalStateException(String.format("Cannot find '%s' in archive '%s'", entryName, this.map.getFile()));
        }
        Source entrySource = this.newZipSourceEntryFor(newName, entry, this, compressionLevel);
        this.selectedEntries.add(entrySource);
        return entrySource;
    }

    public Map<String, Entry> entries() {
        return this.map.getEntries();
    }

    public static ZipSource selectAll(File file) throws IOException {
        ZipSource source = new ZipSource(file);
        for (Entry e : source.entries().values()) {
            source.select(e.getName(), e.getName(), -2);
        }
        return source;
    }

    void open() throws IOException {
        this.channel = FileChannel.open(this.file.toPath(), StandardOpenOption.READ);
    }

    void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    FileChannel getChannel() {
        return this.channel;
    }

    public List<? extends Source> getSelectedEntries() {
        return this.selectedEntries;
    }

    Source newZipSourceEntryFor(String newName, Entry entry, ZipSource zipSource, int compressionLevel) {
        if (compressionLevel == -2 || compressionLevel == 0 && !entry.isCompressed() || compressionLevel != 0 && entry.isCompressed()) {
            return new ZipSourceEntry(newName, entry, this);
        }
        if (compressionLevel == 0) {
            return new ZipSourceEntryInflater(newName, entry, zipSource);
        }
        return new ZipSourceEntryDeflater(newName, entry, zipSource, compressionLevel);
    }

    String getName() {
        return this.file.getAbsolutePath();
    }
}

