/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava;

import com.apollographql.federation.graphqljava.SchemaTransformer;
import graphql.language.ObjectTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.File;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;

public final class Federation {
    private static final SchemaGenerator.Options generatorOptions = SchemaGenerator.Options.defaultOptions().enforceSchemaDirectives(false);

    private Federation() {
    }

    @NotNull
    public static SchemaTransformer transform(GraphQLSchema schema) {
        return new SchemaTransformer(schema);
    }

    public static SchemaTransformer transform(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring) {
        Federation.ensureQueryTypeExists(typeRegistry);
        GraphQLSchema original = new SchemaGenerator().makeExecutableSchema(generatorOptions, typeRegistry, runtimeWiring);
        return Federation.transform(original);
    }

    public static SchemaTransformer transform(TypeDefinitionRegistry typeRegistry) {
        return Federation.transform(typeRegistry, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(String sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(Reader sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(File sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(String sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(Reader sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(File sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    private static RuntimeWiring emptyWiring() {
        return RuntimeWiring.newRuntimeWiring().build();
    }

    private static void ensureQueryTypeExists(TypeDefinitionRegistry typeRegistry) {
        String queryName = typeRegistry.schemaDefinition().flatMap(sdef -> sdef.getOperationTypeDefinitions().stream().filter(op -> "query".equals(op.getName())).findFirst().map(def -> def.getTypeName().getName())).orElse("Query");
        if (!typeRegistry.getType(queryName).isPresent()) {
            typeRegistry.add((SDLDefinition)ObjectTypeDefinition.newObjectTypeDefinition().name(queryName).build());
        }
    }
}

