/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava.tracing;

import com.apollographql.federation.graphqljava.tracing.HTTPRequestHeaders;
import com.google.protobuf.Timestamp;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.language.Document;
import graphql.language.SourceLocation;
import graphql.parser.InvalidSyntaxException;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.ValidationError;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import mdg.engine.proto.Reports;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederatedTracingInstrumentation
extends SimpleInstrumentation {
    private static final String EXTENSION_KEY = "ftv1";
    private static final String HEADER_NAME = "apollo-federation-include-trace";
    private static final String HEADER_VALUE = "ftv1";
    private final Options options;
    private static final Logger logger = LoggerFactory.getLogger(FederatedTracingInstrumentation.class);

    public FederatedTracingInstrumentation() {
        this.options = Options.newOptions();
    }

    public FederatedTracingInstrumentation(Options options) {
        this.options = options;
    }

    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        String headerValue;
        Object context = parameters.getExecutionInput().getContext();
        if (context instanceof HTTPRequestHeaders && ((headerValue = ((HTTPRequestHeaders)context).getHTTPRequestHeader(HEADER_NAME)) == null || !headerValue.equals("ftv1"))) {
            return null;
        }
        return new FederatedTracingState();
    }

    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters) {
        @Nullable FederatedTracingState state = (FederatedTracingState)parameters.getInstrumentationState();
        if (state == null) {
            return super.instrumentExecutionResult(executionResult, parameters);
        }
        Reports.Trace trace = state.toProto();
        if (this.options.isDebuggingEnabled()) {
            logger.debug(trace.toString());
        }
        return CompletableFuture.completedFuture(new ExecutionResultImpl.Builder().from(executionResult).addExtension("ftv1", (Object)Base64.getEncoder().encodeToString(trace.toByteArray())).build());
    }

    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters) {
        FederatedTracingState state = (FederatedTracingState)parameters.getInstrumentationState();
        if (state == null) {
            return super.beginFieldFetch(parameters);
        }
        SourceLocation fieldLocation = parameters.getEnvironment().getField().getSourceLocation();
        long startNanos = System.nanoTime();
        return SimpleInstrumentationContext.whenCompleted((result, throwable) -> {
            long endNanos = System.nanoTime();
            ExecutionStepInfo executionStepInfo = parameters.getEnvironment().getExecutionStepInfo();
            state.addNode(executionStepInfo, startNanos - state.getStartRequestNanos(), endNanos - state.getStartRequestNanos(), this.convertErrors((Throwable)throwable, result), fieldLocation);
        });
    }

    public InstrumentationContext<Document> beginParse(InstrumentationExecutionParameters parameters) {
        FederatedTracingState state = (FederatedTracingState)parameters.getInstrumentationState();
        if (state == null) {
            return super.beginParse(parameters);
        }
        return SimpleInstrumentationContext.whenCompleted((document, throwable) -> {
            for (GraphQLError error : this.convertErrors((Throwable)throwable, null)) {
                state.addRootError(error);
            }
        });
    }

    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters) {
        FederatedTracingState state = (FederatedTracingState)parameters.getInstrumentationState();
        if (state == null) {
            return super.beginValidation(parameters);
        }
        return SimpleInstrumentationContext.whenCompleted((validationErrors, throwable) -> {
            for (GraphQLError error : this.convertErrors((Throwable)throwable, null)) {
                state.addRootError(error);
            }
            for (GraphQLError error : validationErrors) {
                state.addRootError(error);
            }
        });
    }

    @NotNull
    private List<GraphQLError> convertErrors(Throwable throwable, Object result) {
        DataFetcherResult theResult;
        ArrayList<GraphQLError> graphQLErrors = new ArrayList<GraphQLError>();
        if (throwable != null) {
            if (throwable instanceof GraphQLError) {
                graphQLErrors.add((GraphQLError)throwable);
            } else {
                GraphqlErrorBuilder errorBuilder = GraphqlErrorBuilder.newError().message(throwable.getMessage(), new Object[0]);
                if (throwable instanceof InvalidSyntaxException) {
                    errorBuilder.location(((InvalidSyntaxException)throwable).getLocation());
                }
                graphQLErrors.add(errorBuilder.build());
            }
        }
        if (result instanceof DataFetcherResult && (theResult = (DataFetcherResult)result).hasErrors()) {
            graphQLErrors.addAll(theResult.getErrors());
        }
        return graphQLErrors;
    }

    public static class Options {
        private final boolean debuggingEnabled;

        public Options(boolean debuggingEnabled) {
            this.debuggingEnabled = debuggingEnabled;
        }

        @NotNull
        public static Options newOptions() {
            return new Options(false);
        }

        public boolean isDebuggingEnabled() {
            return this.debuggingEnabled;
        }
    }

    private static class FederatedTracingState
    implements InstrumentationState {
        private final Instant startRequestTime = Instant.now();
        private final long startRequestNanos = System.nanoTime();
        private final LinkedHashMap<ExecutionPath, Reports.Trace.Node.Builder> nodesByPath = new LinkedHashMap();

        private FederatedTracingState() {
            this.nodesByPath.put(ExecutionPath.rootPath(), Reports.Trace.Node.newBuilder());
        }

        @NotNull
        Reports.Trace toProto() {
            return Reports.Trace.newBuilder().setStartTime(this.getStartTimestamp()).setEndTime(this.getNowTimestamp()).setDurationNs(this.getDuration()).setRoot(this.nodesByPath.get(ExecutionPath.rootPath())).build();
        }

        void addNode(ExecutionStepInfo stepInfo, long startFieldNanos, long endFieldNanos, List<GraphQLError> errors, SourceLocation fieldLocation) {
            ExecutionPath path = stepInfo.getPath();
            Reports.Trace.Node.Builder parent = this.getParentNode(path);
            Reports.Trace.Node.Builder node = parent.addChildBuilder().setStartTime(startFieldNanos).setEndTime(endFieldNanos).setParentType(GraphQLTypeUtil.simplePrint((GraphQLType)stepInfo.getParent().getUnwrappedNonNullType())).setType(stepInfo.simplePrint()).setResponseName(stepInfo.getResultKey());
            String originalFieldName = stepInfo.getField().getName();
            if (!originalFieldName.equals(stepInfo.getResultKey())) {
                node.setOriginalFieldName(originalFieldName);
            }
            errors.forEach(error -> {
                Reports.Trace.Error.Builder builder = node.addErrorBuilder().setMessage(error.getMessage());
                if (error.getLocations().isEmpty() && fieldLocation != null) {
                    builder.addLocationBuilder().setColumn(fieldLocation.getColumn()).setLine(fieldLocation.getLine());
                } else {
                    error.getLocations().forEach(location -> builder.addLocationBuilder().setColumn(location.getColumn()).setLine(location.getLine()));
                }
            });
            this.nodesByPath.put(path, node);
        }

        @NotNull
        Reports.Trace.Node.Builder getParentNode(ExecutionPath path) {
            List pathParts = path.toList();
            return this.nodesByPath.computeIfAbsent(ExecutionPath.fromList(pathParts.subList(0, pathParts.size() - 1)), parentPath -> {
                if (parentPath.equals((Object)ExecutionPath.rootPath())) {
                    throw new RuntimeException("root path missing from nodesByPath?");
                }
                Reports.Trace.Node.Builder missingParent = this.getParentNode((ExecutionPath)parentPath).addChildBuilder();
                Object parentLastPathPart = pathParts.get(pathParts.size() - 2);
                if (!(parentLastPathPart instanceof Integer)) {
                    throw new RuntimeException("Unexpected missing non-index " + parentLastPathPart);
                }
                missingParent.setIndex((Integer)parentLastPathPart);
                return missingParent;
            });
        }

        void addRootError(GraphQLError error) {
            Reports.Trace.Error.Builder builder = this.nodesByPath.get(ExecutionPath.rootPath()).addErrorBuilder().setMessage(error.getMessage());
            error.getLocations().forEach(location -> builder.addLocationBuilder().setColumn(location.getColumn()).setLine(location.getLine()));
        }

        long getStartRequestNanos() {
            return this.startRequestNanos;
        }

        @NotNull
        private static Timestamp instantToTimestamp(@NotNull Instant startRequestTime2) {
            return Timestamp.newBuilder().setSeconds(startRequestTime2.getEpochSecond()).setNanos(startRequestTime2.getNano()).build();
        }

        @NotNull
        private Timestamp getStartTimestamp() {
            return FederatedTracingState.instantToTimestamp(this.startRequestTime);
        }

        @NotNull
        private Timestamp getNowTimestamp() {
            return FederatedTracingState.instantToTimestamp(Instant.now());
        }

        private long getDuration() {
            return System.nanoTime() - this.startRequestNanos;
        }
    }
}

