/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.appium.helper.androidx;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ListView;
import android.widget.ScrollView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import com.applitools.appium.helper.androidx.OffsetProvider;
import com.applitools.appium.helper.androidx.ViewUtils;
import java.util.ArrayList;
import java.util.List;

class CommandsExecutor {
    private static final String TAG = "EAH_CommandsExecutor";
    private static CommandsExecutor mExecutor = null;

    CommandsExecutor() {
    }

    static CommandsExecutor getInstance() {
        if (mExecutor == null) {
            mExecutor = new CommandsExecutor();
        }
        return mExecutor;
    }

    public void execute(Activity activity, EditText editText) {
        String command;
        String[] values = editText.getText().toString().split(";");
        editText.getText().clear();
        switch (command = values[0]) {
            case "scroll": {
                this.doScrollOnView(CommandsExecutor.searchForView(activity, values[1]), Integer.parseInt(values[2]), Integer.parseInt(values[3]), Integer.parseInt(values[4]));
                break;
            }
            case "moveToTop": {
                this.moveToTop(activity, CommandsExecutor.searchForView(activity, values[1]), Integer.parseInt(values[3]));
                break;
            }
            case "offset": {
                int scrollableOffset = this.getScrollableOffset(activity, CommandsExecutor.searchForView(activity, values[1]));
                editText.setText((CharSequence)String.valueOf(scrollableOffset));
                break;
            }
            default: {
                Log.d((String)TAG, (String)"Unknown command");
            }
        }
    }

    private static View searchForView(Activity activity, String resourceName) {
        ViewGroup viewGroup = (ViewGroup)((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
        return ViewUtils.find(viewGroup, resourceName);
    }

    private void doScrollOnView(View view, int offset, int step, int totalSteps) {
        if (view != null) {
            if (step == -1 && view.getParent() instanceof ScrollView) {
                ScrollView scrollView = (ScrollView)view.getParent();
                scrollView.scrollTo(scrollView.getScrollX(), scrollView.getScrollY() + scrollView.getHeight());
            }
            try {
                if (view instanceof RecyclerView) {
                    ((RecyclerView)view).scrollBy(0, offset);
                    return;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            if (view instanceof ListView || view instanceof GridView) {
                if (Build.VERSION.SDK_INT >= 19) {
                    ((AbsListView)view).scrollListBy(offset);
                }
            } else {
                view.scrollTo(view.getScrollX(), offset * (step + 1));
            }
        }
    }

    private void moveToTop(Activity activity, final View view, final int step) {
        if (view != null) {
            try {
                if (view instanceof RecyclerView) {
                    activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            ((RecyclerView)view).scrollToPosition(0);
                            if (step == -1 && view.getParent() instanceof ScrollView) {
                                ScrollView scrollView = (ScrollView)view.getParent();
                                scrollView.scrollTo(0, 0);
                            }
                        }
                    });
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            if (view instanceof AbsListView) {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ((AbsListView)view).smoothScrollToPosition(0);
                    }
                });
            } else {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        view.scrollTo(0, 0);
                    }
                });
            }
        }
    }

    private int getScrollableOffset(Activity activity, View view) {
        if (view == null) {
            view = this.findScrollableView(activity);
        }
        if (view == null) {
            Log.d((String)TAG, (String)"No scrollable view was found");
            return 0;
        }
        Log.d((String)TAG, (String)("Found view with class - " + view.getClass().getCanonicalName()));
        return OffsetProvider.getInstance().getScrollableOffset(activity, view);
    }

    private View findScrollableView(Activity activity) {
        View scrollableView = null;
        boolean searchIsDone = false;
        if (activity instanceof FragmentActivity && !((FragmentActivity)activity).getSupportFragmentManager().getFragments().isEmpty()) {
            List fragments = ((FragmentActivity)activity).getSupportFragmentManager().getFragments();
            for (int i = fragments.size() - 1; i >= 0; --i) {
                View fragmentView = ((Fragment)fragments.get(i)).getView();
                if (fragmentView == null || !fragmentView.getGlobalVisibleRect(new Rect())) continue;
                scrollableView = this.findScrollableView((ViewGroup)fragmentView);
                searchIsDone = true;
                break;
            }
        }
        if (scrollableView == null && !searchIsDone) {
            scrollableView = this.findScrollableView((ViewGroup)((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0));
        }
        return scrollableView;
    }

    private View findScrollableView(ViewGroup viewGroup) {
        ArrayList typesList = new ArrayList();
        typesList.add(ListView.class);
        typesList.add(GridView.class);
        try {
            typesList.add(RecyclerView.class);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            typesList.add(ViewPager2.class);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        boolean viewGroupIsScrollable = ViewUtils.checkViewForType(viewGroup, typesList);
        return viewGroupIsScrollable ? viewGroup : ViewUtils.find(viewGroup, typesList);
    }
}

