/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.appium.helper.androidx;

import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.applitools.appium.helper.androidx.CommandsExecutor;
import com.applitools.appium.helper.androidx.OffsetProvider;

public class EyesAppiumHelper {
    private static final String TAG = "EyesAppiumHelper";
    private static final String OFFSET_VIEW_TAG = "OFFSET_VIEW_TAG";
    private static final String EDT_VIEW_TAG = "EDT_VIEW_TAG";
    private static final String VERSION_VIEW_TAG = "VERSION_VIEW_TAG";

    public static void initialize(Application application) {
        if (application == null) {
            return;
        }
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                EyesAppiumHelper.addViewsToActivity(activity);
            }

            public void onActivityPaused(Activity activity) {
                EyesAppiumHelper.removeViewsFromActivity(activity);
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        });
        Log.d((String)TAG, (String)"EyesAppiumHelper for AndroidX initialized");
    }

    private static void addViewsToActivity(final Activity activity) {
        FrameLayout rootLayout = (FrameLayout)activity.findViewById(0x1020002);
        final TextView textView = new TextView(rootLayout.getContext());
        textView.setContentDescription((CharSequence)TAG);
        textView.setHeight(1);
        textView.setWidth(1);
        textView.setTextColor(0);
        textView.setBackgroundColor(0);
        if (Build.VERSION.SDK_INT >= 28) {
            textView.setScreenReaderFocusable(false);
        }
        textView.setFocusable(false);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OffsetProvider provider = OffsetProvider.getInstance();
                int scrollableOffset = provider.getScrollableOffset(activity, null);
                textView.setText((CharSequence)String.valueOf(scrollableOffset));
            }
        });
        final EditText editText = new EditText(rootLayout.getContext());
        editText.setContentDescription((CharSequence)"EyesAppiumHelperEDT");
        editText.setHeight(1);
        editText.setWidth(1);
        editText.setTextColor(0);
        editText.setBackgroundColor(0);
        editText.setFocusable(false);
        if (Build.VERSION.SDK_INT >= 28) {
            editText.setScreenReaderFocusable(false);
        }
        editText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CommandsExecutor.getInstance().execute(activity, editText);
            }
        });
        LinearLayout.LayoutParams childParams = new LinearLayout.LayoutParams(-2, -2, 8388611.0f);
        textView.setTag((Object)OFFSET_VIEW_TAG);
        rootLayout.addView((View)textView, (ViewGroup.LayoutParams)childParams);
        childParams.leftMargin = 1;
        editText.setTag((Object)EDT_VIEW_TAG);
        rootLayout.addView((View)editText, (ViewGroup.LayoutParams)childParams);
        TextView versionName = new TextView(rootLayout.getContext());
        versionName.setContentDescription((CharSequence)"EyesAppiumHelper_Version");
        versionName.setHeight(1);
        versionName.setWidth(1);
        versionName.setTextColor(0);
        versionName.setBackgroundColor(0);
        versionName.setClickable(false);
        versionName.setFocusable(false);
        if (Build.VERSION.SDK_INT >= 28) {
            versionName.setScreenReaderFocusable(false);
        }
        versionName.setText((CharSequence)"1.3.1");
        versionName.setTag((Object)VERSION_VIEW_TAG);
        childParams.leftMargin = 2;
        rootLayout.addView((View)versionName, (ViewGroup.LayoutParams)childParams);
    }

    private static void removeViewsFromActivity(Activity activity) {
        FrameLayout rootLayout = (FrameLayout)activity.findViewById(0x1020002);
        View view = rootLayout.findViewWithTag((Object)OFFSET_VIEW_TAG);
        if (view != null) {
            rootLayout.removeView(view);
        }
        if ((view = rootLayout.findViewWithTag((Object)EDT_VIEW_TAG)) != null) {
            rootLayout.removeView(view);
        }
        if ((view = rootLayout.findViewWithTag((Object)VERSION_VIEW_TAG)) != null) {
            rootLayout.removeView(view);
        }
    }
}

