/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.appium.helper.androidx;

import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.GridView;
import android.widget.ListView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import androidx.viewpager2.widget.ViewPager2;
import java.lang.reflect.Field;
import java.util.HashSet;

class OffsetProvider {
    private static OffsetProvider mOffsetProvider = null;

    OffsetProvider() {
    }

    static OffsetProvider getInstance() {
        if (mOffsetProvider == null) {
            mOffsetProvider = new OffsetProvider();
        }
        return mOffsetProvider;
    }

    public int getScrollableOffset(Activity activity, View view) {
        if (view == null) {
            return 0;
        }
        if (view instanceof ListView) {
            return this.getListViewFullScrollableHeight((ListView)view);
        }
        if (view instanceof GridView) {
            return this.getGridViewFullScrollableHeight((GridView)view);
        }
        try {
            if (view instanceof ViewPager2) {
                return this.getViewPager2FullScrollableHeight(activity, (ViewPager2)view);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            if (view instanceof RecyclerView) {
                return this.getRecyclerViewFullScrollableHeight(activity, (RecyclerView)view);
            }
        }
        catch (InterruptedException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        return view.getHeight();
    }

    private int getListViewFullScrollableHeight(ListView listView) {
        int allItemsHeight = 0;
        int itemsCount = listView.getAdapter().getCount();
        for (int i = 0; i < itemsCount; ++i) {
            View childView = listView.getAdapter().getView(i, null, (ViewGroup)listView);
            childView.measure(View.MeasureSpec.makeMeasureSpec((int)listView.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            childView.layout(0, 0, childView.getMeasuredWidth(), childView.getMeasuredHeight());
            childView.setDrawingCacheEnabled(true);
            childView.buildDrawingCache();
            allItemsHeight += childView.getMeasuredHeight();
        }
        return allItemsHeight;
    }

    private int getGridViewFullScrollableHeight(GridView gridView) {
        int columnWidth;
        int allItemsHeight = 0;
        int itemsCount = gridView.getAdapter().getCount();
        int numColumns = gridView.getNumColumns();
        if (Build.VERSION.SDK_INT >= 16) {
            columnWidth = gridView.getColumnWidth();
        } else {
            try {
                Field field = GridView.class.getDeclaredField("mColumnWidth");
                field.setAccessible(true);
                Integer value = (Integer)field.get(this);
                field.setAccessible(false);
                columnWidth = value;
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        boolean shouldAddHeight = true;
        for (int i = 0; i < itemsCount; ++i) {
            int availableItems;
            View childView = gridView.getAdapter().getView(i, null, (ViewGroup)gridView);
            childView.measure(View.MeasureSpec.makeMeasureSpec((int)columnWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            childView.layout(0, 0, childView.getMeasuredWidth(), childView.getMeasuredHeight());
            if ((i + 1) % numColumns == 0) {
                allItemsHeight += childView.getMeasuredHeight();
            }
            if ((availableItems = itemsCount - (i + 1)) == 0 || availableItems >= numColumns || !shouldAddHeight) continue;
            allItemsHeight += childView.getMeasuredHeight();
            shouldAddHeight = false;
        }
        return allItemsHeight;
    }

    private int getRecyclerViewFullScrollableHeight(Activity activity, final RecyclerView recyclerView) throws InterruptedException {
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                recyclerView.scrollToPosition(0);
            }
        });
        HashSet<SizeItem> itemSet = new HashSet<SizeItem>();
        int itemsCount = 0;
        if (recyclerView.getAdapter() != null) {
            itemsCount = recyclerView.getAdapter().getItemCount();
        }
        int numColumns = 1;
        if (recyclerView.getLayoutManager() instanceof GridLayoutManager) {
            numColumns = ((GridLayoutManager)recyclerView.getLayoutManager()).getSpanCount();
        } else if (recyclerView.getLayoutManager() instanceof StaggeredGridLayoutManager) {
            numColumns = ((StaggeredGridLayoutManager)recyclerView.getLayoutManager()).getSpanCount();
        }
        int allItemsHeight = 0;
        int scrollAmount = (int)Math.ceil((double)itemsCount / (double)recyclerView.getChildCount());
        for (int scrollStep = 0; scrollStep <= scrollAmount; ++scrollStep) {
            for (int i = 0; i < itemsCount; ++i) {
                Thread.sleep(100L);
                if (recyclerView.getLayoutManager() == null || recyclerView.getLayoutManager().findViewByPosition(i) == null) continue;
                itemSet.add(new SizeItem(i, recyclerView.getLayoutManager().findViewByPosition(i).getHeight()));
            }
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    recyclerView.scrollBy(0, recyclerView.getHeight());
                }
            });
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                recyclerView.scrollToPosition(0);
            }
        });
        if (numColumns != 1) {
            while (itemSet.size() % numColumns != 0) {
                SizeItem item = null;
                for (SizeItem tmp : itemSet) {
                    if (tmp.getPosition() != itemSet.size() - 1) continue;
                    item = tmp;
                    break;
                }
                if (item == null) continue;
                itemSet.add(new SizeItem(itemSet.size(), item.getHeight()));
            }
        }
        for (SizeItem item : itemSet) {
            if (numColumns != 1) {
                if (item.getPosition() % numColumns != 0) continue;
                allItemsHeight += item.getHeight();
                continue;
            }
            allItemsHeight += item.getHeight();
        }
        return allItemsHeight;
    }

    private int getViewPager2FullScrollableHeight(Activity activity, ViewPager2 viewPager2) {
        return viewPager2.getHeight();
    }

    private class SizeItem {
        private int position;
        private int height;

        SizeItem(int position, int height) {
            this.position = position;
            this.height = height;
        }

        int getPosition() {
            return this.position;
        }

        int getHeight() {
            return this.height;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SizeItem sizeItem = (SizeItem)o;
            if (this.position != sizeItem.position) {
                return false;
            }
            return this.height == sizeItem.height;
        }

        public int hashCode() {
            int result = this.position;
            result = 31 * result + this.height;
            return result;
        }
    }
}

