/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.appium.helper.androidx;

import android.view.View;
import android.view.ViewGroup;
import com.applitools.appium.helper.androidx.LayoutTraverser;
import java.util.List;

final class ViewUtils {
    private ViewUtils() {
    }

    public static <T extends ViewGroup> T find(ViewGroup root, List<Class<T>> types) {
        FinderByType finderByType = new FinderByType(types);
        LayoutTraverser.build(finderByType).traverse(root);
        return (T)((ViewGroup)finderByType.getView());
    }

    public static <T extends ViewGroup> T find(ViewGroup root, String resourceName) {
        FindByType findByType = new FindByType(resourceName);
        LayoutTraverser.build(findByType).traverse(root);
        return (T)((ViewGroup)findByType.getView());
    }

    public static boolean checkViewForType(ViewGroup viewGroup, List<Class> types) {
        for (Class clazz : types) {
            if (!clazz.isInstance(viewGroup)) continue;
            return true;
        }
        return false;
    }

    private static class FindByType<T extends View>
    implements LayoutTraverser.Processor {
        private T mView = null;
        private String mResName;

        private FindByType(String resName) {
            this.mResName = resName;
        }

        @Override
        public void process(View view) {
            try {
                if (view.getId() != 0 && view.getContext().getResources().getResourceEntryName(view.getId()).equals(this.mResName)) {
                    this.mView = view;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        T getView() {
            return this.mView;
        }
    }

    private static class FinderByType<T extends View>
    implements LayoutTraverser.Processor {
        private final List<Class<T>> mTypes;
        private T mView = null;

        private FinderByType(List<Class<T>> types) {
            this.mTypes = types;
        }

        @Override
        public void process(View view) {
            for (Class<T> tClass : this.mTypes) {
                if (!tClass.isInstance(view)) continue;
                this.mView = view;
                break;
            }
        }

        T getView() {
            return this.mView;
        }
    }
}

