package com.applovin.adview;

import android.content.Context;

import com.applovin.impl.adview.InterstitialAdDialogCreatorImpl;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;

/**
 * This class represents an interstitial ad that is rendered on top of the current activity.
 *
 * @author Basil Shikin
 */
public class AppLovinInterstitialAd
{
    // Parent objects
    private AppLovinInterstitialAdDialog adDialog = null;

    /**
     * Show a new interstitial ad. This method will display a dialog on top of current activity's view with an advertisement in it.
     *
     * @param context Parent activity or application context. Must not be null.
     */
    public static void show(final Context context)
    {
        show( context, null );
    }

    /**
     * Create a new interstitial dialog that can be shown to the user. This is primarily useful in advanced integrations as the Ad Dialog allows finer control - including manually pre-caching and rendering ads. If all you want to do is show an interstitial the default way, you're looking for
     * <code>show()</code>.
     *
     * @param sdk     An SDK instance to use.
     * @param context A non-stale reference to the current top activity.
     *
     * @return A new instance of {@link com.applovin.adview.AppLovinInterstitialAdDialog}.
     */
    public static AppLovinInterstitialAdDialog create(final AppLovinSdk sdk, final Context context)
    {
        // Check input
        if ( sdk == null ) throw new IllegalArgumentException( "No sdk specified" );
        if ( context == null ) throw new IllegalArgumentException( "No context specified" );

        final InterstitialAdDialogCreator creator = new InterstitialAdDialogCreatorImpl();
        return creator.createInterstitialAdDialog( sdk, context );
    }

    /**
     * @deprecated Checking whether an ad is ready for display has been deprecated and will be removed in a future SDK version. Please use {@link AppLovinInterstitialAd#show(Context)}, or create an instance of {@link AppLovinInterstitialAdDialog} and use {@link AppLovinInterstitialAdDialog#show()} or {@link AppLovinInterstitialAdDialog#showAndRender(AppLovinAd)} to display an ad.
     */
    @Deprecated
    public static boolean isAdReadyToDisplay(final Context context)
    {
        return AppLovinSdk.getInstance( context ).getAdService().hasPreloadedAd( AppLovinAdSize.INTERSTITIAL );
    }

    /**
     * @deprecated Placements have been deprecated and will be removed in a future SDK version. Please configure zones from the UI and use them instead.
     */
    @Deprecated
    public static void show(final Context context, final String placement)
    {
        // Check input
        if ( context == null ) throw new IllegalArgumentException( "No context specified" );

        final AppLovinSdk sdk = AppLovinSdk.getInstance( context );

        if ( sdk != null && !sdk.hasCriticalErrors() )
        {
            show( sdk, context, placement );
        }
    }

    /**
     * @deprecated Placements have been deprecated and will be removed in a future SDK version. Please configure zones from the UI and use them instead.
     */
    @Deprecated
    public static void show(final AppLovinSdk sdk, final Context context, final String placement)
    {
        // Check input
        if ( sdk == null ) throw new IllegalArgumentException( "No sdk specified" );
        if ( context == null ) throw new IllegalArgumentException( "No context specified" );

        AppLovinSdkUtils.runOnUiThread( new Runnable()
        {
            public void run()
            {
                final InterstitialAdDialogCreator creator = new InterstitialAdDialogCreatorImpl();
                final AppLovinInterstitialAdDialog adDialog = creator.createInterstitialAdDialog( sdk, context );
                adDialog.show( placement );
            }
        } );
    }

    @Override
    public String toString()
    {
        return "AppLovinInterstitialAd{}";
    }
}
