package com.applovin.mediation;

/**
 * This class defines a format of an ad.
 */
public class MaxAdFormat
{
    /**
     * Represents a 320x50 banner advertisement.
     */
    public static final MaxAdFormat BANNER = new MaxAdFormat( "BANNER" );

    /**
     * Represents a 300x250 rectangular advertisement.
     */
    public static final MaxAdFormat MREC = new MaxAdFormat( "MREC" );

    /**
     * Represents a 728x90 leaderboard advertisement (for tablets).
     */
    public static final MaxAdFormat LEADER = new MaxAdFormat( "LEADER" );

    /**
     * Represents a full-screen advertisement.
     */
    public static final MaxAdFormat INTERSTITIAL = new MaxAdFormat( "INTER" );

    /**
     * Similar to {@link MaxAdFormat#INTERSTITIAL}, except that users are given a reward at the end of the advertisement.
     */
    public static final MaxAdFormat REWARDED = new MaxAdFormat( "REWARDED" );

    /**
     * Represents a native advertisement.
     */
    public static final MaxAdFormat NATIVE = new MaxAdFormat( "NATIVE" );

    private final String label;

    private MaxAdFormat(final String label)
    {
        this.label = label;
    }

    public String getLabel()
    {
        return label;
    }

    @Override
    public String toString()
    {
        return "MaxAdFormat{" +
                "label='" + label + '\'' +
                '}';
    }
}
