package com.applovin.mediation;

/**
 * This object represents a reward given to the user.
 */
public class MaxReward
{
    /**
     * This constant represents a label that is used when a label is not given by the third-party network.
     */
    public static final String DEFAULT_LABEL = "";

    /**
     * This constant represents a amount that is used when no amount is given by the third-party network.
     */
    public static final int DEFAULT_AMOUNT = 0;

    private final String label;
    private final int    amount;

    private MaxReward(final int amount, final String label)
    {
        // Input check
        if ( amount < 0 ) throw new IllegalArgumentException( "Reward amount must be greater than or equal to 0" );

        this.label = label;
        this.amount = amount;
    }

    /**
     * Get rewarded label.
     *
     * @return Rewarded label or @{link DEFAULT_LABEL} if none specified.
     */
    public final String getLabel()
    {
        return label;
    }

    /**
     * Get rewarded amount.
     *
     * @return Rewarded amount or @{link DEFAULT_AMOUNT} if none specified.
     */
    public final int getAmount()
    {
        return amount;
    }

    @Override
    public String toString()
    {
        return "MaxReward{" +
                "amount=" + amount +
                ", label='" + label + '\'' +
                '}';
    }

    /**
     * Creates an instance of this class with the default amount and label.
     */
    public static MaxReward createDefault()
    {
        return create( DEFAULT_AMOUNT, DEFAULT_LABEL );
    }

    /**
     * Creates an instance of this class with the provided amount and label.
     *
     * @param amount The amount of this reward. Must be greater than or equal to 0.
     * @param label  The label or currency of this reward.
     */
    public static MaxReward create(final int amount, final String label)
    {
        return new MaxReward( amount, label );
    }
}
