package com.applovin.nativeAds;

import java.util.List;

/**
 * Defines a listener which will be notified of successful and failed native ad load events.
 */
public interface AppLovinNativeAdLoadListener
{
    /**
     * Invoked when a new group of native ads has been loaded.
     */
    void onNativeAdsLoaded(final List<AppLovinNativeAd> nativeAds);

    /**
     * Invoked when a native ad has failed to load.
     *
     * @param errorCode Error code describing the failed load. Likely corresponds to a constant in {@link com.applovin.sdk.AppLovinErrorCodes}.
     */
    void onNativeAdsFailedToLoad(final int errorCode);
}
