package com.applovin.nativeAds;

/**
 * Defines a listener which will be notified when native ad resources are pre-cached.
 */
public interface AppLovinNativeAdPrecacheListener
{
    /**
     * Invoked when image resources have been successfully pre-cached in a native ad.
     * <p>
     * After this point, any resource URL getters, such as {@link AppLovinNativeAd#getImageUrl()}, will return local filesystem URLs.
     */
    void onNativeAdImagesPrecached(final AppLovinNativeAd ad);

    /**
     * Invoked when image resources have been successfully pre-cached in a native ad.
     * <p>
     * After this point, {@link AppLovinNativeAd#getVideoUrl()} ()} will return a local filesystem URL.
     */
    void onNativeAdVideoPreceached(final AppLovinNativeAd ad);

    /**
     * Invoked if pre-caching image resources fails.
     *
     * @param errorCode Error code describing the failed pre-caching attempt. Likely corresponds to a constant in {@link com.applovin.sdk.AppLovinErrorCodes}.
     */
    void onNativeAdImagePrecachingFailed(final AppLovinNativeAd ad, final int errorCode);

    /**
     * Invoked if pre-caching video resources fails.
     *
     * @param errorCode Error code describing the failed pre-caching attempt. Likely corresponds to a constant in {@link com.applovin.sdk.AppLovinErrorCodes}.
     */
    void onNativeAdVideoPrecachingFailed(final AppLovinNativeAd ad, final int errorCode);
}