package com.applovin.sdk;

import android.content.Context;
import android.util.Log;

import com.applovin.impl.sdk.ComplianceManager;
import com.applovin.impl.sdk.Logger;

/**
 * This class contains privacy settings for AppLovin.
 */
public class AppLovinPrivacySettings
{
    /**
     * Set whether or not user has provided consent for information sharing.
     *
     * @param hasUserConsent 'true' if the user has provided consent for information sharing.
     * @param context        Parent activity or application context. Must not be null.
     */
    public static void setHasUserConsent(final boolean hasUserConsent, final Context context)
    {
        final boolean isValueChanged = ComplianceManager.setHasUserConsent( hasUserConsent, context );
        if ( isValueChanged )
        {
            AppLovinSdk.reinitializeAll( hasUserConsent );
        }
    }

    /**
     * Check if user has provided consent for information sharing.
     */
    public static boolean hasUserConsent(final Context context)
    {
        final Boolean hasUserConsent = ComplianceManager.hasUserConsent( context );
        if ( hasUserConsent != null )
        {
            return hasUserConsent;
        }
        else
        {
            return false;
        }
    }

    /**
     * Mark user as age restricted (i.e. under 16).
     *
     * @param isAgeRestrictedUser 'true' if the user is age restricted (i.e. under 16).
     * @param context             Parent activity or application context. Must not be null.
     */
    public static void setIsAgeRestrictedUser(final boolean isAgeRestrictedUser, final Context context)
    {
        final boolean isValueChanged = ComplianceManager.setIsAgeRestrictedUser( isAgeRestrictedUser, context );
        if ( isValueChanged )
        {
            AppLovinSdk.reinitializeAll();
        }
    }

    /**
     * Check if user is age restricted.
     *
     * @param context Parent activity or application context. Must not be null.
     */
    public static boolean isAgeRestrictedUser(final Context context)
    {
        final Boolean isAgeRestrictedUser = ComplianceManager.isAgeRestrictedUser( context );
        if ( isAgeRestrictedUser != null )
        {
            return isAgeRestrictedUser;
        }
        else
        {
            return false;
        }
    }
}
