/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.utils;

import android.os.Bundle;
import android.text.TextUtils;

public class BundleUtils {
    public static boolean getBoolean(String string, Bundle bundle) {
        return BundleUtils.getBoolean(string, false, bundle);
    }

    public static boolean getBoolean(String string, boolean bl, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string) || bundle == null || !bundle.containsKey(string)) {
            return bl;
        }
        Object object = bundle.get(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            int n2 = ((Number)object).intValue();
            return n2 != 0;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("1")) {
                return true;
            }
            if (string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("0")) {
                return false;
            }
            return bl;
        }
        return bl;
    }

    public static int getInt(String string, Bundle bundle) {
        return BundleUtils.getInt(string, 0, bundle);
    }

    public static int getInt(String string, int n2, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string) || bundle == null || !bundle.containsKey(string)) {
            return n2;
        }
        Object object = bundle.get(string);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return n2;
            }
        }
        return n2;
    }

    public static int getLong(String string, Bundle bundle) {
        return BundleUtils.getInt(string, 0, bundle);
    }

    public static long getLong(String string, long l2, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string) || bundle == null || !bundle.containsKey(string)) {
            return l2;
        }
        Object object = bundle.get(string);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return l2;
            }
        }
        return l2;
    }

    public static String getString(String string, Bundle bundle) {
        return BundleUtils.getString(string, null, bundle);
    }

    public static String getString(String string, String string2, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string) || bundle == null || !bundle.containsKey(string)) {
            return string2;
        }
        Object object = bundle.get(string);
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }
}

