/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.Map;

public class AppLovinMediationAdapter
extends MediationAdapterBase
implements MaxAdViewAdapter,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxSignalProvider {
    private AppLovinAd mLoadedInterstitialAd;
    private AppLovinAd mLoadedRewardedAd;
    private AppLovinAdView mLoadedAdView;
    private MaxReward mPendingReward;

    public AppLovinMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    @Override
    public String getSdkVersion() {
        return AppLovinSdk.VERSION;
    }

    @Override
    public String getAdapterVersion() {
        return this.getSdkVersion();
    }

    @Override
    public void onDestroy() {
        this.mLoadedInterstitialAd = null;
        this.mLoadedRewardedAd = null;
        if (this.mLoadedAdView != null) {
            this.mLoadedAdView.destroy();
            this.mLoadedAdView = null;
        }
    }

    @Override
    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        this.getWrappingSdk().setMediationProvider("max");
        onCompletionListener.onCompletion();
    }

    @Override
    public void loadAdViewAd(MaxAdapterResponseParameters maxAdapterResponseParameters, MaxAdFormat maxAdFormat, final Activity activity, final MaxAdViewAdapterListener maxAdViewAdapterListener) {
        AppLovinAdLoadListener appLovinAdLoadListener = new AppLovinAdLoadListener(){

            @Override
            public void adReceived(final AppLovinAd appLovinAd) {
                AppLovinSdkUtils.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AppLovinMediationAdapter.this.mLoadedAdView = new AppLovinAdView(AppLovinMediationAdapter.this.getWrappingSdk(), appLovinAd.getSize(), (Context)activity);
                        AppLovinMediationAdapter.this.mLoadedAdView.setAdDisplayListener(new AppLovinAdDisplayListener(){

                            @Override
                            public void adDisplayed(AppLovinAd appLovinAd) {
                                maxAdViewAdapterListener.onAdViewAdDisplayed();
                            }

                            @Override
                            public void adHidden(AppLovinAd appLovinAd) {
                                maxAdViewAdapterListener.onAdViewAdHidden();
                            }
                        });
                        AppLovinMediationAdapter.this.mLoadedAdView.setAdClickListener(new AppLovinAdClickListener(){

                            @Override
                            public void adClicked(AppLovinAd appLovinAd) {
                                maxAdViewAdapterListener.onAdViewAdClicked();
                            }
                        });
                        AppLovinMediationAdapter.this.mLoadedAdView.setAdViewEventListener(new AppLovinAdViewEventListener(){

                            @Override
                            public void adOpenedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
                                maxAdViewAdapterListener.onAdViewAdExpanded();
                            }

                            @Override
                            public void adClosedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
                                maxAdViewAdapterListener.onAdViewAdCollapsed();
                            }

                            @Override
                            public void adLeftApplication(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
                            }

                            @Override
                            public void adFailedToDisplay(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView, AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
                                maxAdViewAdapterListener.onAdViewAdDisplayFailed(AppLovinMediationAdapter.toMaxError(appLovinAdViewDisplayErrorCode));
                            }
                        });
                        maxAdViewAdapterListener.onAdViewAdLoaded((View)AppLovinMediationAdapter.this.mLoadedAdView);
                        AppLovinMediationAdapter.this.mLoadedAdView.renderAd(appLovinAd);
                    }
                });
            }

            @Override
            public void failedToReceiveAd(int n2) {
                maxAdViewAdapterListener.onAdViewAdLoadFailed(AppLovinMediationAdapter.toMaxError(n2));
            }
        };
        if (!TextUtils.isEmpty((CharSequence)maxAdapterResponseParameters.getBidResponse())) {
            this.getWrappingSdk().getAdService().loadNextAdForAdToken(maxAdapterResponseParameters.getBidResponse(), appLovinAdLoadListener);
        } else if (!TextUtils.isEmpty((CharSequence)maxAdapterResponseParameters.getThirdPartyAdPlacementId())) {
            this.getWrappingSdk().getAdService().loadNextAdForZoneId(maxAdapterResponseParameters.getThirdPartyAdPlacementId(), appLovinAdLoadListener);
        } else {
            AppLovinAdSize appLovinAdSize = null;
            if (maxAdFormat == MaxAdFormat.BANNER) {
                appLovinAdSize = AppLovinAdSize.BANNER;
            } else if (maxAdFormat == MaxAdFormat.MREC) {
                appLovinAdSize = AppLovinAdSize.MREC;
            } else if (maxAdFormat == MaxAdFormat.LEADER) {
                appLovinAdSize = AppLovinAdSize.LEADER;
            }
            if (appLovinAdSize != null) {
                this.getWrappingSdk().getAdService().loadNextAd(appLovinAdSize, appLovinAdLoadListener);
            } else {
                this.log("Failed to load ad for format: " + maxAdFormat);
            }
        }
    }

    @Override
    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, final MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        AppLovinAdLoadListener appLovinAdLoadListener = new AppLovinAdLoadListener(){

            @Override
            public void adReceived(AppLovinAd appLovinAd) {
                AppLovinMediationAdapter.this.mLoadedInterstitialAd = appLovinAd;
                maxInterstitialAdapterListener.onInterstitialAdLoaded();
            }

            @Override
            public void failedToReceiveAd(int n2) {
                maxInterstitialAdapterListener.onInterstitialAdLoadFailed(AppLovinMediationAdapter.toMaxError(n2));
            }
        };
        if (!TextUtils.isEmpty((CharSequence)maxAdapterResponseParameters.getBidResponse())) {
            this.getWrappingSdk().getAdService().loadNextAdForAdToken(maxAdapterResponseParameters.getBidResponse(), appLovinAdLoadListener);
        } else if (!TextUtils.isEmpty((CharSequence)maxAdapterResponseParameters.getThirdPartyAdPlacementId())) {
            this.getWrappingSdk().getAdService().loadNextAdForZoneId(maxAdapterResponseParameters.getThirdPartyAdPlacementId(), appLovinAdLoadListener);
        } else {
            this.getWrappingSdk().getAdService().loadNextAd(AppLovinAdSize.INTERSTITIAL, appLovinAdLoadListener);
        }
    }

    @Override
    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, final MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        if (this.mLoadedInterstitialAd != null) {
            AppLovinInterstitialAdDialog appLovinInterstitialAdDialog = AppLovinInterstitialAd.create(this.getWrappingSdk(), activity.getApplicationContext());
            appLovinInterstitialAdDialog.setAdDisplayListener(new AppLovinAdDisplayListener(){

                @Override
                public void adDisplayed(AppLovinAd appLovinAd) {
                    maxInterstitialAdapterListener.onInterstitialAdDisplayed();
                }

                @Override
                public void adHidden(AppLovinAd appLovinAd) {
                    maxInterstitialAdapterListener.onInterstitialAdHidden();
                }
            });
            appLovinInterstitialAdDialog.setAdClickListener(new AppLovinAdClickListener(){

                @Override
                public void adClicked(AppLovinAd appLovinAd) {
                    maxInterstitialAdapterListener.onInterstitialAdClicked();
                }
            });
            appLovinInterstitialAdDialog.showAndRender(this.mLoadedInterstitialAd);
        } else {
            maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    @Override
    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, final MaxRewardedAdapterListener maxRewardedAdapterListener) {
        AppLovinAdLoadListener appLovinAdLoadListener = new AppLovinAdLoadListener(){

            @Override
            public void adReceived(AppLovinAd appLovinAd) {
                AppLovinMediationAdapter.this.mLoadedRewardedAd = appLovinAd;
                maxRewardedAdapterListener.onRewardedAdLoaded();
            }

            @Override
            public void failedToReceiveAd(int n2) {
                maxRewardedAdapterListener.onRewardedAdLoadFailed(AppLovinMediationAdapter.toMaxError(n2));
            }
        };
        if (!TextUtils.isEmpty((CharSequence)maxAdapterResponseParameters.getBidResponse())) {
            this.getWrappingSdk().getAdService().loadNextAdForAdToken(maxAdapterResponseParameters.getBidResponse(), appLovinAdLoadListener);
        } else if (!TextUtils.isEmpty((CharSequence)maxAdapterResponseParameters.getThirdPartyAdPlacementId())) {
            this.getWrappingSdk().getAdService().loadNextAdForZoneId(maxAdapterResponseParameters.getThirdPartyAdPlacementId(), appLovinAdLoadListener);
        } else {
            this.getWrappingSdk().getAdService().loadNextAdForZoneId("inter_videoa", appLovinAdLoadListener);
        }
    }

    @Override
    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        if (this.mLoadedRewardedAd != null) {
            AppLovinIncentivizedInterstitial appLovinIncentivizedInterstitial = AppLovinIncentivizedInterstitial.create(this.getWrappingSdk());
            RewardListenerWrapper rewardListenerWrapper = new RewardListenerWrapper(maxRewardedAdapterListener);
            appLovinIncentivizedInterstitial.show(this.mLoadedRewardedAd, (Context)activity, (AppLovinAdRewardListener)rewardListenerWrapper, (AppLovinAdVideoPlaybackListener)rewardListenerWrapper, (AppLovinAdDisplayListener)rewardListenerWrapper, (AppLovinAdClickListener)rewardListenerWrapper);
        } else {
            maxRewardedAdapterListener.onRewardedAdLoadFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    @Override
    public void collectSignal(MaxAdapterSignalCollectionParameters maxAdapterSignalCollectionParameters, Activity activity, MaxSignalCollectionListener maxSignalCollectionListener) {
        String string = this.getWrappingSdk().getAdService().getBidToken();
        maxSignalCollectionListener.onSignalCollected(string);
    }

    private static MaxAdapterError toMaxError(AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
        return MaxAdapterError.UNSPECIFIED;
    }

    private static MaxAdapterError toMaxError(int n2) {
        int n3 = n2 == -103 ? -5207 : (n2 == 204 ? 204 : (n2 == -1 ? -5209 : (n2 >= 500 ? -5208 : -5200)));
        return new MaxAdapterError(n3, n2);
    }

    private class RewardListenerWrapper
    implements AppLovinAdClickListener,
    AppLovinAdDisplayListener,
    AppLovinAdRewardListener,
    AppLovinAdVideoPlaybackListener {
        private final MaxRewardedAdapterListener listener;
        private boolean isFullyWatched = false;

        private RewardListenerWrapper(MaxRewardedAdapterListener maxRewardedAdapterListener) {
            this.listener = maxRewardedAdapterListener;
        }

        @Override
        public void adDisplayed(AppLovinAd appLovinAd) {
            this.listener.onRewardedAdDisplayed();
        }

        @Override
        public void adHidden(AppLovinAd appLovinAd) {
            if (this.isFullyWatched && AppLovinMediationAdapter.this.mPendingReward != null) {
                this.listener.onUserRewarded(AppLovinMediationAdapter.this.mPendingReward);
                AppLovinMediationAdapter.this.mPendingReward = null;
            }
            this.listener.onRewardedAdHidden();
        }

        @Override
        public void adClicked(AppLovinAd appLovinAd) {
            this.listener.onRewardedAdClicked();
        }

        @Override
        public void userRewardVerified(AppLovinAd appLovinAd, Map<String, String> map) {
            String string = map.get("currency");
            String string2 = map.get("amount");
            AppLovinMediationAdapter.this.log("Rewarded verified " + string2 + " " + string);
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
                int n2 = 0;
                try {
                    n2 = (int)Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    AppLovinMediationAdapter.this.log("Failed to parse AppLovin reward amount: " + string2, numberFormatException);
                }
                AppLovinMediationAdapter.this.mPendingReward = MaxReward.create(n2, string);
            } else {
                AppLovinMediationAdapter.this.mPendingReward = MaxReward.createDefault();
            }
        }

        @Override
        public void userOverQuota(AppLovinAd appLovinAd, Map<String, String> map) {
            AppLovinMediationAdapter.this.log("User is over quota: " + map);
            AppLovinMediationAdapter.this.mPendingReward = null;
        }

        @Override
        public void userRewardRejected(AppLovinAd appLovinAd, Map<String, String> map) {
            AppLovinMediationAdapter.this.log("Reward rejected: " + map);
            AppLovinMediationAdapter.this.mPendingReward = null;
        }

        @Override
        public void validationRequestFailed(AppLovinAd appLovinAd, int n2) {
            AppLovinMediationAdapter.this.log("Reward validation request failed with code: " + n2);
            AppLovinMediationAdapter.this.mPendingReward = null;
        }

        @Override
        public void userDeclinedToViewAd(AppLovinAd appLovinAd) {
            AppLovinMediationAdapter.this.log("User declined to view rewarded ad");
            AppLovinMediationAdapter.this.mPendingReward = null;
            this.listener.onRewardedAdDisplayFailed(MaxAdapterError.REWARD_ERROR);
        }

        @Override
        public void videoPlaybackBegan(AppLovinAd appLovinAd) {
            this.listener.onRewardedAdVideoStarted();
        }

        @Override
        public void videoPlaybackEnded(AppLovinAd appLovinAd, double d2, boolean bl) {
            this.isFullyWatched = bl;
            this.listener.onRewardedAdVideoCompleted();
        }
    }
}

