/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.impl.sdk.utils.n;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.sdk.AppLovinSdk;

public abstract class MediationAdapterBase
implements MaxAdapter {
    protected static final String KEY_MUTED = "muted";
    private final AppLovinSdk mWrappingSdk;
    private final String mTag;
    private MaxReward reward;
    private boolean alwaysRewardUser;

    protected static String mediationTag() {
        return "AppLovinSdk_" + AppLovinSdk.VERSION;
    }

    public MediationAdapterBase(AppLovinSdk appLovinSdk) {
        this.mWrappingSdk = appLovinSdk;
        this.mTag = this.getClass().getSimpleName();
    }

    protected AppLovinSdk getWrappingSdk() {
        return this.mWrappingSdk;
    }

    protected void log(String string) {
        Log.i((String)this.mTag, (String)string);
    }

    protected void log(String string, Throwable throwable) {
        Log.i((String)this.mTag, (String)string, (Throwable)throwable);
    }

    protected void checkExistence(Class<?> ... classArray) {
        if (classArray != null && classArray.length > 0) {
            for (Class<?> clazz : classArray) {
                this.log("Found: " + clazz.getName());
            }
        }
    }

    protected void checkActivities(Context context, Class<?> ... classArray) {
    }

    protected MaxReward getReward() {
        return this.reward != null ? this.reward : MaxReward.createDefault();
    }

    protected boolean shouldAlwaysRewardUser() {
        return this.alwaysRewardUser;
    }

    protected void configureReward(MaxAdapterResponseParameters maxAdapterResponseParameters) {
        Bundle bundle = maxAdapterResponseParameters.getServerParameters();
        this.alwaysRewardUser = BundleUtils.getBoolean("always_reward_user", bundle);
        int n2 = BundleUtils.getInt("amount", 0, bundle);
        String string = BundleUtils.getString("currency", "", bundle);
        this.log("Creating reward: " + n2 + " " + string);
        this.reward = MaxReward.create(n2, string);
    }

    String getVersionString(Class clazz, String string) {
        String string2 = n.b(clazz, string);
        if (string2 == null) {
            this.log("Failed to retrieve version string.");
        }
        return string2;
    }
}

