/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.util.Log;
import android.view.View;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class MediationAdapterRouter {
    protected final String mTag = this.getClass().getSimpleName();
    protected MaxAdapter.OnCompletionListener mOnCompletionListener;
    private final Map<String, List<MediationAdapterRouterListenerWrapper>> listeners = new HashMap<String, List<MediationAdapterRouterListenerWrapper>>();
    private final Object listenersLock = new Object();
    private final Set<MaxAdapter> loadedAdapters = new HashSet<MaxAdapter>();
    private final Object loadedAdaptersLock = new Object();
    private final Set<MaxAdapter> showingAdapters = new HashSet<MaxAdapter>();
    private final Object showingAdaptersLock = new Object();

    protected MediationAdapterRouter() {
    }

    abstract void initialize(MaxAdapterInitializationParameters var1, Activity var2, MaxAdapter.OnCompletionListener var3);

    public void addInterstitialAdapter(MaxAdapter maxAdapter, MaxInterstitialAdapterListener maxInterstitialAdapterListener, String string) {
        this.addAdapter(maxAdapter, maxInterstitialAdapterListener, string, RouterAdLoadType.INTERSTITIAL, null);
    }

    public void addRewardedAdapter(MaxAdapter maxAdapter, MaxRewardedAdapterListener maxRewardedAdapterListener, String string) {
        this.addAdapter(maxAdapter, maxRewardedAdapterListener, string, RouterAdLoadType.REWARDED, null);
    }

    public void addAdViewAdapter(MaxAdapter maxAdapter, MaxAdViewAdapterListener maxAdViewAdapterListener, String string, View view) {
        this.addAdapter(maxAdapter, maxAdViewAdapterListener, string, RouterAdLoadType.ADVIEW, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAdView(View view, String string) {
        Object object = this.listenersLock;
        synchronized (object) {
            List<MediationAdapterRouterListenerWrapper> list = this.getListenerWrappers(string);
            if (list != null && list.size() > 0) {
                for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                    if (mediationAdapterRouterListenerWrapper.getAdView() != null) continue;
                    mediationAdapterRouterListenerWrapper.setAdView(view);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShowingAdapter(MaxAdapter maxAdapter) {
        Object object = this.showingAdaptersLock;
        synchronized (object) {
            this.showingAdapters.add(maxAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdapter(MaxAdapter maxAdapter, String string) {
        this.removeLoadedAdapter(maxAdapter);
        this.removeShowingAdapter(maxAdapter);
        Object object = this.listenersLock;
        synchronized (object) {
            List<MediationAdapterRouterListenerWrapper> list = this.listeners.get(string);
            if (list != null && list.size() > 0) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = null;
                for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper2 : list) {
                    if (mediationAdapterRouterListenerWrapper2.getAdapter() != maxAdapter) continue;
                    mediationAdapterRouterListenerWrapper = mediationAdapterRouterListenerWrapper2;
                    break;
                }
                if (mediationAdapterRouterListenerWrapper != null) {
                    list.remove(mediationAdapterRouterListenerWrapper);
                }
            }
        }
    }

    protected void onAdLoaded(String string) {
        List<MediationAdapterRouterListenerWrapper> list = this.getLoadingListenerWrappers(string);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                this.addLoadedAdapter(mediationAdapterRouterListenerWrapper.getAdapter());
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial loaded");
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdLoaded();
                    continue;
                }
                if (routerAdLoadType == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded loaded");
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdLoaded();
                    continue;
                }
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView loaded");
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdLoaded(mediationAdapterRouterListenerWrapper.getAdView());
            }
        }
    }

    protected void onAdLoadFailed(String string, MaxAdapterError maxAdapterError) {
        List<MediationAdapterRouterListenerWrapper> list = this.getLoadingListenerWrappers(string);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial failed to load with error: " + maxAdapterError.toString());
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdLoadFailed(maxAdapterError);
                    continue;
                }
                if (routerAdLoadType == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded failed to load with error: " + maxAdapterError.toString());
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdLoadFailed(maxAdapterError);
                    continue;
                }
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView failed to load with error: " + maxAdapterError.toString());
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdLoadFailed(maxAdapterError);
            }
        }
    }

    protected void onAdDisplayed(String string) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial shown");
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdDisplayed();
                    continue;
                }
                if (routerAdLoadType == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded shown");
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdDisplayed();
                    continue;
                }
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView shown");
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdDisplayed();
            }
        }
    }

    protected void onAdDisplayFailed(String string, MaxAdapterError maxAdapterError) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial failed to display with error: " + maxAdapterError.toString());
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdDisplayFailed(maxAdapterError);
                    continue;
                }
                if (routerAdLoadType == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded failed to display with error: " + maxAdapterError.toString());
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdDisplayFailed(maxAdapterError);
                    continue;
                }
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView failed to display with error: " + maxAdapterError.toString());
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdDisplayFailed(maxAdapterError);
            }
        }
    }

    protected void onAdClicked(String string) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial clicked");
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdClicked();
                    continue;
                }
                if (routerAdLoadType == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded clicked");
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdClicked();
                    continue;
                }
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView clicked");
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdClicked();
            }
        }
    }

    protected void onAdHidden(String string) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial hidden");
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdHidden();
                    continue;
                }
                if (routerAdLoadType == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded hidden");
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdHidden();
                    continue;
                }
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView hidden");
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdHidden();
            }
        }
    }

    protected void onRewardedAdVideoStarted(String string) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType != RouterAdLoadType.REWARDED) continue;
                this.log("Rewarded video started");
                ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdVideoStarted();
            }
        }
    }

    protected void onRewardedAdVideoCompleted(String string) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType != RouterAdLoadType.REWARDED) continue;
                this.log("Rewarded video completed");
                ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdVideoCompleted();
            }
        }
    }

    protected void onUserRewarded(String string, MaxReward maxReward) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType != RouterAdLoadType.REWARDED) continue;
                this.log("Rewarded user with reward: " + maxReward);
                ((MaxRewardedAdapterListener)maxAdapterListener).onUserRewarded(maxReward);
            }
        }
    }

    protected void onAdViewAdExpanded(String string) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView expanded");
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdExpanded();
            }
        }
    }

    protected void onAdViewAdCollapsed(String string) {
        List<MediationAdapterRouterListenerWrapper> list = this.getShowingListenerWrappers(string);
        if (list != null && list.size() > 0) {
            for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView collapsed");
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdCollapsed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MaxReward getReward(String string) {
        Object object = this.listenersLock;
        synchronized (object) {
            MaxAdapter maxAdapter;
            List<MediationAdapterRouterListenerWrapper> list = this.getListenerWrappers(string);
            if (list != null && list.size() > 0 && (maxAdapter = list.get(0).getAdapter()) instanceof MediationAdapterBase) {
                return ((MediationAdapterBase)maxAdapter).getReward();
            }
        }
        return MaxReward.createDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldAlwaysRewardUser(String string) {
        Object object = this.listenersLock;
        synchronized (object) {
            MaxAdapter maxAdapter;
            List<MediationAdapterRouterListenerWrapper> list = this.getListenerWrappers(string);
            if (list != null && list.size() > 0 && (maxAdapter = list.get(0).getAdapter()) instanceof MediationAdapterBase) {
                return ((MediationAdapterBase)maxAdapter).shouldAlwaysRewardUser();
            }
        }
        return false;
    }

    protected void log(String string) {
        Log.i((String)this.mTag, (String)string);
    }

    protected void log(String string, Throwable throwable) {
        Log.i((String)this.mTag, (String)string, (Throwable)throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAdapter(MaxAdapter maxAdapter, MaxAdapterListener maxAdapterListener, String string, RouterAdLoadType routerAdLoadType, View view) {
        Object object = this.listenersLock;
        synchronized (object) {
            MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = new MediationAdapterRouterListenerWrapper(maxAdapter, maxAdapterListener, routerAdLoadType, view);
            List<Object> list = this.listeners.get(string) != null ? this.listeners.get(string) : new ArrayList(1);
            list.add(mediationAdapterRouterListenerWrapper);
            this.listeners.put(string, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLoadedAdapter(MaxAdapter maxAdapter) {
        Object object = this.loadedAdaptersLock;
        synchronized (object) {
            this.loadedAdapters.add(maxAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLoadedAdapter(MaxAdapter maxAdapter) {
        Object object = this.loadedAdaptersLock;
        synchronized (object) {
            this.loadedAdapters.remove(maxAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAdLoaded(MaxAdapter maxAdapter) {
        Object object = this.loadedAdaptersLock;
        synchronized (object) {
            return this.loadedAdapters.contains(maxAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeShowingAdapter(MaxAdapter maxAdapter) {
        Object object = this.showingAdaptersLock;
        synchronized (object) {
            this.showingAdapters.remove(maxAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAdShowing(MaxAdapter maxAdapter) {
        Object object = this.showingAdaptersLock;
        synchronized (object) {
            return this.showingAdapters.contains(maxAdapter);
        }
    }

    private List<MediationAdapterRouterListenerWrapper> getListenerWrappers(String string) {
        ArrayList arrayList = this.listeners.containsKey(string) ? new ArrayList(this.listeners.get(string)) : null;
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MediationAdapterRouterListenerWrapper> getLoadingListenerWrappers(String string) {
        ArrayList<MediationAdapterRouterListenerWrapper> arrayList = new ArrayList<MediationAdapterRouterListenerWrapper>();
        Object object = this.listenersLock;
        synchronized (object) {
            List<MediationAdapterRouterListenerWrapper> list = this.getListenerWrappers(string);
            if (list != null && list.size() > 0) {
                for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                    if (this.isAdLoaded(mediationAdapterRouterListenerWrapper.getAdapter())) continue;
                    arrayList.add(mediationAdapterRouterListenerWrapper);
                }
                return arrayList;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MediationAdapterRouterListenerWrapper> getShowingListenerWrappers(String string) {
        ArrayList<MediationAdapterRouterListenerWrapper> arrayList = new ArrayList<MediationAdapterRouterListenerWrapper>();
        Object object = this.listenersLock;
        synchronized (object) {
            List<MediationAdapterRouterListenerWrapper> list = this.getListenerWrappers(string);
            if (list != null && list.size() > 0) {
                for (MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper : list) {
                    if (!this.isAdShowing(mediationAdapterRouterListenerWrapper.getAdapter())) continue;
                    arrayList.add(mediationAdapterRouterListenerWrapper);
                }
                return arrayList;
            }
        }
        return null;
    }

    private final class MediationAdapterRouterListenerWrapper {
        private final MaxAdapter mAdapter;
        private final MaxAdapterListener mListener;
        private final RouterAdLoadType mLoadType;
        private View mAdView;

        MediationAdapterRouterListenerWrapper(MaxAdapter maxAdapter, MaxAdapterListener maxAdapterListener, RouterAdLoadType routerAdLoadType, View view) {
            this.mAdapter = maxAdapter;
            this.mListener = maxAdapterListener;
            this.mLoadType = routerAdLoadType;
            this.mAdView = view;
        }

        MaxAdapter getAdapter() {
            return this.mAdapter;
        }

        MaxAdapterListener getListener() {
            return this.mListener;
        }

        RouterAdLoadType getLoadType() {
            return this.mLoadType;
        }

        View getAdView() {
            return this.mAdView;
        }

        void setAdView(View view) {
            this.mAdView = view;
        }
    }

    private static enum RouterAdLoadType {
        INTERSTITIAL,
        REWARDED,
        ADVIEW;

    }
}

