/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.content.Context;
import android.util.Log;
import com.applovin.impl.sdk.j;
import com.applovin.impl.sdk.p;
import com.applovin.impl.sdk.utils.n;
import com.applovin.nativeAds.AppLovinNativeAdService;
import com.applovin.sdk.AppLovinAdService;
import com.applovin.sdk.AppLovinEventService;
import com.applovin.sdk.AppLovinPostbackService;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkSettings;
import com.applovin.sdk.AppLovinUserService;
import com.applovin.sdk.AppLovinVariableService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class AppLovinSdk {
    public static final String VERSION = AppLovinSdk.getVersion();
    public static final int VERSION_CODE = AppLovinSdk.getVersionCode();
    private static final String TAG = "AppLovinSdk";
    private static AppLovinSdk[] sdkInstances = new AppLovinSdk[0];
    private static final Object sdkInstancesLock = new Object();
    private final j mSdkImpl;

    public String getSdkKey() {
        return this.mSdkImpl.u();
    }

    public AppLovinSdkSettings getSettings() {
        return this.mSdkImpl.m();
    }

    public void setPluginVersion(String string) {
        this.mSdkImpl.a(string);
    }

    public void setMediationProvider(String string) {
        this.mSdkImpl.c(string);
    }

    public String getMediationProvider() {
        return this.mSdkImpl.o();
    }

    public AppLovinAdService getAdService() {
        return this.mSdkImpl.p();
    }

    public AppLovinNativeAdService getNativeAdService() {
        return this.mSdkImpl.q();
    }

    public AppLovinPostbackService getPostbackService() {
        return this.mSdkImpl.O();
    }

    public AppLovinEventService getEventService() {
        return this.mSdkImpl.r();
    }

    public AppLovinUserService getUserService() {
        return this.mSdkImpl.s();
    }

    public AppLovinVariableService getVariableService() {
        return this.mSdkImpl.t();
    }

    public void setUserIdentifier(String string) {
        this.mSdkImpl.b(string);
    }

    public String getUserIdentifier() {
        return this.mSdkImpl.k();
    }

    public void showMediationDebugger() {
        this.mSdkImpl.g();
    }

    public void initializeSdk() {
    }

    public void initializeSdk(SdkInitializationListener sdkInitializationListener) {
        this.mSdkImpl.a(sdkInitializationListener);
    }

    public static void initializeSdk(Context context) {
        AppLovinSdk.initializeSdk(context, null);
    }

    public static void initializeSdk(Context context, SdkInitializationListener sdkInitializationListener) {
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        AppLovinSdk appLovinSdk = AppLovinSdk.getInstance(context);
        if (appLovinSdk != null) {
            appLovinSdk.initializeSdk(sdkInitializationListener);
        } else {
            Log.e((String)TAG, (String)"Unable to initialize AppLovin SDK: SDK object not created");
        }
    }

    public AppLovinSdkConfiguration getConfiguration() {
        return this.mSdkImpl.n();
    }

    public static AppLovinSdk getInstance(Context context) {
        return AppLovinSdk.getInstance(new a(context), context);
    }

    public static AppLovinSdk getInstance(AppLovinSdkSettings appLovinSdkSettings, Context context) {
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        String string = n.a(context);
        return AppLovinSdk.getInstance(string, appLovinSdkSettings, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppLovinSdk getInstance(String string, AppLovinSdkSettings appLovinSdkSettings, Context context) {
        if (appLovinSdkSettings == null) {
            throw new IllegalArgumentException("No userSettings specified");
        }
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        Object object = sdkInstancesLock;
        synchronized (object) {
            AppLovinSdk appLovinSdk;
            AppLovinSdk[] throwable;
            if (sdkInstances.length == 1 && sdkInstances[0].getSdkKey().equals(string)) {
                return sdkInstances[0];
            }
            for (AppLovinSdk appLovinSdk2 : sdkInstances) {
                if (!appLovinSdk2.getSdkKey().equals(string)) continue;
                return appLovinSdk2;
            }
            try {
                throwable = new j();
                throwable.a(string, appLovinSdkSettings, context);
                appLovinSdk = new AppLovinSdk((j)throwable);
                throwable.a(appLovinSdk);
            }
            catch (Throwable throwable2) {
                Log.e((String)TAG, (String)"Failed to build AppLovin SDK. Try cleaning application data and starting the application again.", (Throwable)throwable2);
                throw new RuntimeException("Unable to build AppLovin SDK");
            }
            throwable = new AppLovinSdk[sdkInstances.length + 1];
            System.arraycopy(sdkInstances, 0, throwable, 0, sdkInstances.length);
            throwable[AppLovinSdk.sdkInstances.length] = appLovinSdk;
            sdkInstances = throwable;
            return appLovinSdk;
        }
    }

    public boolean isEnabled() {
        return this.mSdkImpl.d();
    }

    public boolean hasCriticalErrors() {
        return this.mSdkImpl.v();
    }

    Context getApplicationContext() {
        return this.mSdkImpl.A();
    }

    public p getLogger() {
        return this.mSdkImpl.w();
    }

    private AppLovinSdk(j j2) {
        if (j2 == null) {
            throw new IllegalArgumentException("No sdk specified");
        }
        this.mSdkImpl = j2;
    }

    private static String getVersion() {
        return "9.7.2";
    }

    private static int getVersionCode() {
        return 90702;
    }

    static void reinitializeAll() {
        AppLovinSdk.reinitializeAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reinitializeAll(Boolean bl) {
        Object object = sdkInstancesLock;
        synchronized (object) {
            for (AppLovinSdk appLovinSdk : sdkInstances) {
                appLovinSdk.mSdkImpl.b();
                if (bl == null || !bl.booleanValue()) continue;
                HashMap<String, String> hashMap = new HashMap<String, String>(1);
                hashMap.put("value", bl.toString());
                appLovinSdk.getEventService().trackEvent("huc", hashMap);
            }
        }
    }

    public static List<AppLovinSdk> a() {
        return Arrays.asList(sdkInstances);
    }

    public String toString() {
        return "AppLovinSdk{sdkKey='" + this.getSdkKey() + "', isEnabled=" + this.isEnabled() + ", isFirstSession=" + this.mSdkImpl.E() + '}';
    }

    private static class a
    extends AppLovinSdkSettings {
        public a(Context context) {
            super(context);
        }
    }

    public static interface SdkInitializationListener {
        public void onSdkInitialized(AppLovinSdkConfiguration var1);
    }
}

