/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;
import com.applovin.impl.sdk.utils.g;
import com.applovin.impl.sdk.utils.n;
import java.io.File;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AppLovinSdkUtils {
    private static final Handler a = new Handler(Looper.getMainLooper());

    public static int dpToPx(Context context, int n2) {
        return (int)TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int pxToDp(Context context, int n2) {
        return (int)Math.ceil((float)n2 / context.getResources().getDisplayMetrics().density);
    }

    public static boolean isTablet(Context context) {
        Configuration configuration = context.getResources().getConfiguration();
        return configuration != null && configuration.smallestScreenWidthDp >= 600;
    }

    public static boolean isValidString(String string) {
        return !TextUtils.isEmpty((CharSequence)string);
    }

    public static void safePopulateImageView(ImageView imageView, Uri uri, int n2) {
        AppLovinSdkUtils.a(imageView);
        File file = new File(uri.getPath());
        Bitmap bitmap = n.a(file, n2);
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        }
    }

    public static void safePopulateImageView(Context context, ImageView imageView, int n2, int n3) {
        AppLovinSdkUtils.a(imageView);
        Bitmap bitmap = n.a(context, n2, n3);
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        }
    }

    public static void safePopulateImageView(ImageView imageView, Bitmap bitmap) {
        AppLovinSdkUtils.a(imageView);
        if (imageView != null && bitmap != null) {
            imageView.setImageBitmap(bitmap);
        }
    }

    public static void runOnUiThread(Runnable runnable) {
        AppLovinSdkUtils.runOnUiThread(false, runnable);
    }

    public static void runOnUiThread(boolean bl, Runnable runnable) {
        if (!bl && n.b()) {
            runnable.run();
        } else {
            a.post(runnable);
        }
    }

    public static void runOnUiThreadDelayed(Runnable runnable, long l2) {
        if (l2 > 0L) {
            a.postDelayed(runnable, l2);
        } else {
            runnable.run();
        }
    }

    private static void a(ImageView imageView) {
        Drawable drawable;
        if (imageView != null && (drawable = imageView.getDrawable()) instanceof BitmapDrawable) {
            BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable;
            Bitmap bitmap = bitmapDrawable.getBitmap();
            bitmap.recycle();
        }
    }

    public static Map<String, String> toMap(JSONObject jSONObject) throws JSONException {
        return g.a(jSONObject);
    }
}

