/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.jersey.repackaged.com.google.common.collect;

import com.github.dockerjava.shaded.javax.annotation.Nullable;
import com.github.dockerjava.shaded.jersey.repackaged.com.google.common.base.Function;
import com.github.dockerjava.shaded.jersey.repackaged.com.google.common.base.Preconditions;
import com.github.dockerjava.shaded.jersey.repackaged.com.google.common.collect.ByFunctionOrdering;
import com.github.dockerjava.shaded.jersey.repackaged.com.google.common.collect.ComparatorOrdering;
import com.github.dockerjava.shaded.jersey.repackaged.com.google.common.collect.ImmutableList;
import com.github.dockerjava.shaded.jersey.repackaged.com.google.common.collect.Iterables;
import com.github.dockerjava.shaded.jersey.repackaged.com.google.common.collect.Lists;
import com.github.dockerjava.shaded.jersey.repackaged.com.google.common.collect.Maps;
import com.github.dockerjava.shaded.jersey.repackaged.com.google.common.collect.NaturalOrdering;
import com.github.dockerjava.shaded.jersey.repackaged.com.google.common.collect.ReverseOrdering;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class Ordering<T>
implements Comparator<T> {
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    protected Ordering() {
    }

    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    <T2 extends T> Ordering<Map.Entry<T2, ?>> onKeys() {
        return this.onResultOf(Maps.keyFunction());
    }

    @Override
    public abstract int compare(@Nullable T var1, @Nullable T var2);

    public <E extends T> List<E> sortedCopy(Iterable<E> elements) {
        Object[] array = Iterables.toArray(elements);
        Arrays.sort(array, this);
        return Lists.newArrayList(Arrays.asList(array));
    }

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> elements) {
        Object[] array;
        for (Object e : array = Iterables.toArray(elements)) {
            Preconditions.checkNotNull(e);
        }
        Arrays.sort(array, this);
        return ImmutableList.asImmutableList(array);
    }
}

