/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.bouncycastle.pqc.jcajce.provider.mceliece;

import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.github.dockerjava.shaded.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.github.dockerjava.shaded.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.github.dockerjava.shaded.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PrivateKey;
import com.github.dockerjava.shaded.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class McElieceCCA2KeysToParams {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof BCMcElieceCCA2PublicKey) {
            BCMcElieceCCA2PublicKey bCMcElieceCCA2PublicKey = (BCMcElieceCCA2PublicKey)publicKey;
            return new McElieceCCA2PublicKeyParameters(bCMcElieceCCA2PublicKey.getOIDString(), bCMcElieceCCA2PublicKey.getN(), bCMcElieceCCA2PublicKey.getT(), bCMcElieceCCA2PublicKey.getG(), bCMcElieceCCA2PublicKey.getMcElieceCCA2Parameters());
        }
        throw new InvalidKeyException("can't identify McElieceCCA2 public key: " + publicKey.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof BCMcElieceCCA2PrivateKey) {
            BCMcElieceCCA2PrivateKey bCMcElieceCCA2PrivateKey = (BCMcElieceCCA2PrivateKey)privateKey;
            return new McElieceCCA2PrivateKeyParameters(bCMcElieceCCA2PrivateKey.getOIDString(), bCMcElieceCCA2PrivateKey.getN(), bCMcElieceCCA2PrivateKey.getK(), bCMcElieceCCA2PrivateKey.getField(), bCMcElieceCCA2PrivateKey.getGoppaPoly(), bCMcElieceCCA2PrivateKey.getP(), bCMcElieceCCA2PrivateKey.getH(), bCMcElieceCCA2PrivateKey.getQInv(), bCMcElieceCCA2PrivateKey.getMcElieceCCA2Parameters());
        }
        throw new InvalidKeyException("can't identify McElieceCCA2 private key.");
    }
}

