/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.scijava.nativelib;

import com.github.dockerjava.shaded.org.scijava.nativelib.BaseJniExtractor;
import java.io.File;
import java.io.IOException;

public class DefaultJniExtractor
extends BaseJniExtractor {
    private File nativeDir;

    public DefaultJniExtractor() throws IOException {
        super(null);
        this.init("tmplib");
    }

    public DefaultJniExtractor(Class libraryJarClass, String tmplib) throws IOException {
        super(libraryJarClass);
        this.init(tmplib);
    }

    void init(String tmplib) throws IOException {
        this.nativeDir = new File(System.getProperty("java.library.tmpdir", tmplib));
        this.nativeDir.mkdirs();
        if (!this.nativeDir.isDirectory()) {
            throw new IOException("Unable to create native library working directory " + this.nativeDir);
        }
    }

    public File getJniDir() {
        return this.nativeDir;
    }

    public File getNativeDir() {
        return this.nativeDir;
    }
}

