/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.GenericResource;
import com.github.dockerjava.api.model.ObjectVersion;
import com.github.dockerjava.api.model.TaskSpec;
import com.github.dockerjava.api.model.TaskState;
import com.github.dockerjava.api.model.TaskStatus;
import com.github.dockerjava.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.github.dockerjava.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import com.github.dockerjava.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Task
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="ID")
    private String id = null;
    @JsonProperty(value="Version")
    private ObjectVersion version = null;
    @JsonProperty(value="CreatedAt")
    private String createdAt = null;
    @JsonProperty(value="UpdatedAt")
    private String updatedAt = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="Labels")
    private Map<String, String> labels = null;
    @JsonProperty(value="Spec")
    private TaskSpec spec = null;
    @JsonProperty(value="ServiceID")
    private String serviceId = null;
    @JsonProperty(value="Slot")
    private Integer slot = null;
    @JsonProperty(value="NodeID")
    private String nodeId = null;
    @JsonProperty(value="AssignedGenericResources")
    private List<GenericResource> assignedGenericResources = null;
    @JsonProperty(value="Status")
    private TaskStatus status = null;
    @JsonProperty(value="DesiredState")
    private TaskState desiredState = null;

    public String getId() {
        return this.id;
    }

    public ObjectVersion getVersion() {
        return this.version;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public TaskSpec getSpec() {
        return this.spec;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public TaskState getDesiredState() {
        return this.desiredState;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public Integer getSlot() {
        return this.slot;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Task withId(String id) {
        this.id = id;
        return this;
    }

    public Task withVersion(ObjectVersion version) {
        this.version = version;
        return this;
    }

    public Task withCreatedAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Task withUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public Task withName(String name) {
        this.name = name;
        return this;
    }

    public Task withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public Task withSpec(TaskSpec spec) {
        this.spec = spec;
        return this;
    }

    public Task withServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public Task withSlot(Integer slot) {
        this.slot = slot;
        return this;
    }

    public Task withNodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public Task withAssignedGenericResources(List<GenericResource> assignedGenericResources) {
        this.assignedGenericResources = assignedGenericResources;
        return this;
    }

    public Task withStatus(TaskStatus status) {
        this.status = status;
        return this;
    }

    public Task withDesiredState(TaskState desiredState) {
        this.desiredState = desiredState;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        return Objects.equals(this.id, task.id) && Objects.equals(this.version, task.version) && Objects.equals(this.createdAt, task.createdAt) && Objects.equals(this.updatedAt, task.updatedAt) && Objects.equals(this.name, task.name) && Objects.equals(this.labels, task.labels) && Objects.equals(this.spec, task.spec) && Objects.equals(this.serviceId, task.serviceId) && Objects.equals(this.slot, task.slot) && Objects.equals(this.nodeId, task.nodeId) && Objects.equals(this.assignedGenericResources, task.assignedGenericResources) && Objects.equals(this.status, task.status) && Objects.equals((Object)this.desiredState, (Object)task.desiredState);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.version, this.createdAt, this.updatedAt, this.name, this.labels, this.spec, this.serviceId, this.slot, this.nodeId, this.assignedGenericResources, this.status, this.desiredState});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Task {\n");
        sb.append("    ID: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    serviceId: ").append(this.toIndentedString(this.serviceId)).append("\n");
        sb.append("    slot: ").append(this.toIndentedString(this.slot)).append("\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.nodeId)).append("\n");
        sb.append("    assignedGenericResources: ").append(this.toIndentedString(this.assignedGenericResources)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    desiredState: ").append(this.toIndentedString((Object)this.desiredState)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

