/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.io.netty.util.internal.shaded.org.jctools.queues.atomic;

import com.github.dockerjava.shaded.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import com.github.dockerjava.shaded.io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import com.github.dockerjava.shaded.io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscChunkedAtomicArrayQueue;
import com.github.dockerjava.shaded.io.netty.util.internal.shaded.org.jctools.util.Pow2;
import com.github.dockerjava.shaded.io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class MpscGrowableAtomicArrayQueue<E>
extends MpscChunkedAtomicArrayQueue<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    public MpscGrowableAtomicArrayQueue(int maxCapacity) {
        super(Math.max(2, Pow2.roundToPowerOfTwo(maxCapacity / 8)), maxCapacity);
    }

    public MpscGrowableAtomicArrayQueue(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    @Override
    protected int getNextBufferSize(AtomicReferenceArray<E> buffer) {
        long maxSize = this.maxQueueCapacity / 2L;
        RangeUtil.checkLessThanOrEqual(buffer.length(), maxSize, "buffer.length");
        int newSize = 2 * (buffer.length() - 1);
        return newSize + 1;
    }

    @Override
    protected long getCurrentBufferCapacity(long mask) {
        return mask + 2L == this.maxQueueCapacity ? this.maxQueueCapacity : mask;
    }
}

