/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant;

import com.github.dockerjava.shaded.org.apache.tools.ant.BuildEvent;
import com.github.dockerjava.shaded.org.apache.tools.ant.BuildException;
import com.github.dockerjava.shaded.org.apache.tools.ant.BuildLogger;
import com.github.dockerjava.shaded.org.apache.tools.ant.DefaultLogger;
import com.github.dockerjava.shaded.org.apache.tools.ant.Target;
import com.github.dockerjava.shaded.org.apache.tools.ant.Task;
import com.github.dockerjava.shaded.org.apache.tools.ant.UnknownElement;
import com.github.dockerjava.shaded.org.apache.tools.ant.util.DOMElementWriter;
import com.github.dockerjava.shaded.org.apache.tools.ant.util.FileUtils;
import com.github.dockerjava.shaded.org.apache.tools.ant.util.StringUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlLogger
implements BuildLogger {
    private int msgOutputLevel = 4;
    private PrintStream outStream;
    private static DocumentBuilder builder = XmlLogger.getDocumentBuilder();
    private static final String BUILD_TAG = "build";
    private static final String TARGET_TAG = "target";
    private static final String TASK_TAG = "task";
    private static final String MESSAGE_TAG = "message";
    private static final String NAME_ATTR = "name";
    private static final String TIME_ATTR = "time";
    private static final String PRIORITY_ATTR = "priority";
    private static final String LOCATION_ATTR = "location";
    private static final String ERROR_ATTR = "error";
    private static final String STACKTRACE_TAG = "stacktrace";
    private Document doc = builder.newDocument();
    private Hashtable<Task, TimedElement> tasks = new Hashtable();
    private Hashtable<Target, TimedElement> targets = new Hashtable();
    private Hashtable<Thread, Stack<TimedElement>> threadStacks = new Hashtable();
    private TimedElement buildElement = null;

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    @Override
    public void buildStarted(BuildEvent event) {
        this.buildElement = new TimedElement();
        this.buildElement.startTime = System.currentTimeMillis();
        this.buildElement.element = this.doc.createElement(BUILD_TAG);
    }

    @Override
    public void buildFinished(BuildEvent event) {
        String xslUri;
        String outFilename;
        long totalTime = System.currentTimeMillis() - this.buildElement.startTime;
        this.buildElement.element.setAttribute(TIME_ATTR, DefaultLogger.formatTime(totalTime));
        if (event.getException() != null) {
            this.buildElement.element.setAttribute(ERROR_ATTR, event.getException().toString());
            Throwable t = event.getException();
            CDATASection errText = this.doc.createCDATASection(StringUtils.getStackTrace(t));
            Element stacktrace = this.doc.createElement(STACKTRACE_TAG);
            stacktrace.appendChild(errText);
            this.synchronizedAppend(this.buildElement.element, stacktrace);
        }
        if ((outFilename = event.getProject().getProperty("XmlLogger.file")) == null) {
            outFilename = "log.xml";
        }
        if ((xslUri = event.getProject().getProperty("ant.XmlLogger.stylesheet.uri")) == null) {
            xslUri = "log.xsl";
        }
        OutputStreamWriter out = null;
        try {
            OutputStream stream = this.outStream;
            if (stream == null) {
                stream = new FileOutputStream(outFilename);
            }
            out = new OutputStreamWriter(stream, "UTF8");
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            if (xslUri.length() > 0) {
                out.write("<?xml-stylesheet type=\"text/xsl\" href=\"" + xslUri + "\"?>\n\n");
            }
            new DOMElementWriter().write(this.buildElement.element, out, 0, "\t");
            ((Writer)out).flush();
        }
        catch (IOException exc) {
            try {
                throw new BuildException("Unable to write log file", exc);
            }
            catch (Throwable throwable) {
                FileUtils.close(out);
                throw throwable;
            }
        }
        FileUtils.close(out);
        this.buildElement = null;
    }

    private Stack<TimedElement> getStack() {
        Stack<TimedElement> threadStack = this.threadStacks.get(Thread.currentThread());
        if (threadStack == null) {
            threadStack = new Stack();
            this.threadStacks.put(Thread.currentThread(), threadStack);
        }
        return threadStack;
    }

    @Override
    public void targetStarted(BuildEvent event) {
        Target target = event.getTarget();
        TimedElement targetElement = new TimedElement();
        targetElement.startTime = System.currentTimeMillis();
        targetElement.element = this.doc.createElement(TARGET_TAG);
        targetElement.element.setAttribute(NAME_ATTR, target.getName());
        this.targets.put(target, targetElement);
        this.getStack().push(targetElement);
    }

    @Override
    public void targetFinished(BuildEvent event) {
        Target target = event.getTarget();
        TimedElement targetElement = this.targets.get(target);
        if (targetElement != null) {
            long totalTime = System.currentTimeMillis() - targetElement.startTime;
            targetElement.element.setAttribute(TIME_ATTR, DefaultLogger.formatTime(totalTime));
            TimedElement parentElement = null;
            Stack<TimedElement> threadStack = this.getStack();
            if (!threadStack.empty()) {
                TimedElement poppedStack = threadStack.pop();
                if (poppedStack != targetElement) {
                    throw new RuntimeException("Mismatch - popped element = " + poppedStack + " finished target element = " + targetElement);
                }
                if (!threadStack.empty()) {
                    parentElement = threadStack.peek();
                }
            }
            if (parentElement == null) {
                this.synchronizedAppend(this.buildElement.element, targetElement.element);
            } else {
                this.synchronizedAppend(parentElement.element, targetElement.element);
            }
        }
        this.targets.remove(target);
    }

    @Override
    public void taskStarted(BuildEvent event) {
        TimedElement taskElement = new TimedElement();
        taskElement.startTime = System.currentTimeMillis();
        taskElement.element = this.doc.createElement(TASK_TAG);
        Task task = event.getTask();
        String name = event.getTask().getTaskName();
        if (name == null) {
            name = "";
        }
        taskElement.element.setAttribute(NAME_ATTR, name);
        taskElement.element.setAttribute(LOCATION_ATTR, event.getTask().getLocation().toString());
        this.tasks.put(task, taskElement);
        this.getStack().push(taskElement);
    }

    @Override
    public void taskFinished(BuildEvent event) {
        TimedElement poppedStack;
        Task task = event.getTask();
        TimedElement taskElement = this.tasks.get(task);
        if (taskElement == null) {
            throw new RuntimeException("Unknown task " + task + " not in " + this.tasks);
        }
        long totalTime = System.currentTimeMillis() - taskElement.startTime;
        taskElement.element.setAttribute(TIME_ATTR, DefaultLogger.formatTime(totalTime));
        Target target = task.getOwningTarget();
        TimedElement targetElement = null;
        if (target != null) {
            targetElement = this.targets.get(target);
        }
        if (targetElement == null) {
            this.synchronizedAppend(this.buildElement.element, taskElement.element);
        } else {
            this.synchronizedAppend(targetElement.element, taskElement.element);
        }
        Stack<TimedElement> threadStack = this.getStack();
        if (!threadStack.empty() && (poppedStack = threadStack.pop()) != taskElement) {
            throw new RuntimeException("Mismatch - popped element = " + poppedStack + " finished task element = " + taskElement);
        }
        this.tasks.remove(task);
    }

    private TimedElement getTaskElement(Task task) {
        TimedElement element = this.tasks.get(task);
        if (element != null) {
            return element;
        }
        Enumeration<Task> e = this.tasks.keys();
        while (e.hasMoreElements()) {
            Task key = e.nextElement();
            if (!(key instanceof UnknownElement) || ((UnknownElement)key).getTask() != task) continue;
            return this.tasks.get(key);
        }
        return null;
    }

    @Override
    public void messageLogged(BuildEvent event) {
        int priority = event.getPriority();
        if (priority > this.msgOutputLevel) {
            return;
        }
        Element messageElement = this.doc.createElement(MESSAGE_TAG);
        String name = "debug";
        switch (priority) {
            case 0: {
                name = ERROR_ATTR;
                break;
            }
            case 1: {
                name = "warn";
                break;
            }
            case 2: {
                name = "info";
                break;
            }
            default: {
                name = "debug";
            }
        }
        messageElement.setAttribute(PRIORITY_ATTR, name);
        Throwable ex = event.getException();
        if (4 <= this.msgOutputLevel && ex != null) {
            CDATASection errText = this.doc.createCDATASection(StringUtils.getStackTrace(ex));
            Element stacktrace = this.doc.createElement(STACKTRACE_TAG);
            stacktrace.appendChild(errText);
            this.synchronizedAppend(this.buildElement.element, stacktrace);
        }
        CDATASection messageText = this.doc.createCDATASection(event.getMessage());
        messageElement.appendChild(messageText);
        TimedElement parentElement = null;
        Task task = event.getTask();
        Target target = event.getTarget();
        if (task != null) {
            parentElement = this.getTaskElement(task);
        }
        if (parentElement == null && target != null) {
            parentElement = this.targets.get(target);
        }
        if (parentElement != null) {
            this.synchronizedAppend(parentElement.element, messageElement);
        } else {
            this.synchronizedAppend(this.buildElement.element, messageElement);
        }
    }

    @Override
    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    @Override
    public void setOutputPrintStream(PrintStream output) {
        this.outStream = new PrintStream(output, true);
    }

    @Override
    public void setEmacsMode(boolean emacsMode) {
    }

    @Override
    public void setErrorPrintStream(PrintStream err) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizedAppend(Node parent, Node child) {
        Node node = parent;
        synchronized (node) {
            parent.appendChild(child);
        }
    }

    private static class TimedElement {
        private long startTime;
        private Element element;

        private TimedElement() {
        }

        public String toString() {
            return this.element.getTagName() + ":" + this.element.getAttribute(XmlLogger.NAME_ATTR);
        }
    }
}

