/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs;

import com.github.dockerjava.shaded.org.apache.tools.ant.BuildException;
import com.github.dockerjava.shaded.org.apache.tools.ant.Task;
import com.github.dockerjava.shaded.org.apache.tools.ant.launch.Locator;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Path;
import com.github.dockerjava.shaded.org.apache.tools.ant.util.FileUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;

public class ManifestClassPath
extends Task {
    private String name;
    private File dir;
    private int maxParentLevels = 2;
    private Path path;

    public void execute() {
        if (this.name == null) {
            throw new BuildException("Missing 'property' attribute!");
        }
        if (this.dir == null) {
            throw new BuildException("Missing 'jarfile' attribute!");
        }
        if (this.getProject().getProperty(this.name) != null) {
            throw new BuildException("Property '" + this.name + "' already set!");
        }
        if (this.path == null) {
            throw new BuildException("Missing nested <classpath>!");
        }
        StringBuffer tooLongSb = new StringBuffer();
        for (int i = 0; i < this.maxParentLevels + 1; ++i) {
            tooLongSb.append("../");
        }
        String tooLongPrefix = tooLongSb.toString();
        FileUtils fileUtils = FileUtils.getFileUtils();
        this.dir = fileUtils.normalize(this.dir.getAbsolutePath());
        String[] elements = this.path.list();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < elements.length; ++i) {
            File pathEntry = new File(elements[i]);
            String fullPath = pathEntry.getAbsolutePath();
            pathEntry = fileUtils.normalize(fullPath);
            String relPath = null;
            String canonicalPath = null;
            try {
                relPath = this.dir.equals(pathEntry) ? "." : FileUtils.getRelativePath(this.dir, pathEntry);
                canonicalPath = pathEntry.getCanonicalPath();
                if (File.separatorChar != '/') {
                    canonicalPath = canonicalPath.replace(File.separatorChar, '/');
                }
            }
            catch (Exception e) {
                throw new BuildException("error trying to get the relative path from " + this.dir + " to " + fullPath, e);
            }
            if (relPath.equals(canonicalPath) || relPath.startsWith(tooLongPrefix)) {
                throw new BuildException("No suitable relative path from " + this.dir + " to " + fullPath);
            }
            if (pathEntry.isDirectory() && !relPath.endsWith("/")) {
                relPath = relPath + '/';
            }
            try {
                relPath = Locator.encodeURI(relPath);
            }
            catch (UnsupportedEncodingException exc) {
                throw new BuildException(exc);
            }
            buffer.append(relPath);
            buffer.append(' ');
        }
        this.getProject().setNewProperty(this.name, buffer.toString().trim());
    }

    public void setProperty(String name) {
        this.name = name;
    }

    public void setJarFile(File jarfile) {
        File parent = jarfile.getParentFile();
        if (!parent.isDirectory()) {
            throw new BuildException("Jar's directory not found: " + parent);
        }
        this.dir = parent;
    }

    public void setMaxParentLevels(int levels) {
        if (levels < 0) {
            throw new BuildException("maxParentLevels must not be a negative number");
        }
        this.maxParentLevels = levels;
    }

    public void addClassPath(Path path) {
        this.path = path;
    }
}

