/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email.system.io;

import com.aspose.email.internal.b.zar;
import com.aspose.email.internal.b.zbc;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.exceptions.ArgumentOutOfRangeException;
import com.aspose.email.system.exceptions.NotSupportedException;
import com.aspose.email.system.exceptions.ObjectDisposedException;
import com.aspose.email.system.io.Stream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MemoryStream
extends Stream {
    private boolean a;
    private boolean b;
    private int c;
    private int d;
    private byte[] e;
    private int f;
    private boolean g;
    private boolean h;
    private int i;
    private int j;

    public MemoryStream() {
        this(0);
    }

    public MemoryStream(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.a = true;
        this.c = capacity;
        this.e = new byte[capacity];
        this.g = true;
        this.b = true;
    }

    public MemoryStream(byte[] buffer) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        this.a(buffer, 0, buffer.length, true, false);
    }

    public MemoryStream(byte[] buffer, boolean writable) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        this.a(buffer, 0, buffer.length, writable, false);
    }

    public MemoryStream(byte[] buffer, int index, int count) {
        this.a(buffer, index, count, true, false);
    }

    public MemoryStream(byte[] buffer, int index, int count, boolean writable) {
        this.a(buffer, index, count, writable, false);
    }

    public MemoryStream(byte[] buffer, int index, int count, boolean writable, boolean publiclyVisible) {
        this.a(buffer, index, count, writable, publiclyVisible);
    }

    private void a(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        if (byArray == null) {
            throw new ArgumentNullException("buffer");
        }
        if (n < 0 || n2 < 0) {
            throw new ArgumentOutOfRangeException("index or count is less than 0.");
        }
        if (byArray.length - n < n2) {
            throw new ArgumentException("index+count", "The size of the buffer is less than index + count.");
        }
        this.a = bl;
        this.e = byArray;
        this.d = this.c = n2 + n;
        this.i = n;
        this.f = n;
        this.b = bl2;
        this.g = false;
    }

    private void a() {
        if (this.h) {
            throw new ObjectDisposedException("MemoryStream");
        }
    }

    @Override
    public boolean canRead() {
        return !this.h;
    }

    @Override
    public boolean canSeek() {
        return !this.h;
    }

    @Override
    public boolean canWrite() {
        return !this.h && this.a;
    }

    public int getCapacity() {
        this.a();
        return this.c - this.f;
    }

    public void setCapacity(int value) {
        this.a();
        if (!this.g) {
            throw new NotSupportedException("Cannot expand this MemoryStream");
        }
        if (value < 0 || value < this.d) {
            throw new ArgumentOutOfRangeException("value", zar.a(new Object[]{"New capacity cannot be negative or less than the current capacity ", value, " ", this.c}));
        }
        if (this.e != null && value == this.e.length) {
            return;
        }
        byte[] byArray = null;
        if (value != 0) {
            byArray = new byte[value];
            if (this.e != null) {
                System.arraycopy(this.e, 0, byArray, 0, this.d);
            }
        }
        this.j = 0;
        this.e = byArray;
        this.c = value;
    }

    @Override
    public long getLength() {
        this.a();
        return this.d - this.f;
    }

    @Override
    public long getPosition() {
        this.a();
        return this.i - this.f;
    }

    @Override
    public void setPosition(long value) {
        this.a();
        if (value < 0L) {
            throw new ArgumentOutOfRangeException("value", "Position cannot be negative");
        }
        if (value > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("value", "Position must be non-negative and less than 2^31 - 1 - origin");
        }
        this.i = this.f + (int)value;
    }

    @Override
    protected void dispose(boolean disposing) {
        this.h = true;
        this.g = false;
    }

    @Override
    public void flush() {
    }

    public byte[] getBuffer() {
        if (!this.b) {
            throw new com.aspose.email.system.exceptions.IOException();
        }
        return this.e;
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (offset < 0 || count < 0) {
            throw new ArgumentOutOfRangeException("offset or count less than zero.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("offset+count", "The size of the buffer is less than offset + count.");
        }
        this.a();
        if (this.i >= this.d || count == 0) {
            return 0;
        }
        if (this.i > this.d - count) {
            count = this.d - this.i;
        }
        System.arraycopy(this.e, this.i, buffer, offset, count);
        this.i += count;
        return count;
    }

    @Override
    public int readByte() {
        this.a();
        if (this.i >= this.d) {
            return -1;
        }
        return this.e[this.i++] & 0xFF;
    }

    @Override
    public long seek(long offset, int loc) {
        int n;
        this.a();
        if (offset > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException(zar.a(new Object[]{"Offset out of range. ", offset}));
        }
        switch (loc) {
            case 0: {
                if (offset < 0L) {
                    throw new com.aspose.email.system.exceptions.IOException("Attempted to seek before start of MemoryStream.");
                }
                n = this.f;
                break;
            }
            case 1: {
                n = this.i;
                break;
            }
            case 2: {
                n = this.d;
                break;
            }
            default: {
                throw new ArgumentException("loc", "Invalid SeekOrigin");
            }
        }
        if ((n += (int)offset) < this.f) {
            throw new com.aspose.email.system.exceptions.IOException("Attempted to seek before start of MemoryStream.");
        }
        this.i = n;
        return this.i;
    }

    private int a(int n) {
        if (n < 256) {
            n = 256;
        }
        if (n < this.c * 2) {
            n = this.c * 2;
        }
        return n;
    }

    private void b(int n) {
        if (n > this.c) {
            this.setCapacity(this.a(n));
        } else if (this.j > 0) {
            zbc.b(this.e, this.d, this.j);
            this.j = 0;
        }
    }

    @Override
    public void setLength(long value) {
        if (!this.g && value > (long)this.c) {
            throw new NotSupportedException("Expanding this MemoryStream is not supported");
        }
        this.a();
        if (!this.a) {
            throw new NotSupportedException("Cannot write to this MemoryStream");
        }
        if (value < 0L || value + (long)this.f > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException();
        }
        int n = (int)value + this.f;
        if (n > this.d) {
            this.b(n);
        } else if (n < this.d) {
            this.j += this.d - n;
        }
        this.d = n;
        if (this.i > this.d) {
            this.i = this.d;
        }
    }

    public byte[] toArray() {
        int n = this.d - this.f;
        byte[] byArray = new byte[n];
        if (this.e != null) {
            System.arraycopy(this.e, this.f, byArray, 0, n);
        }
        return byArray;
    }

    @Override
    public void write(byte[] buffer, int offset, int count) {
        if (!this.a) {
            throw new NotSupportedException("Cannot write to this stream.");
        }
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (offset < 0 || count < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("offset+count", "The size of the buffer is less than offset + count.");
        }
        this.a();
        if (this.i > this.d - count) {
            this.b(this.i + count);
        }
        System.arraycopy(buffer, offset, this.e, this.i, count);
        this.i += count;
        if (this.i >= this.d) {
            this.d = this.i;
        }
    }

    @Override
    public void writeByte(byte value) {
        this.a();
        if (!this.a) {
            throw new NotSupportedException("Cannot write to this stream.");
        }
        if (this.i >= this.d) {
            this.b(this.i + 1);
            this.d = this.i + 1;
        }
        this.e[this.i++] = value;
    }

    public void writeTo(Stream stream) {
        this.a();
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        stream.write(this.e, this.f, this.d - this.f);
    }

    public static MemoryStream fromInputStream(InputStream input) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while (-1 != (n = input.read(byArray))) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return new MemoryStream(byteArrayOutputStream.toByteArray());
    }
}

