/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email;

import com.aspose.email.EmlLoadOptions;
import com.aspose.email.FolderInfo;
import com.aspose.email.MailMessage;
import com.aspose.email.MapiConversionOptions;
import com.aspose.email.MapiMessage;
import com.aspose.email.MboxLoadOptions;
import com.aspose.email.MboxStorageReader;
import com.aspose.email.MboxToPstConversionOptions;
import com.aspose.email.MboxrdStorageReader;
import com.aspose.email.PersonalStorage;
import com.aspose.email.internal.b.zar;
import com.aspose.email.internal.ev.za;
import com.aspose.email.system.AsyncCallback;
import com.aspose.email.system.IAsyncResult;
import com.aspose.email.system.MulticastDelegate;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.io.FileStream;
import com.aspose.email.system.io.Stream;
import com.aspose.email.zakq;
import com.aspose.email.zbnt;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MailStorageConverter {
    private static EmlLoadOptions a = new EmlLoadOptions();

    public static EmlLoadOptions getMboxMessageOptions() {
        return a;
    }

    public static void setMboxMessageOptions(EmlLoadOptions value) {
        a = value;
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstFileName, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName, MailHandler mailHandler) {
        if (zar.a(mboxFileName)) {
            throw new ArgumentException(zbnt.a(new byte[]{5, 77, -19, 80, -121, 116, -85, -32, -79, -99, 40, -61, -122, 39, -106, -38, 3, -58, 25, -96, 104, 77, -25, 8, -55, 103, -82, -32, -12, -46, 52, -126, -114, 47, -58, -51, 27}), zbnt.a(new byte[]{37, 77, -19, 80, -31, 123, -82, -23, -102, -36, 43, -57}));
        }
        return MailStorageConverter.a(new FileStream(mboxFileName, 3, 1), pstFileName, mailHandler);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, String pstFileName) {
        return MailStorageConverter.a(Stream.fromJava(mboxrdDataStream), pstFileName);
    }

    static PersonalStorage a(Stream stream, String string) {
        return MailStorageConverter.a(stream, string, null);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, String pstFileName, MailHandler mailHandler) {
        return MailStorageConverter.a(Stream.fromJava(mboxrdDataStream), pstFileName, mailHandler);
    }

    static PersonalStorage a(Stream stream, String string, MailHandler mailHandler) {
        if (zar.a(string)) {
            throw new ArgumentException(zbnt.a(new byte[]{24, 92, -10, 8, -63, 123, -82, -23, -12, -45, 39, -49, -114, 98, -43, -40, 12, -113, 74, -12, 42, 74, -94, 70, -46, 126, -82, -84, -69, -49, 102, -57, -122, 50, -62, -64}), zbnt.a(new byte[]{56, 92, -10, 110, -50, 126, -89, -62, -75, -48, 35}));
        }
        return MailStorageConverter.mboxToPst(stream, (Stream)new FileStream(string, 2, 3), mailHandler);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, OutputStream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstDataStream, null);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, Stream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstDataStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(String mboxFileName, OutputStream pstDataStream, MailHandler mailHandler) {
        PersonalStorage personalStorage;
        FileInputStream fileInputStream = new FileInputStream(mboxFileName);
        try {
            personalStorage = MailStorageConverter.mboxToPst((InputStream)fileInputStream, pstDataStream, mailHandler);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        ((InputStream)fileInputStream).close();
        return personalStorage;
    }

    public static PersonalStorage mboxToPst(String mboxFileName, Stream pstDataStream, MailHandler mailHandler) {
        if (zar.a(mboxFileName)) {
            throw new ArgumentException(zbnt.a(new byte[]{5, 77, -19, 80, -121, 116, -85, -32, -79, -99, 40, -61, -122, 39, -106, -38, 3, -58, 25, -96, 104, 77, -25, 8, -55, 103, -82, -32, -12, -46, 52, -126, -114, 47, -58, -51, 27}), zbnt.a(new byte[]{37, 77, -19, 80, -31, 123, -82, -23, -102, -36, 43, -57}));
        }
        return MailStorageConverter.mboxToPst((Stream)new FileStream(mboxFileName, 3, 1), pstDataStream, mailHandler);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, mboxToPstConversionOptions);
    }

    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, mboxToPstConversionOptions);
    }

    public static void mboxToPst(MboxStorageReader mboxStorageReader, PersonalStorage pst, String pstFolderName, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        MailStorageConverter.mboxToPst(mboxStorageReader, pst, pstFolderName, mboxToPstConversionOptions);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName, MboxToPstConversionOptions options) {
        if (zar.a(mboxFileName)) {
            throw new ArgumentException(zbnt.a(new byte[]{5, 77, -19, 80, -121, 116, -85, -32, -79, -99, 40, -61, -122, 39, -106, -38, 3, -58, 25, -96, 104, 77, -25, 8, -55, 103, -82, -32, -12, -46, 52, -126, -114, 47, -58, -51, 27}), zbnt.a(new byte[]{37, 77, -19, 80, -31, 123, -82, -23, -102, -36, 43, -57}));
        }
        if (zar.a(pstFileName)) {
            throw new ArgumentException(zbnt.a(new byte[]{24, 92, -10, 8, -63, 123, -82, -23, -12, -45, 39, -49, -114, 98, -43, -40, 12, -113, 74, -12, 42, 74, -94, 70, -46, 126, -82, -84, -69, -49, 102, -57, -122, 50, -62, -64}), zbnt.a(new byte[]{56, 92, -10, 110, -50, 126, -89, -62, -75, -48, 35}));
        }
        return MailStorageConverter.mboxToPst((Stream)new FileStream(mboxFileName, 3, 1), (Stream)new FileStream(pstFileName, 2, 3), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream, MboxToPstConversionOptions options) {
        if (mboxrdDataStream == null) {
            throw new ArgumentNullException(zbnt.a(new byte[]{37, 77, -19, 80, -43, 118, -122, -19, -96, -36, 21, -42, -103, 39, -41, -44}));
        }
        if (pstDataStream == null) {
            throw new ArgumentNullException(zbnt.a(new byte[]{56, 92, -10, 108, -58, 102, -93, -33, -96, -49, 35, -61, -122}));
        }
        PersonalStorage personalStorage = PersonalStorage.create(pstDataStream, 0);
        MboxLoadOptions mboxLoadOptions = new MboxLoadOptions();
        mboxLoadOptions.setLeaveOpen(false);
        MboxrdStorageReader mboxrdStorageReader = new MboxrdStorageReader(mboxrdDataStream, mboxLoadOptions);
        try {
            MailStorageConverter.mboxToPst((MboxStorageReader)mboxrdStorageReader, personalStorage, zbnt.a(new byte[]{1, 65, -32, 71, -33}), options);
        }
        finally {
            if (mboxrdStorageReader != null) {
                mboxrdStorageReader.dispose();
            }
        }
        return personalStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream, MboxToPstConversionOptions options) {
        if (mboxrdDataStream == null) {
            throw new ArgumentNullException(zbnt.a(new byte[]{37, 77, -19, 80, -43, 118, -122, -19, -96, -36, 21, -42, -103, 39, -41, -44}));
        }
        if (pstDataStream == null) {
            throw new ArgumentNullException(zbnt.a(new byte[]{56, 92, -10, 108, -58, 102, -93, -33, -96, -49, 35, -61, -122}));
        }
        PersonalStorage personalStorage = PersonalStorage.a(pstDataStream, 0);
        MboxLoadOptions mboxLoadOptions = new MboxLoadOptions();
        mboxLoadOptions.setLeaveOpen(false);
        MboxrdStorageReader mboxrdStorageReader = new MboxrdStorageReader(mboxrdDataStream, mboxLoadOptions);
        try {
            MailStorageConverter.mboxToPst((MboxStorageReader)mboxrdStorageReader, personalStorage, zbnt.a(new byte[]{1, 65, -32, 71, -33}), options);
        }
        finally {
            if (mboxrdStorageReader != null) {
                mboxrdStorageReader.dispose();
            }
        }
        return personalStorage;
    }

    public static void mboxToPst(MboxStorageReader mboxStorageReader, PersonalStorage pst, String pstFolderName, MboxToPstConversionOptions options) {
        MailMessage mailMessage;
        if (mboxStorageReader == null) {
            throw new ArgumentNullException(zbnt.a(new byte[]{37, 77, -19, 80, -12, 102, -83, -2, -75, -38, 35, -16, -114, 35, -46, -36, 16}));
        }
        if (pst == null) {
            throw new ArgumentNullException(zbnt.a(new byte[]{56, 92, -10}));
        }
        FolderInfo folderInfo = pst.getRootFolder().getSubFolder(pstFolderName);
        if (folderInfo == null) {
            folderInfo = pst.getRootFolder().addSubFolder(pstFolderName);
        }
        while ((mailMessage = mboxStorageReader.readNextMessage(MailStorageConverter.getMboxMessageOptions())) != null) {
            if (options.getMessageHandler() != null) {
                options.getMessageHandler().invoke(mailMessage);
            }
            MapiConversionOptions mapiConversionOptions = MapiConversionOptions.getUnicodeFormat();
            mapiConversionOptions.setRemoveSignature(options != null ? options.getRemoveSignature() : false);
            folderInfo.addMessage(MapiMessage.fromMailMessage(mailMessage, mapiConversionOptions));
        }
    }

    public static abstract class MailHandler
    extends MulticastDelegate {
        public abstract void invoke(MailMessage var1);

        public final IAsyncResult beginInvoke(MailMessage message, AsyncCallback callback, Object state) {
            return za.a(new zakq(this, this, callback, state, message));
        }

        public final void endInvoke(IAsyncResult result) {
            za.a(this, result);
        }
    }
}

