/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font;

import com.aspose.font.FileSystemStreamSource;
import com.aspose.font.FontFileDefinition;
import com.aspose.font.FontType;
import com.aspose.font.I687;
import com.aspose.font.I854;
import com.aspose.font.MultiLanguageString;
import com.aspose.font.StreamSource;
import com.aspose.font.internal.l37.I21;
import com.aspose.font.internal.l4.I254;

public class FontDefinition {
    FontType lif;
    FontFileDefinition[] ll;
    MultiLanguageString lI;
    MultiLanguageString l1;
    String lIF;
    String llf;

    public static FontDefinition open(String fileName, FontType fontType) {
        switch (fontType) {
            case Type1: {
                FileSystemStreamSource fileSystemStreamSource = new FileSystemStreamSource(fileName);
                I854 i854 = new I854();
                return i854.lif(fileSystemStreamSource);
            }
            case CFF: {
                return new FontDefinition(fontType, new FontFileDefinition(new I21(fileName)));
            }
        }
        FileSystemStreamSource fileSystemStreamSource = new FileSystemStreamSource(fileName);
        I687 i687 = new I687();
        return i687.lif(fileSystemStreamSource);
    }

    public static FontDefinition open(StreamSource source, FontType fontType) {
        switch (fontType) {
            case Type1: {
                I854 i854 = new I854();
                return i854.lif(source);
            }
            case CFF: {
                return new FontDefinition(fontType, source);
            }
        }
        I687 i687 = new I687();
        return i687.lif(source);
    }

    FontDefinition() {
    }

    public FontDefinition(FontType fontType, String fileExtension, StreamSource streamSource) {
        this(fontType, new FontFileDefinition(fileExtension, streamSource));
    }

    public FontDefinition(FontType fontType, StreamSource streamSource) {
        this(fontType, new FontFileDefinition(streamSource));
    }

    public FontDefinition(String fontName, FontType fontType, String fileExtension, StreamSource streamSource) {
        this(fontName, fontType, new FontFileDefinition(fileExtension, streamSource));
    }

    public FontDefinition(FontType fontType, FontFileDefinition fileDefinition) {
        this(fontType, new FontFileDefinition[]{fileDefinition});
    }

    public FontDefinition(String fontName, FontType fontType, FontFileDefinition fileDefinition) {
        this(fontName, fontName, fontType, new FontFileDefinition[]{fileDefinition});
    }

    public FontDefinition(String fontName, String postscriptName, FontType fontType, FontFileDefinition fileDefinition) {
        this(fontName, postscriptName, fontType, new FontFileDefinition[]{fileDefinition});
    }

    public FontDefinition(FontType fontType, FontFileDefinition[] fileDefinitions) {
        this(I254.lif, I254.lif, fontType, fileDefinitions);
    }

    public FontDefinition(String fontName, String postscriptName, FontType fontType, FontFileDefinition[] fileDefinitions) {
        this.lI = new MultiLanguageString(fontName);
        this.lIF = fontName;
        this.l1 = new MultiLanguageString(postscriptName);
        this.llf = postscriptName;
        this.lif = fontType;
        this.ll = fileDefinitions;
    }

    public FontDefinition(MultiLanguageString fontNames, MultiLanguageString postscriptNames, FontType fontType, FontFileDefinition fileDefinition) {
        this(fontNames, postscriptNames, fontType, new FontFileDefinition[]{fileDefinition});
    }

    public FontDefinition(MultiLanguageString fontNames, MultiLanguageString postscriptNames, FontType fontType, FontFileDefinition[] fileDefinitions) {
        this.lI = fontNames;
        this.l1 = postscriptNames;
        this.lIF = fontNames.getEnglishString();
        this.llf = postscriptNames.getEnglishString();
        this.lif = fontType;
        this.ll = fileDefinitions;
    }

    public String getFontName() {
        return this.lIF;
    }

    public MultiLanguageString getFontNames() {
        return this.lI;
    }

    public String getPostscriptName() {
        return this.llf;
    }

    public MultiLanguageString getPostscriptNames() {
        return this.l1;
    }

    public FontType getFontType() {
        return this.lif;
    }

    public FontFileDefinition[] getFileDefinitions() {
        return this.ll;
    }
}

