/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font.internal.l36I;

import com.aspose.font.internal.l23l.I14;
import com.aspose.font.internal.l23l.I21;
import com.aspose.font.internal.l23l.I2I;
import com.aspose.font.internal.l23l.I2l;
import com.aspose.font.internal.l23l.I3I;
import com.aspose.font.internal.l304.I7;
import com.aspose.font.internal.l317.I1;
import com.aspose.font.internal.l31I.I107;
import com.aspose.font.internal.l31I.I10I;
import com.aspose.font.internal.l31I.I17;
import com.aspose.font.internal.l31I.I1l;
import com.aspose.font.internal.l31I.I27;
import com.aspose.font.internal.l31I.I34;
import com.aspose.font.internal.l31I.I41;
import com.aspose.font.internal.l31I.I47;
import com.aspose.font.internal.l31I.I54;
import com.aspose.font.internal.l36I.I161l;
import com.aspose.font.internal.l36I.I162I;
import com.aspose.font.internal.l36I.I163l;
import com.aspose.font.internal.l381.I24;
import com.aspose.font.internal.l384.I0I;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class I1621
extends X509CRL {
    private final Provider lif;
    private final I27 ll;
    private final String lI;
    private final byte[] l1;
    private final boolean lIF;
    private volatile boolean llf = false;
    private volatile int liF;

    static boolean lif(X509CRL x509CRL) throws CRLException {
        try {
            byte[] byArray = x509CRL.getExtensionValue(I34.l01.ll());
            return byArray != null && I54.lif(I21.lif(byArray).l1()).lI();
        }
        catch (Exception exception) {
            throw new CRLException("Exception reading IssuingDistributionPoint", exception);
        }
    }

    protected I1621(Provider provider, I27 i27) throws CRLException {
        this.lif = provider;
        this.ll = i27;
        try {
            this.lI = I163l.lif(i27.l1());
            this.l1 = (byte[])(i27.l1().ll() != null ? i27.l1().ll().l0l().lif("DER") : null);
            this.lIF = I1621.lif(this);
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.removeAll(I161l.l1if);
        return !set.isEmpty();
    }

    private Set lif(boolean bl) {
        I47 i47;
        if (this.getVersion() == 2 && (i47 = this.ll.lif().lf()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = i47.lif();
            while (enumeration.hasMoreElements()) {
                I2I i2I = (I2I)enumeration.nextElement();
                I34 i34 = i47.lif(i2I);
                if (bl != i34.ll()) continue;
                hashSet.add(i2I.ll());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.lif(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.lif(false);
    }

    public byte[] getExtensionValue(String string) {
        I34 i34;
        I47 i47 = this.ll.lif().lf();
        if (i47 != null && (i34 = i47.lif(new I2I(string))) != null) {
            try {
                return i34.lI().l0I();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public byte[] getEncoded() throws CRLException {
        try {
            return this.ll.lif("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = Signature.getInstance(this.getSigAlgName(), this.lif);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.lif(publicKey, signature);
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = string != null ? Signature.getInstance(this.getSigAlgName(), string) : Signature.getInstance(this.getSigAlgName());
        this.lif(publicKey, signature);
    }

    public void verify(PublicKey publicKey, Provider provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = provider != null ? Signature.getInstance(this.getSigAlgName(), provider) : Signature.getInstance(this.getSigAlgName());
        this.lif(publicKey, signature);
    }

    private void lif(PublicKey publicKey, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.ll.l1().equals(this.ll.lif().lI())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        if (this.l1 != null) {
            try {
                I163l.lif(signature, I3I.ll(this.l1));
            }
            catch (IOException iOException) {
                throw new SignatureException("cannot decode signature parameters: " + iOException.getMessage());
            }
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    public int getVersion() {
        return this.ll.llf();
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.ll.liF().l0I());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    public Date getThisUpdate() {
        return this.ll.lIf().ll();
    }

    public Date getNextUpdate() {
        if (this.ll.lf() != null) {
            return this.ll.lf().ll();
        }
        return null;
    }

    private Set lif() {
        HashSet<I162I> hashSet = new HashSet<I162I>();
        Enumeration enumeration = this.ll.lI();
        I1 i1 = null;
        while (enumeration.hasMoreElements()) {
            I34 i34;
            I107.I7 i7 = (I107.I7)enumeration.nextElement();
            I162I i162I = new I162I(i7, this.lIF, i1);
            hashSet.add(i162I);
            if (!this.lIF || !i7.l1() || (i34 = i7.lI().lif(I34.l0IF)) == null) continue;
            i1 = I1.lif(I41.lif(i34.l1()).lif()[0].ll());
        }
        return hashSet;
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        Enumeration enumeration = this.ll.lI();
        I1 i1 = null;
        while (enumeration.hasMoreElements()) {
            I34 i34;
            I107.I7 i7 = (I107.I7)enumeration.nextElement();
            if (bigInteger.equals(i7.lif().ll())) {
                return new I162I(i7, this.lIF, i1);
            }
            if (!this.lIF || !i7.l1() || (i34 = i7.lI().lif(I34.l0IF)) == null) continue;
            i1 = I1.lif(I41.lif(i34.l1()).lif()[0].ll());
        }
        return null;
    }

    public Set getRevokedCertificates() {
        Set set = this.lif();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    public byte[] getTBSCertList() throws CRLException {
        try {
            return this.ll.lif().lif("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.ll.lIF().l1();
    }

    public String getSigAlgName() {
        return this.lI;
    }

    public String getSigAlgOID() {
        return this.ll.l1().lif().ll();
    }

    public byte[] getSigAlgParams() {
        if (this.l1 != null) {
            byte[] byArray = new byte[this.l1.length];
            System.arraycopy(this.l1, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    public String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = I24.ll();
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(I24.ll(I0I.ll(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(I24.ll(I0I.ll(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(I24.ll(I0I.ll(byArray, i, byArray.length - i))).append(string);
        }
        I47 i47 = this.ll.lif().lf();
        if (i47 != null) {
            object2 = i47.lif();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (I2I)object2.nextElement();
                I34 i34 = i47.lif((I2I)object);
                if (i34.lI() != null) {
                    byte[] byArray2 = i34.lI().l1();
                    stringBuffer.append("                       critical(").append(i34.ll()).append(") ");
                    try {
                        I3I i3I = I3I.ll(byArray2);
                        if (((I3I)object).equals(I34.lIf)) {
                            stringBuffer.append(new I1l(I14.lif(i3I).lI())).append(string);
                            continue;
                        }
                        if (((I3I)object).equals(I34.l0I)) {
                            stringBuffer.append("Base CRL: " + new I1l(I14.lif(i3I).lI())).append(string);
                            continue;
                        }
                        if (((I3I)object).equals(I34.l01)) {
                            stringBuffer.append(I54.lif(i3I)).append(string);
                            continue;
                        }
                        if (((I3I)object).equals(I34.l0iF)) {
                            stringBuffer.append(I17.lif(i3I)).append(string);
                            continue;
                        }
                        if (((I3I)object).equals(I34.l11)) {
                            stringBuffer.append(I17.lif(i3I)).append(string);
                            continue;
                        }
                        stringBuffer.append(((I2I)object).ll());
                        stringBuffer.append(" value = ").append(I7.lif(i3I)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((I2I)object).ll());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isRevoked(Certificate certificate) {
        if (!certificate.getType().equals("X.509")) {
            throw new IllegalArgumentException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = this.ll.lI();
        I1 i1 = this.ll.liF();
        if (enumeration.hasMoreElements()) {
            BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
            while (enumeration.hasMoreElements()) {
                I2l i2l;
                I107.I7 i7 = I107.I7.lif(enumeration.nextElement());
                if (this.lIF && i7.l1() && (i2l = i7.lI().lif(I34.l0IF)) != null) {
                    i1 = I1.lif(I41.lif(i2l.l1()).lif()[0].ll());
                }
                if (!i7.lif().ll().equals(bigInteger)) continue;
                if (certificate instanceof X509Certificate) {
                    i2l = I1.lif(((X509Certificate)certificate).getIssuerX500Principal().getEncoded());
                } else {
                    try {
                        i2l = I10I.lif(certificate.getEncoded()).lIF();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IllegalArgumentException("Cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
                    }
                }
                return i1.equals(i2l);
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRL)) {
            return false;
        }
        if (object instanceof I1621) {
            boolean bl;
            I1621 i1621 = (I1621)object;
            if (this.llf && (bl = i1621.llf) && i1621.liF != this.liF) {
                return false;
            }
            return this.ll.equals(i1621.ll);
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (!this.llf) {
            this.liF = super.hashCode();
            this.llf = true;
        }
        return this.liF;
    }
}

