/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom;

import com.aspose.html.dom.Document;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.z1;
import com.aspose.html.internal.ms.System.Char;
import com.aspose.html.internal.ms.System.StringExtensions;

@DOMObjectAttribute
@DOMNameAttribute(name="Text")
public class Text
extends z1 {
    public Text(String data, Document doc) {
        super(data, doc);
    }

    @DOMNameAttribute(name="splitText")
    public Text splitText(int offset) {
        int n2 = this.getLength() - offset;
        String string = this.substringData(offset, n2);
        this.deleteData(offset, n2);
        Text text = this.nodeDocument.createTextNode(string);
        this.getParentNode().insertBefore(text, this.getNextSibling());
        return text;
    }

    @DOMNameAttribute(name="isElementContentWhitespace")
    public boolean isElementContentWhitespace() {
        for (int i2 = 0; i2 < this.getData().length(); ++i2) {
            char c2 = this.getData().charAt(i2);
            if (Char.isWhiteSpace(c2)) continue;
            return false;
        }
        return true;
    }

    @DOMNameAttribute(name="wholeText")
    public String getWholeText() {
        return this.getTextContent();
    }

    @DOMNameAttribute(name="replaceWholeText")
    public Text replaceWholeText(String content) {
        Node node;
        Node node2 = this.getFirstChild();
        while (node2 != null) {
            node = node2.getNextSibling();
            this.removeChild(node2);
            node2 = node;
        }
        node = this.getParentNode();
        Node node3 = this.getPreviousSibling();
        this.getParentNode().removeChild(this);
        if (StringExtensions.isNullOrEmpty(content)) {
            return null;
        }
        Text text = node.nodeDocument.createTextNode(content);
        if (node3 != null) {
            node.insertBefore(text, node3.getNextSibling());
        } else {
            node.appendChild(text);
        }
        return text;
    }

    @Override
    public String getNodeName() {
        return this.nodeDocument.strTextName;
    }

    @Override
    public int getNodeType() {
        return 3;
    }

    @Override
    public String getNodeValue() {
        return this.getData();
    }

    @Override
    public void setNodeValue(String value) {
        String string = value;
        if (string == null) {
            string = StringExtensions.Empty;
        }
        this.replaceData(0, this.getLength(), string);
    }

    @Override
    public String getTextContent() {
        return this.getData();
    }

    @Override
    public void setTextContent(String value) {
        String string = value;
        if (string == null) {
            string = StringExtensions.Empty;
        }
        this.replaceData(0, this.getLength(), string);
    }
}

