/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.canvas;

import com.aspose.html.HTMLCanvasElement;
import com.aspose.html.HTMLImageElement;
import com.aspose.html.dom.DOMObject;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.attributes.DOMParameterAttribute;
import com.aspose.html.dom.canvas.ICanvasGradient;
import com.aspose.html.dom.canvas.ICanvasPattern;
import com.aspose.html.dom.canvas.ICanvasRenderingContext2D;
import com.aspose.html.dom.canvas.IImageData;
import com.aspose.html.dom.canvas.ITextMetrics;
import com.aspose.html.dom.canvas.Path2D;
import com.aspose.html.dom.canvas.z1;
import com.aspose.html.dom.canvas.z10;
import com.aspose.html.dom.canvas.z14;
import com.aspose.html.dom.canvas.z18;
import com.aspose.html.dom.canvas.z2;
import com.aspose.html.dom.canvas.z3;
import com.aspose.html.dom.canvas.z4;
import com.aspose.html.dom.canvas.z5;
import com.aspose.html.dom.canvas.z7;
import com.aspose.html.dom.css.CSSPrimitiveValue;
import com.aspose.html.dom.css.CSSValue;
import com.aspose.html.dom.css.IDocumentStyle;
import com.aspose.html.dom.css.z1;
import com.aspose.html.drawing.IBrush;
import com.aspose.html.drawing.ITrueTypeFont;
import com.aspose.html.drawing.Unit;
import com.aspose.html.drawing.UnitType;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.DoubleExtensions;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.internal.ms.System.Drawing.Image;
import com.aspose.html.internal.ms.System.Drawing.Point;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.Drawing.SizeF;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p158.z16;
import com.aspose.html.internal.p46.z19;

@DOMObjectAttribute
@DOMNameAttribute(name="CanvasRenderingContext2D")
public class z9
extends DOMObject
implements ICanvasRenderingContext2D {
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("copy", "destination-atop", "destination-in", "destination-out", "destination-over", "lighter", "source-atop", "source-in", "source-out", "source-over", "xor", "butt", "round", "square", "miter", "bevel", "left", "start", "end", "right", "center", "alphabetic", "bottom", "hanging", "ideographic", "middle", "top");
    private z2 m4378;
    private HTMLCanvasElement m4387;
    private MemoryStream m4388;

    public z9(HTMLCanvasElement hTMLCanvasElement) {
        this.m4387 = hTMLCanvasElement;
        this.m4388 = new MemoryStream();
        this.m4378 = new z2(this.m4388);
        Document document = hTMLCanvasElement.getOwnerDocument();
        if (document.getContext().getService(com.aspose.html.internal.p225.z1.class) == null) {
            com.aspose.html.internal.p226.z1 z1100 = new com.aspose.html.internal.p226.z1((com.aspose.html.z3)document.getContext());
            document.getContext().addService(z1100, com.aspose.html.internal.p225.z1.class);
            z1100.m1(Operators.as(document, IDocumentStyle.class));
        }
        this.m4378.beginDocument(document);
        this.m4378.beginPage(new SizeF(Operators.castToFloat(this.m4387.getWidth(), 12), Operators.castToFloat(hTMLCanvasElement.getHeight(), 12)));
        this.m1010();
    }

    @Override
    public HTMLCanvasElement getCanvas() {
        return this.m4387;
    }

    private void m1010() {
        this.setFont("10px sans-serif");
        this.setTextAlign("start");
        this.setTextBaseline("alphabetic");
        this.setShadowColor("transparent");
        this.setStrokeStyle("black");
        this.setFillStyle("black");
        this.setGlobalAlpha(1.0);
        this.setGlobalCompositeOperation("source-over");
        this.setLineWidth(1.0);
        this.setLineCap("butt");
        this.setLineJoin("miter");
        this.setMiterLimit(10.0);
        this.setImageSmoothingEnabled(true);
    }

    @Override
    public double getGlobalAlpha() {
        return ((z4)this.m4378.getGraphicContext()).m1002();
    }

    @Override
    public void setGlobalAlpha(double value) {
        ((z4)this.m4378.getGraphicContext()).m33((float)value);
    }

    @Override
    public String getGlobalCompositeOperation() {
        switch (((z4)this.m4378.getGraphicContext()).m1003()) {
            case 9: {
                return "copy";
            }
            case 4: {
                return "destination-atop";
            }
            case 5: {
                return "destination-in";
            }
            case 6: {
                return "destination-out";
            }
            case 7: {
                return "destination-over";
            }
            case 8: {
                return "lighter";
            }
            case 0: {
                return "source-atop";
            }
            case 1: {
                return "source-in";
            }
            case 2: {
                return "source-out";
            }
            case 3: {
                return "source-over";
            }
            case 10: {
                return "xor";
            }
        }
        return "source-over";
    }

    @Override
    public void setGlobalCompositeOperation(String value) {
        switch (gStringSwitchMap.of(StringExtensions.toLower(StringExtensions.trim(value)))) {
            case 0: {
                ((z4)this.m4378.getGraphicContext()).m366(9);
                break;
            }
            case 1: {
                ((z4)this.m4378.getGraphicContext()).m366(4);
                break;
            }
            case 2: {
                ((z4)this.m4378.getGraphicContext()).m366(5);
                break;
            }
            case 3: {
                ((z4)this.m4378.getGraphicContext()).m366(6);
                break;
            }
            case 4: {
                ((z4)this.m4378.getGraphicContext()).m366(7);
                break;
            }
            case 5: {
                ((z4)this.m4378.getGraphicContext()).m366(8);
                break;
            }
            case 6: {
                ((z4)this.m4378.getGraphicContext()).m366(0);
                break;
            }
            case 7: {
                ((z4)this.m4378.getGraphicContext()).m366(1);
                break;
            }
            case 8: {
                ((z4)this.m4378.getGraphicContext()).m366(2);
                break;
            }
            case 9: {
                ((z4)this.m4378.getGraphicContext()).m366(3);
                break;
            }
            case 10: {
                ((z4)this.m4378.getGraphicContext()).m366(10);
                break;
            }
            default: {
                ((z4)this.m4378.getGraphicContext()).m366(3);
            }
        }
    }

    @Override
    public Object getStrokeStyle() {
        if (Operators.is(((z4)this.m4378.getGraphicContext()).getStrokeBrush(), z10.class)) {
            return ((z10)((z4)this.m4378.getGraphicContext()).getStrokeBrush()).m1011();
        }
        if (Operators.is(((z4)this.m4378.getGraphicContext()).getStrokeBrush(), ICanvasGradient.class) || Operators.is(((z4)this.m4378.getGraphicContext()).getStrokeBrush(), ICanvasPattern.class)) {
            return ((z4)this.m4378.getGraphicContext()).getStrokeBrush();
        }
        return null;
    }

    @Override
    public void setStrokeStyle(Object value) {
        if (Operators.is(value, String.class)) {
            ((z4)this.m4378.getGraphicContext()).setStrokeBrush(new z10(this.getCanvas(), (String)value));
            return;
        }
        if (Operators.is(value, ICanvasGradient.class) || Operators.is(value, ICanvasPattern.class)) {
            ((z4)this.m4378.getGraphicContext()).setStrokeBrush((IBrush)value);
            return;
        }
    }

    @Override
    public Object getFillStyle() {
        if (Operators.is(((z4)this.m4378.getGraphicContext()).getFillBrush(), z10.class)) {
            return ((z10)((z4)this.m4378.getGraphicContext()).getFillBrush()).m1011();
        }
        if (Operators.is(((z4)this.m4378.getGraphicContext()).getFillBrush(), ICanvasGradient.class) || Operators.is(((z4)this.m4378.getGraphicContext()).getFillBrush(), ICanvasPattern.class)) {
            return ((z4)this.m4378.getGraphicContext()).getFillBrush();
        }
        return null;
    }

    @Override
    public void setFillStyle(Object value) {
        if (Operators.is(value, String.class)) {
            try {
                ((z4)this.m4378.getGraphicContext()).setFillBrush(new z10(this.getCanvas(), (String)value));
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
            return;
        }
        if (Operators.is(value, ICanvasGradient.class) || Operators.is(value, ICanvasPattern.class)) {
            ((z4)this.m4378.getGraphicContext()).setFillBrush((IBrush)value);
            return;
        }
    }

    @Override
    public double getShadowOffsetX() {
        return ((z4)this.m4378.getGraphicContext()).m995();
    }

    @Override
    public void setShadowOffsetX(double value) {
        ((z4)this.m4378.getGraphicContext()).m30((float)value);
    }

    @Override
    public double getShadowOffsetY() {
        return ((z4)this.m4378.getGraphicContext()).m996();
    }

    @Override
    public void setShadowOffsetY(double value) {
        ((z4)this.m4378.getGraphicContext()).m31((float)value);
    }

    @Override
    public double getShadowBlur() {
        return ((z4)this.m4378.getGraphicContext()).m997();
    }

    @Override
    public void setShadowBlur(double value) {
        ((z4)this.m4378.getGraphicContext()).m32((float)value);
    }

    @Override
    public String getShadowColor() {
        return ((z4)this.m4378.getGraphicContext()).m999();
    }

    @Override
    public void setShadowColor(String value) {
        ((z4)this.m4378.getGraphicContext()).m214(value);
        try {
            ((z4)this.m4378.getGraphicContext()).m2(z1.m1(value, this.getCanvas()).Clone());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public double getLineWidth() {
        return ((z4)this.m4378.getGraphicContext()).getLineWidth();
    }

    @Override
    public void setLineWidth(double value) {
        ((z4)this.m4378.getGraphicContext()).setLineWidth((float)value);
    }

    @Override
    public String getLineCap() {
        switch (((z4)this.m4378.getGraphicContext()).getLineCap()) {
            case 0: {
                return "butt";
            }
            case 2: {
                return "round";
            }
            case 1: {
                return "square";
            }
        }
        return "butt";
    }

    @Override
    public void setLineCap(String value) {
        switch (gStringSwitchMap.of(StringExtensions.toLower(StringExtensions.trim(value)))) {
            case 11: {
                ((z4)this.m4378.getGraphicContext()).setLineCap(0);
                break;
            }
            case 12: {
                ((z4)this.m4378.getGraphicContext()).setLineCap(2);
                break;
            }
            case 13: {
                ((z4)this.m4378.getGraphicContext()).setLineCap(1);
            }
        }
    }

    @Override
    public String getLineJoin() {
        switch (((z4)this.m4378.getGraphicContext()).getLineJoin()) {
            case 1: {
                return "bevel";
            }
            case 2: {
                return "round";
            }
            case 3: {
                return "miter";
            }
        }
        return "miter";
    }

    @Override
    public void setLineJoin(String value) {
        switch (gStringSwitchMap.of(StringExtensions.toLower(StringExtensions.trim(value)))) {
            case 14: {
                ((z4)this.m4378.getGraphicContext()).setLineJoin(3);
                break;
            }
            case 12: {
                ((z4)this.m4378.getGraphicContext()).setLineJoin(2);
                break;
            }
            case 15: {
                ((z4)this.m4378.getGraphicContext()).setLineJoin(1);
            }
        }
    }

    @Override
    public double getMiterLimit() {
        return ((z4)this.m4378.getGraphicContext()).getMiterLimit();
    }

    @Override
    public void setMiterLimit(double value) {
        ((z4)this.m4378.getGraphicContext()).setMiterLimit((float)value);
    }

    @Override
    public double getLineDashOffset() {
        return ((z4)this.m4378.getGraphicContext()).getLineDashOffset();
    }

    @Override
    public void setLineDashOffset(double value) {
        ((z4)this.m4378.getGraphicContext()).setLineDashOffset((float)value);
    }

    @Override
    public String getFont() {
        return ((z4)this.m4378.getGraphicContext()).m1006();
    }

    @Override
    public void setFont(String value) {
        z19 z1910 = (z19)this.getCanvas().nodeDocument.getBrowsingContext().m6().m1(StringExtensions.format("font:{0}", value), this.getCanvas());
        com.aspose.html.internal.p3.z1 z1100 = new com.aspose.html.internal.p3.z1(z1910);
        com.aspose.html.internal.p11.z5 z5100 = this.getCanvas().getOwnerDocument().getContext().getService(com.aspose.html.internal.p225.z1.class).m1(z1100).m3372();
        ((z4)this.m4378.getGraphicContext()).setFont(z5100.m225());
        ((z4)this.m4378.getGraphicContext()).setFontSize((float)Unit.fromPoints(z5100.m230()).getValue(UnitType.PX));
        ((z4)this.m4378.getGraphicContext()).setFontStyle(z5100.getStyle());
        ((z4)this.m4378.getGraphicContext()).m215(value);
    }

    @Override
    public String getTextAlign() {
        switch (((z4)this.m4378.getGraphicContext()).m1000()) {
            case 2: {
                return "left";
            }
            case 0: {
                return "start";
            }
            case 1: {
                return "end";
            }
            case 3: {
                return "right";
            }
            case 4: {
                return "center";
            }
        }
        return "start";
    }

    @Override
    public void setTextAlign(String value) {
        switch (gStringSwitchMap.of(StringExtensions.toLower(StringExtensions.trim(value)))) {
            case 16: {
                ((z4)this.m4378.getGraphicContext()).m364(2);
                break;
            }
            case 17: {
                ((z4)this.m4378.getGraphicContext()).m364(0);
                break;
            }
            case 18: {
                ((z4)this.m4378.getGraphicContext()).m364(1);
                break;
            }
            case 19: {
                ((z4)this.m4378.getGraphicContext()).m364(3);
                break;
            }
            case 20: {
                ((z4)this.m4378.getGraphicContext()).m364(4);
            }
        }
    }

    @Override
    public String getTextBaseline() {
        switch (((z4)this.m4378.getGraphicContext()).m1001()) {
            case 3: {
                return "alphabetic";
            }
            case 5: {
                return "bottom";
            }
            case 1: {
                return "hanging";
            }
            case 4: {
                return "ideographic";
            }
            case 2: {
                return "middle";
            }
            case 0: {
                return "top";
            }
        }
        return "alphabetic";
    }

    @Override
    public void setTextBaseline(String value) {
        switch (gStringSwitchMap.of(StringExtensions.toLower(StringExtensions.trim(value)))) {
            case 21: {
                ((z4)this.m4378.getGraphicContext()).m365(3);
                break;
            }
            case 22: {
                ((z4)this.m4378.getGraphicContext()).m365(5);
                break;
            }
            case 23: {
                ((z4)this.m4378.getGraphicContext()).m365(1);
                break;
            }
            case 24: {
                ((z4)this.m4378.getGraphicContext()).m365(4);
                break;
            }
            case 25: {
                ((z4)this.m4378.getGraphicContext()).m365(2);
                break;
            }
            case 26: {
                ((z4)this.m4378.getGraphicContext()).m365(0);
            }
        }
    }

    @Override
    public boolean getImageSmoothingEnabled() {
        return ((z4)this.m4378.getGraphicContext()).getImageSmoothingEnabled();
    }

    @Override
    public void setImageSmoothingEnabled(boolean value) {
        ((z4)this.m4378.getGraphicContext()).setImageSmoothingEnabled(value);
    }

    @Override
    public void addHitRegion(Dictionary<String, String> options) {
        throw new NotImplementedException();
    }

    @Override
    public void arc(double x2, double y2, double radius, double startAngle, double endAngle) {
        this.m4378.arc(x2, y2, radius, startAngle, endAngle, false);
    }

    @Override
    public void arc(double x2, double y2, double radius, double startAngle, double endAngle, boolean counterclockwise) {
        this.m4378.arc(x2, y2, radius, startAngle, endAngle, counterclockwise);
    }

    @Override
    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
        this.m4378.m1((float)x1, (float)y1, (float)x2, (float)y2, (float)radius);
    }

    @Override
    public void ellipse(double x2, double y2, double radiusX, double radiusY, double rotation, double startAngle, double endAngle) {
        this.m4378.m1((float)x2, (float)y2, (float)radiusX, (float)radiusY, (float)rotation, (float)startAngle, (float)endAngle, false);
    }

    @Override
    public void ellipse(double x2, double y2, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise) {
        this.m4378.m1((float)x2, (float)y2, (float)radiusX, (float)radiusY, (float)rotation, (float)startAngle, (float)endAngle, anticlockwise);
    }

    @Override
    public void beginPath() {
        this.m4378.beginPath();
    }

    @Override
    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x2, double y2) {
        this.m4378.cubicBezierTo(new PointF((float)cp1x, (float)cp1y), new PointF((float)cp2x, (float)cp2y), new PointF((float)x2, (float)y2));
    }

    @Override
    public void clearHitRegions() {
    }

    @Override
    public void clearRect(double x2, double y2, double w2, double h2) {
        this.m4378.clearRect(x2, y2, w2, h2);
    }

    @Override
    public void closePath() {
        this.m4378.closePath();
    }

    @Override
    public IImageData createImageData(double sw, double sh) {
        long l2 = Operators.castToUInt64(sw, 14);
        long l3 = Operators.castToUInt64(sh, 14);
        return new z14(l2, l3, new byte[(int)(l2 * l3 * 4L)]);
    }

    @Override
    public IImageData createImageData(IImageData imagedata) {
        return new z14(imagedata.getWidth(), imagedata.getHeight(), imagedata.getData());
    }

    @Override
    public ICanvasGradient createLinearGradient(double x0, double y0, double x1, double y1) {
        return new z3(x0, y0, x1, y1, this.getCanvas());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICanvasPattern createPattern(HTMLImageElement image, String repetition) {
        z5 z5100 = new z5(image);
        try {
            z7 z713 = new z7(this.m4378, z5100.m21(new RectangleF()), repetition);
            return z713;
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICanvasPattern createPattern(HTMLCanvasElement image, String repetition) {
        z5 z5100 = new z5(image);
        try {
            z7 z713 = new z7(this.m4378, z5100.m21(new RectangleF()), repetition);
            return z713;
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    @Override
    public ICanvasGradient createRadialGradient(double x0, double y0, double r0, double x1, double y1, double r1) {
        return new z3(x0, y0, r0, x1, y1, r1, this.getCanvas());
    }

    @Override
    public void drawFocusIfNeeded(Element element) {
        throw new NotImplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(HTMLImageElement image, double dx2, double dy2) {
        z5 z5100 = new z5(image);
        try {
            this.m1(z5100, 0.0, 0.0, (double)z5100.getWidth(), (double)z5100.getHeight(), dx2, dy2, (double)z5100.getWidth(), (double)z5100.getHeight());
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(HTMLCanvasElement image, double dx2, double dy2) {
        z5 z5100 = new z5(image);
        try {
            this.m1(z5100, 0.0, 0.0, (double)z5100.getWidth(), (double)z5100.getHeight(), dx2, dy2, (double)z5100.getWidth(), (double)z5100.getHeight());
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m1(Image image, double d2, double d3) {
        z5 z5100 = new z5(image);
        try {
            this.m1(z5100, 0.0, 0.0, (double)z5100.getWidth(), (double)z5100.getHeight(), d2, d3, (double)z5100.getWidth(), (double)z5100.getHeight());
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(HTMLImageElement image, double dx2, double dy2, double dw2, double dh2) {
        z5 z5100 = new z5(image);
        try {
            this.m1(z5100, 0.0, 0.0, (double)z5100.getWidth(), (double)z5100.getHeight(), dx2, dy2, dw2, dh2);
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(HTMLCanvasElement image, double dx2, double dy2, double dw2, double dh2) {
        z5 z5100 = new z5(image);
        try {
            this.m1(z5100, 0.0, 0.0, (double)z5100.getWidth(), (double)z5100.getHeight(), dx2, dy2, dw2, dh2);
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m1(Image image, double d2, double d3, double d4, double d5) {
        z5 z5100 = new z5(image);
        try {
            this.m1(z5100, 0.0, 0.0, (double)z5100.getWidth(), (double)z5100.getHeight(), d2, d3, d4, d5);
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(HTMLImageElement image, double sx, double sy, double sw, double sh, double dx2, double dy2, double dw2, double dh2) {
        z5 z5100 = new z5(image);
        try {
            this.m1(z5100, sx, sy, sw, sh, dx2, dy2, dw2, dh2);
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(HTMLCanvasElement image, double sx, double sy, double sw, double sh, double dx2, double dy2, double dw2, double dh2) {
        z5 z5100 = new z5(image);
        try {
            this.m1(z5100, sx, sy, sw, sh, dx2, dy2, dw2, dh2);
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m1(Image image, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        z5 z5100 = new z5(image);
        try {
            this.m1(z5100, d2, d3, d4, d5, d6, d7, d8, d9);
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    private void m1(z5 z5100, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        RectangleF rectangleF = new RectangleF((float)d2, (float)d3, (float)d4, (float)d5);
        if (rectangleF.isEmpty()) {
            return;
        }
        RectangleF rectangleF2 = RectangleF.intersect(rectangleF.Clone(), new RectangleF(0.0f, 0.0f, z5100.getWidth(), z5100.getHeight())).Clone();
        if (rectangleF2.isEmpty()) {
            return;
        }
        RectangleF rectangleF3 = new RectangleF((float)d6, (float)d7, (float)d8 * rectangleF2.getWidth() / rectangleF.getWidth(), (float)d9 * rectangleF2.getHeight() / rectangleF.getHeight());
        if (rectangleF3.isEmpty()) {
            return;
        }
        this.m4378.drawImage(z5100.m21(rectangleF2.Clone()), 6, rectangleF3.Clone());
    }

    @Override
    public void fillRect(double x2, double y2, double w2, double h2) {
        this.m4378.m1((float)x2, (float)y2, (float)w2, (float)h2);
    }

    @Override
    public void fillText(String text, double x2, double y2, @DOMParameterAttribute(name="maxWidth", optional=true) Double maxWidth) {
        boolean bl2;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray = new double[]{0.0};
        double[] dArray2 = new double[]{0.0};
        double[] dArray3 = new double[]{0.0};
        boolean bl3 = !this.m1(text, x2, y2, maxWidth, dArray, dArray2, dArray3);
        d2 = dArray[0];
        d3 = dArray2[0];
        d4 = dArray3[0];
        if (bl3) {
            return;
        }
        this.m4378.fillText(text, new PointF((float)d3, (float)d4));
        boolean bl4 = bl2 = maxWidth != null;
        if (bl2 && d2 > maxWidth) {
            this.restore();
        }
    }

    private boolean m1(String string, double d2, double d3, Double d4, double[] dArray, double[] dArray2, double[] dArray3) {
        boolean bl2;
        boolean bl3;
        dArray[0] = 0.0;
        dArray2[0] = 0.0;
        dArray3[0] = 0.0;
        if (StringExtensions.isNullOrEmpty(string)) {
            return false;
        }
        boolean bl4 = bl3 = d4 != null;
        if (bl3 && d4 <= 0.0) {
            return false;
        }
        z19 z1910 = this.getCanvas().getComputedStyle();
        CSSValue cSSValue = z1910.getPropertyCSSValue("direction");
        float f2 = ((CSSPrimitiveValue)z1910.getPropertyCSSValue("letter-spacing")).getFloatValue(9);
        ((z4)this.m4378.getGraphicContext()).m34(f2);
        SizeF sizeF = this.m4378.m213(string).Clone();
        dArray[0] = sizeF.getWidth() + f2 * (float)(string.length() - 1);
        boolean bl5 = bl2 = d4 != null;
        if (bl2 && dArray[0] > d4) {
            this.save();
            this.transform(d4 / dArray[0], 0.0, 0.0, 1.0, 0.0, 0.0);
            dArray[0] = d4;
        }
        dArray2[0] = d2;
        if (((z4)this.m4378.getGraphicContext()).m1000() == 2 || ((z4)this.m4378.getGraphicContext()).m1000() == 0 && cSSValue.equals((Object)z1.z2.m4603) || ((z4)this.m4378.getGraphicContext()).m1000() == 1 && cSSValue.equals((Object)z1.z2.m4604)) {
            dArray2[0] = d2;
        }
        if (((z4)this.m4378.getGraphicContext()).m1000() == 3 || ((z4)this.m4378.getGraphicContext()).m1000() == 1 && cSSValue.equals((Object)z1.z2.m4603) || ((z4)this.m4378.getGraphicContext()).m1000() == 0 && cSSValue.equals((Object)z1.z2.m4604)) {
            dArray2[0] = d2 - Operators.castToDouble(this.m4387.getWidth(), 12);
        }
        if (((z4)this.m4378.getGraphicContext()).m1000() == 4) {
            dArray2[0] = d2 - (double)(Operators.castToFloat(this.m4387.getWidth(), 12) / 2.0f);
        }
        dArray3[0] = d3;
        ITrueTypeFont iTrueTypeFont = ((z4)this.m4378.getGraphicContext()).getFont();
        float f3 = ((z4)this.m4378.getGraphicContext()).getFontSize();
        float f4 = iTrueTypeFont.getAscent(f3);
        float f5 = iTrueTypeFont.getDescent(f3);
        if (((z4)this.m4378.getGraphicContext()).m1001() == 0) {
            dArray3[0] = d3 + (double)f4 + (double)f5;
        }
        if (((z4)this.m4378.getGraphicContext()).m1001() == 1) {
            dArray3[0] = d3 + msMath.round((f4 + f5) * 0.8f);
        }
        if (((z4)this.m4378.getGraphicContext()).m1001() == 2) {
            dArray3[0] = d3 + (double)((f4 + f5) / 2.0f);
        }
        if (((z4)this.m4378.getGraphicContext()).m1001() == 3) {
            dArray3[0] = d3 + (double)f5;
        }
        if (((z4)this.m4378.getGraphicContext()).m1001() == 4) {
            dArray3[0] = d3 + (double)f5;
        }
        if (((z4)this.m4378.getGraphicContext()).m1001() == 5) {
            dArray3[0] = d3;
        }
        dArray3[0] = dArray3[0] - (double)f5;
        return true;
    }

    @Override
    public IImageData getImageData(double sx, double sy, double sw, double sh) {
        return this.m4378.m2(sx, sy, sw, sh);
    }

    @Override
    public double[] getLineDash() {
        float[] fArray = ((z4)this.m4378.getGraphicContext()).getLineDashPattern();
        double[] dArray = new double[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            dArray[i2] = fArray[i2];
        }
        return dArray;
    }

    @Override
    public void setLineDash(double[] segments) {
        if (segments == null) {
            return;
        }
        float[] fArray = new float[segments.length];
        for (int i2 = 0; i2 < segments.length; ++i2) {
            fArray[i2] = (float)segments[i2];
        }
        ((z4)this.m4378.getGraphicContext()).setLineDashPattern(fArray);
    }

    @Override
    public void lineTo(double x2, double y2) {
        this.m4378.lineTo(new PointF((float)x2, (float)y2));
    }

    @Override
    public ITextMetrics measureText(String text) {
        return new z18(this.m4378.m213(text).getWidth());
    }

    @Override
    public void moveTo(double x2, double y2) {
        this.m4378.moveTo(new PointF((float)x2, (float)y2));
    }

    @Override
    public void putImageData(IImageData imagedata, double dx2, double dy2) {
        this.m4378.m1(imagedata, new Point(Operators.castToInt32(dx2, 14), Operators.castToInt32(dy2, 14)), new z16(), 1.0f, false);
    }

    @Override
    public void putImageData(IImageData imageData, double dx2, double dy2, double dirtyX, double dirtyY, double dirtyWidth, double dirtyHeight) {
        if (dirtyWidth < 0.0) {
            dirtyX += dirtyWidth;
            dirtyWidth = msMath.abs(dirtyWidth);
        }
        if (dirtyHeight < 0.0) {
            dirtyY += dirtyHeight;
            dirtyHeight = msMath.abs(dirtyHeight);
        }
        if (dirtyX < 0.0) {
            dirtyWidth += dirtyX;
            dirtyX = 0.0;
        }
        if (dirtyY < 0.0) {
            dirtyHeight += dirtyY;
            dirtyY = 0.0;
        }
        if (dirtyX + dirtyWidth > (double)imageData.getWidth()) {
            dirtyWidth = Operators.castToDouble(imageData.getWidth(), 12) - dirtyX;
        }
        if (dirtyY + dirtyHeight > (double)imageData.getHeight()) {
            dirtyHeight = Operators.castToDouble(imageData.getHeight(), 12) - dirtyY;
        }
        if (dirtyWidth <= 0.0 || dirtyHeight <= 0.0) {
            return;
        }
        int n2 = 4;
        z14 z1410 = new z14(Operators.castToUInt64(dirtyWidth, 14), Operators.castToUInt64(dirtyHeight, 14), new byte[Operators.castToInt32(dirtyWidth * (double)n2 * dirtyHeight, 14)]);
        double d2 = dirtyX + dirtyWidth;
        double d3 = dirtyY + dirtyHeight;
        int n3 = (int)imageData.getWidth() * n2;
        int n4 = (int)z1410.getWidth() * n2;
        int n5 = Operators.castToInt32(dirtyX, 14);
        int n6 = 0;
        while ((double)n5 < d2) {
            int n7 = Operators.castToInt32(dirtyY, 14);
            int n8 = 0;
            while ((double)n7 < d3) {
                z1410.getData()[n6 * n2 + n8 * n4] = imageData.getData()[n5 * n2 + n7 * n3];
                z1410.getData()[n6 * n2 + n8 * n4 + 1] = imageData.getData()[n5 * n2 + n7 * n3 + 1];
                z1410.getData()[n6 * n2 + n8 * n4 + 2] = imageData.getData()[n5 * n2 + n7 * n3 + 2];
                z1410.getData()[n6 * n2 + n8 * n4 + 3] = imageData.getData()[n5 * n2 + n7 * n3 + 3];
                ++n7;
                ++n8;
            }
            ++n5;
            ++n6;
        }
        this.putImageData(z1410, dx2 + dirtyX, dy2 + dirtyY);
    }

    @Override
    public void quadraticCurveTo(double cpx, double cpy, double x2, double y2) {
        PointF pointF = new PointF((float)cpx, (float)cpy);
        PointF pointF2 = new PointF((float)x2, (float)y2);
        PointF[] pointFArray = com.aspose.html.internal.p106.z4.m1(this.m4378.getLastPoint().Clone(), pointF.Clone(), pointF2.Clone());
        this.m4378.cubicBezierTo(pointFArray[0].Clone(), pointFArray[1].Clone(), pointF2.Clone());
    }

    @Override
    public void rect(double x2, double y2, double w2, double h2) {
        this.m4378.addRect(new RectangleF((float)x2, (float)y2, (float)w2, (float)h2));
    }

    @Override
    public void removeHitRegion(String id2) {
    }

    @Override
    public void restore() {
        this.m4378.restoreGraphicContext();
    }

    @Override
    public void rotate(double angle) {
        try {
            Matrix matrix = new Matrix();
            matrix.rotate((float)(angle * 57.29577951308232));
            ((z4)this.m4378.getGraphicContext()).transform(matrix);
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    @Override
    public void save() {
        this.m4378.saveGraphicContext();
    }

    @Override
    public void scale(double x2, double y2) {
        try {
            if (DoubleExtensions.equals(x2, 0.0)) {
                x2 = 1.0E-9f;
            }
            if (DoubleExtensions.equals(y2, 0.0)) {
                y2 = 1.0E-9f;
            }
            ((z4)this.m4378.getGraphicContext()).transform(new Matrix((float)x2, 0.0f, 0.0f, (float)y2, 0.0f, 0.0f));
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    @Override
    public void setTransform(double a2, double b2, double c2, double d2, double e2, double f2) {
        try {
            ((z4)this.m4378.getGraphicContext()).setTransformationMatrix(new Matrix((float)a2, (float)b2, (float)c2, (float)d2, (float)e2, (float)f2));
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    @Override
    public void strokeRect(double x2, double y2, double w2, double h2) {
        this.m4378.m2((float)x2, (float)y2, (float)w2, (float)h2);
    }

    @Override
    public void strokeText(String text, double x2, double y2, @DOMParameterAttribute(name="maxWidth", optional=true) Double maxWidth) {
        boolean bl2;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray = new double[]{0.0};
        double[] dArray2 = new double[]{0.0};
        double[] dArray3 = new double[]{0.0};
        boolean bl3 = !this.m1(text, x2, y2, maxWidth, dArray, dArray2, dArray3);
        d2 = dArray[0];
        d3 = dArray2[0];
        d4 = dArray3[0];
        if (bl3) {
            return;
        }
        this.m4378.strokeText(text, new PointF((float)d3, (float)d4));
        boolean bl4 = bl2 = maxWidth != null;
        if (bl2 && d2 > maxWidth) {
            this.restore();
        }
    }

    @Override
    public void transform(double a2, double b2, double c2, double d2, double e2, double f2) {
        try {
            ((z4)this.m4378.getGraphicContext()).transform(new Matrix((float)a2, (float)b2, (float)c2, (float)d2, (float)e2, (float)f2));
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    @Override
    public void translate(double x2, double y2) {
        try {
            ((z4)this.m4378.getGraphicContext()).transform(new Matrix(1.0f, 0.0f, 0.0f, 1.0f, (float)x2, (float)y2));
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    private int m367(int n2) {
        return n2 == 0 ? 1 : 0;
    }

    @Override
    public void fill() {
        this.fill(0);
    }

    @Override
    public void fill(Path2D path) {
        this.fill(path, 0);
    }

    @Override
    public void fill(int fillRule) {
        this.m4378.fill(this.m367(fillRule));
    }

    @Override
    public void fill(Path2D path, int fillRule) {
        int n2 = this.m367(fillRule);
        this.m4378.m1(path.getPath(), n2);
    }

    @Override
    public void stroke() {
        this.m4378.stroke();
    }

    @Override
    public void stroke(Path2D path) {
        this.m4378.m2(path.getPath());
    }

    @Override
    public void clip() {
        this.m4378.clip(1);
    }

    @Override
    public void clip(int fillRule) {
        this.m4378.clip(this.m367(fillRule));
    }

    @Override
    public void clip(Path2D path, int fillRule) {
        this.m4378.m2(path.getPath(), this.m367(fillRule));
    }

    @Override
    public boolean isPointInPath(double x2, double y2, @DOMParameterAttribute(name="fillRule", optional=true, defaultValue=0L) int fillRule) {
        return this.m4378.isPointInPath(x2, y2, this.m367(fillRule));
    }

    @Override
    public boolean isPointInPath(Path2D path, double x2, double y2, @DOMParameterAttribute(name="fillRule", optional=true, defaultValue=0L) int fillRule) {
        return this.m4378.m1(path.getPath(), x2, y2, this.m367(fillRule));
    }

    @Override
    public boolean isPointInStroke(double x2, double y2) {
        return this.m4378.isPointInStroke(x2, y2);
    }

    @Override
    public boolean isPointInStroke(Path2D path, double x2, double y2) {
        return this.m4378.m1(path.getPath(), x2, y2);
    }

    @Override
    public void resetTransform() {
        this.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }
}

