/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.svg.collections;

import com.aspose.html.dom.Node;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMNoInterfaceObjectAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.svg.datatypes.SVGValueType;
import com.aspose.html.dom.svg.datatypes.z1;
import com.aspose.html.internal.ms.System.Action;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerable;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.ComponentModel.PropertyChangedEventArgs;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p4.z14;
import com.aspose.html.internal.p4.z20;
import com.aspose.html.internal.p4.z21;

@DOMObjectAttribute
@DOMNoInterfaceObjectAttribute
public abstract class SVGListBase<T>
extends SVGValueType
implements IGenericEnumerable<T> {
    private final List<T> itemsList = new List();
    private final Dictionary<T, IDisposable> subscribers = new Dictionary();

    protected SVGListBase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SVGListBase(IGenericEnumerable<T> enumerable) {
        z1 z1100 = new z1(this);
        try {
            IGenericEnumerator<T> iGenericEnumerator = enumerable.iterator();
            while (iGenericEnumerator.hasNext()) {
                this.appendItem(iGenericEnumerator.next());
            }
        }
        finally {
            if (z1100 != null) {
                z1100.dispose();
            }
        }
    }

    @DOMNameAttribute(name="item")
    public T get_Item(long index) {
        return this.getItem(index);
    }

    @DOMNameAttribute(name="item")
    public void set_Item(long index, T value) {
        this.replaceItem(value, index);
    }

    @DOMNameAttribute(name="length")
    public long getLength() {
        return Operators.castToUInt64(this.itemsList.size(), 9);
    }

    @DOMNameAttribute(name="numberOfItems")
    public long getNumberOfItems() {
        return Operators.castToUInt64(this.itemsList.size(), 9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DOMNameAttribute(name="clear")
    public void clear() {
        if (this.isReadOnly()) {
            throw com.aspose.html.internal.p68.z1.m1235();
        }
        z1 z1100 = new z1(this);
        try {
            IGenericEnumerator iGenericEnumerator = this.itemsList.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    Object e2 = iGenericEnumerator.next();
                    this.detach(e2);
                }
            }
            finally {
                if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
            this.itemsList.clear();
        }
        finally {
            if (z1100 != null) {
                z1100.dispose();
            }
        }
        this.notifyPropertyChanged(this, "Length");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DOMNameAttribute(name="initialize")
    public T initialize(T newItem) {
        if (this.isReadOnly()) {
            throw com.aspose.html.internal.p68.z1.m1235();
        }
        z1 z1100 = new z1(this);
        try {
            Object object;
            IGenericEnumerator iGenericEnumerator = this.itemsList.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    object = iGenericEnumerator.next();
                    this.detach(object);
                }
            }
            finally {
                if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
            this.itemsList.clear();
            object = Operators.as(newItem, SVGValueType.class);
            if (object != null && !((SVGValueType)object).isDetached()) {
                newItem = ((SVGValueType)object).deepClone();
            }
            this.itemsList.addItem(newItem);
            this.attach(newItem);
        }
        finally {
            if (z1100 != null) {
                z1100.dispose();
            }
        }
        this.notifyPropertyChanged(this, "Length");
        return newItem;
    }

    @DOMNameAttribute(name="getItem")
    public T getItem(long index) {
        if (index >= this.getLength()) {
            throw com.aspose.html.internal.p68.z1.m1231();
        }
        return this.itemsList.get_Item((int)index);
    }

    @DOMNameAttribute(name="insertItemBefore")
    public T insertItemBefore(T newItem, long index) {
        if (this.isReadOnly()) {
            throw com.aspose.html.internal.p68.z1.m1235();
        }
        SVGValueType sVGValueType = Operators.as(newItem, SVGValueType.class);
        if (sVGValueType != null && !sVGValueType.isDetached()) {
            newItem = sVGValueType.deepClone();
        }
        if (index > this.getLength()) {
            index = this.getLength();
        }
        this.itemsList.insertItem((int)index, newItem);
        this.attach(newItem);
        return newItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DOMNameAttribute(name="replaceItem")
    public T replaceItem(T newItem, long index) {
        if (this.isReadOnly()) {
            throw com.aspose.html.internal.p68.z1.m1235();
        }
        if (index >= this.getLength()) {
            throw com.aspose.html.internal.p68.z1.m1231();
        }
        SVGValueType sVGValueType = Operators.as(newItem, SVGValueType.class);
        if (sVGValueType != null && !sVGValueType.isDetached()) {
            newItem = sVGValueType.deepClone();
        }
        z1 z1100 = new z1(this);
        try {
            this.detach(this.itemsList.get_Item((int)index));
            this.itemsList.removeAt((int)index);
            this.itemsList.insertItem((int)index, newItem);
            this.attach(newItem);
        }
        finally {
            if (z1100 != null) {
                z1100.dispose();
            }
        }
        this.notifyPropertyChanged(this, "Length");
        return newItem;
    }

    @DOMNameAttribute(name="removeItem")
    public T removeItem(long index) {
        if (this.isReadOnly()) {
            throw com.aspose.html.internal.p68.z1.m1235();
        }
        if (index >= this.getLength()) {
            throw com.aspose.html.internal.p68.z1.m1231();
        }
        T t2 = this.itemsList.get_Item((int)index);
        this.itemsList.removeAt((int)index);
        this.detach(t2);
        return t2;
    }

    @DOMNameAttribute(name="appendItem")
    public T appendItem(T newItem) {
        if (this.isReadOnly()) {
            throw com.aspose.html.internal.p68.z1.m1235();
        }
        SVGValueType sVGValueType = Operators.as(newItem, SVGValueType.class);
        if (sVGValueType != null && !sVGValueType.isDetached()) {
            newItem = sVGValueType.deepClone();
        }
        this.itemsList.addItem(newItem);
        this.attach(newItem);
        return newItem;
    }

    @Override
    public IGenericEnumerator<T> iterator() {
        return this.itemsList.iterator();
    }

    private void detach(T newItem) {
        if (Operators.is(newItem, SVGValueType.class)) {
            SVGValueType sVGValueType = Operators.as(newItem, SVGValueType.class);
            sVGValueType.setDetached(true);
            this.subscribers.get_Item(newItem).dispose();
            this.subscribers.removeItemByKey(newItem);
        }
        this.notifyPropertyChanged(this, "Length");
    }

    private void attach(T newItem) {
        if (Operators.is(newItem, SVGValueType.class)) {
            SVGValueType sVGValueType = Operators.as(newItem, SVGValueType.class);
            sVGValueType.setDetached(false);
            IDisposable iDisposable = z20.m3(sVGValueType).subscribe(z14.m1(new Action<z21<PropertyChangedEventArgs>>(){

                public void m1(z21<PropertyChangedEventArgs> z2110) {
                    SVGListBase.this.notifyPropertyChanged(SVGListBase.this, "List");
                }

                @Override
                public /* synthetic */ void invoke(Object object) {
                    this.m1((z21)object);
                }
            }));
            this.subscribers.addItem(newItem, iDisposable);
        }
        this.notifyPropertyChanged(this, "Length");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(boolean disposing) {
        IGenericEnumerator iGenericEnumerator = ((Dictionary.ValueCollection)this.subscribers.getValues()).iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IDisposable iDisposable = (IDisposable)iGenericEnumerator.next();
                iDisposable.dispose();
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVGValueType asReadOnly() {
        SVGListBase sVGListBase = (SVGListBase)super.asReadOnly();
        IEnumerator iEnumerator = sVGListBase.iterator();
        try {
            while (iEnumerator.hasNext()) {
                Object e2 = iEnumerator.next();
                SVGValueType sVGValueType = Operators.as(e2, SVGValueType.class);
                if (sVGValueType == null) continue;
                sVGValueType.flags.set(Node.z2.m4323, true);
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
        return sVGListBase;
    }
}

