/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections.ObjectModel;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.EqualityComparer;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericDictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEqualityComparer;
import com.aspose.html.internal.ms.System.Collections.Generic.KeyNotFoundException;
import com.aspose.html.internal.ms.System.Collections.ObjectModel.Collection;
import com.aspose.html.internal.ms.System.SerializableAttribute;

@SerializableAttribute
public abstract class KeyedCollection<TKey, TItem>
extends Collection<TItem> {
    private Dictionary<TKey, TItem> a;
    private IGenericEqualityComparer<TKey> b;
    private int c;

    protected KeyedCollection() {
        this(null, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer) {
        this(comparer, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer, int dictionaryCreationThreshold) {
        this.b = comparer != null ? comparer : new EqualityComparer.DefaultComparer<TKey>();
        this.c = dictionaryCreationThreshold;
        if (dictionaryCreationThreshold == 0) {
            this.a = new Dictionary(this.b);
        }
    }

    public boolean containsKey(TKey key) {
        if (this.a != null) {
            return this.a.containsKey(key);
        }
        return this.a(key) >= 0;
    }

    private int a(TKey TKey) {
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            TKey TKey2 = this.getKeyForItem(super.get_Item(i2));
            if (!this.b.equals(TKey, TKey2)) continue;
            return i2;
        }
        return -1;
    }

    public boolean removeByKey(TKey key) {
        Object object = null;
        if (this.a != null) {
            Object[] objectArray = new Object[]{object};
            boolean bl2 = this.a.tryGetValue(key, objectArray);
            object = objectArray[0];
            if (bl2) {
                return super.removeItem(object);
            }
            return false;
        }
        int n2 = this.a(key);
        if (n2 == -1) {
            return false;
        }
        this.removeAt(n2);
        return true;
    }

    public IGenericEqualityComparer<TKey> getComparer() {
        return this.b;
    }

    @Override
    public TItem get_Item(int index) {
        if (this.a != null && ((Dictionary.KeyCollection)this.a.getKeys()).size() > 0) {
            IGenericEnumerator iGenericEnumerator = ((Dictionary.KeyCollection)this.a.getKeys()).iterator();
            if (iGenericEnumerator.hasNext() && iGenericEnumerator.next() instanceof Integer) {
                return this.get_Item((TKey)index);
            }
            return (TItem)super.get_Item(index);
        }
        return (TItem)super.get_Item(index);
    }

    public TItem get_Item(TKey key) {
        if (this.a != null) {
            return this.a.get_Item(key);
        }
        int n2 = this.a(key);
        if (n2 >= 0) {
            return (TItem)super.get_Item(n2);
        }
        throw new KeyNotFoundException();
    }

    protected void changeItemKey(TItem item, TKey newKey) {
        if (!this.containsItem(item)) {
            throw new ArgumentException();
        }
        TKey TKey = this.getKeyForItem(item);
        if (this.b.equals(TKey, newKey)) {
            return;
        }
        if (this.containsKey(newKey)) {
            throw new ArgumentException();
        }
        if (this.a != null) {
            if (!this.a.removeItemByKey(TKey)) {
                throw new ArgumentException();
            }
            this.a.addItem(newKey, item);
        }
    }

    @Override
    public void clear() {
        if (this.a != null) {
            this.a.clear();
        }
        super.clear();
    }

    protected abstract TKey getKeyForItem(TItem var1);

    @Override
    public void insertItem(int index, TItem item) {
        int n2;
        TKey TKey = this.getKeyForItem(item);
        if (TKey == null) {
            throw new ArgumentNullException("GetKeyForItem(item)");
        }
        if (this.a != null && this.a.containsKey(TKey)) {
            throw new ArgumentException("An element with the same key already exists in the dictionary.");
        }
        if (this.a == null) {
            for (n2 = 0; n2 < this.size(); ++n2) {
                if (!this.b.equals(TKey, this.getKeyForItem(super.get_Item(n2)))) continue;
                throw new ArgumentException("An element with the same key already exists in the dictionary.");
            }
        }
        super.insertItem(index, item);
        if (this.a != null) {
            this.a.addItem(TKey, item);
        } else if (this.c != -1 && this.size() > this.c) {
            this.a = new Dictionary(this.b);
            for (n2 = 0; n2 < this.size(); ++n2) {
                Object t2 = super.get_Item(n2);
                this.a.addItem(this.getKeyForItem(t2), t2);
            }
        }
    }

    @Override
    public void removeAt(int index) {
        if (this.a != null) {
            TKey TKey = this.getKeyForItem(super.get_Item(index));
            this.a.removeItemByKey(TKey);
        }
        super.removeAt(index);
    }

    @Override
    public void setItem(int index, TItem item) {
        if (this.a != null) {
            this.a.removeItemByKey(this.getKeyForItem(super.get_Item(index)));
            this.a.addItem(this.getKeyForItem(item), item);
        }
        super.setItem(index, item);
    }

    protected IGenericDictionary<TKey, TItem> getDictionary() {
        return this.a;
    }
}

