/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.HatchBrush;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.internal.ms.System.Drawing.Image;
import com.aspose.html.internal.ms.System.Drawing.Rectangle;
import com.aspose.html.internal.ms.System.Drawing.TextureBrush;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.IDisposable;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public abstract class Brush
implements ICloneable,
IDisposable,
Paint,
Cloneable {
    private Matrix a = new Matrix();
    protected boolean _disposed = false;

    protected abstract Paint getNativeObject();

    @Override
    public PaintContext createContext(ColorModel cm2, java.awt.Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return this.createContextInternal(cm2, deviceBounds, userBounds, xform, hints);
    }

    protected PaintContext createContextInternal(ColorModel cm2, java.awt.Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        if (this.getBrushTransform().isInvertible()) {
            Matrix.multiply(xform, this.a.getNativeObject(), 1);
        }
        if (this instanceof HatchBrush) {
            HatchBrush hatchBrush = (HatchBrush)this;
            Image image = hatchBrush.getImage();
            TextureBrush textureBrush = new TextureBrush(image, 0, new Rectangle(0, 0, image.getWidth(), image.getHeight()));
            return textureBrush.getNativeObject().createContext(cm2, deviceBounds, userBounds, xform, hints);
        }
        return this.getNativeObject().createContext(cm2, deviceBounds, userBounds, xform, hints);
    }

    protected boolean isDisposed() {
        return this._disposed;
    }

    protected void setDisposed() {
        this._disposed = true;
    }

    @Override
    public int getTransparency() {
        if (this.isDisposed()) {
            return 1;
        }
        return this.getNativeObject().getTransparency();
    }

    @Override
    public abstract Object deepClone();

    @Override
    public void dispose() {
        this.dispose(true);
    }

    protected void dispose(boolean disposing) {
    }

    protected Brush internalClone() {
        Brush brush = (Brush)this.memberwiseClone();
        brush.a = this.a.deepClone();
        return brush;
    }

    public Matrix getBrushTransform() {
        return this.a.deepClone();
    }

    public void setBrushTransform(Matrix value) {
        if (value == null) {
            throw new ArgumentNullException("Value cannot be null");
        }
        if (!value.isInvertible()) {
            throw new ArgumentException("Value is not valid");
        }
        value.copyTo(this.a);
    }

    protected void brushTranslateTransform(float dx2, float dy2) {
        this.brushTranslateTransform(dx2, dy2, 0);
    }

    protected void brushTranslateTransform(float dx2, float dy2, int order) {
        this.a.translate(dx2, dy2, order);
    }

    protected void brushResetTransform() {
        this.a.reset();
    }

    protected void brushRotateTransform(float angle) {
        this.brushRotateTransform(angle, 0);
    }

    protected void brushRotateTransform(float angle, int order) {
        this.a.rotate(angle, order);
    }

    protected void brushScaleTransform(float sx, float sy) {
        this.brushScaleTransform(sx, sy, 0);
    }

    protected void brushScaleTransform(float sx, float sy, int order) {
        this.a.scale(sx, sy, order);
    }

    protected void brushMultiplyTransform(Matrix matrix) {
        this.brushMultiplyTransform(matrix, 0);
    }

    protected void brushMultiplyTransform(Matrix matrix, int order) {
        if (matrix == null) {
            throw new ArgumentNullException("Value of 'matrix' cannot be null");
        }
        if (!matrix.isInvertible()) {
            throw new ArgumentException("Value of 'matrix' is invalid");
        }
        Matrix matrix2 = matrix.deepClone();
        Matrix.multiply(this.a.getNativeObject(), matrix2.getNativeObject(), order);
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

