/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing.Imaging;

import com.aspose.html.internal.ms.System.Drawing.Image;
import com.aspose.html.internal.ms.System.Drawing.Imaging.ColorPalette;
import com.aspose.html.internal.ms.System.IntPtr;
import com.aspose.html.internal.ms.core.memory.Pointer;

public final class BitmapData {
    private int a;
    private int b;
    private int c;
    private int d;
    private IntPtr e;
    private int f;
    private ColorPalette g;
    private int h;
    private IntPtr i;
    private float j;
    private float k;
    private int l;
    private int m;
    private int n;
    private int o;
    private int p;
    private int q;

    public BitmapData() {
    }

    public BitmapData(int width, int height, int lockPixelFormat, int stride, int reserved, byte[] resultPixels) {
        this.b = height;
        this.a = width;
        this.c = stride;
        this.d = lockPixelFormat;
        this.f = reserved;
        this.e = new IntPtr(Pointer.create(resultPixels));
    }

    public int getHeight() {
        return this.b;
    }

    public void setHeight(int value) {
        this.b = value;
    }

    public int getWidth() {
        return this.a;
    }

    public void setWidth(int value) {
        this.a = value;
    }

    public int getPixelFormat() {
        return this.d;
    }

    public void setPixelFormat(int value) {
        this.d = value;
    }

    public int getReserved() {
        return this.f;
    }

    public void setReserved(int value) {
        this.f = value;
    }

    public IntPtr getScan0() {
        return this.e;
    }

    public void setScan0(IntPtr value) {
        this.e = value;
    }

    public static int calcBufferStride(int lockAreaWidth, int bitsPerPixel) {
        int n2 = lockAreaWidth * bitsPerPixel / 32;
        int n3 = lockAreaWidth * bitsPerPixel % 32;
        return n2 * 4 + (n3 > 0 ? 4 : 0);
    }

    public static int calcBufferTail(int lockAreaWidth, int bitsPerPixel, int stride) {
        if (bitsPerPixel < 8) {
            int n2 = 8 / bitsPerPixel;
            int n3 = lockAreaWidth / n2 + (lockAreaWidth % n2 == 0 ? 0 : 1);
            return stride - n3;
        }
        int n4 = bitsPerPixel >> 3;
        return stride - lockAreaWidth * n4;
    }

    public int getStride() {
        return this.c;
    }

    public void setStride(int value) {
        this.c = value;
    }

    public BitmapData Clone() {
        BitmapData bitmapData = new BitmapData();
        this.CloneTo(bitmapData);
        return bitmapData;
    }

    public void CloneTo(BitmapData data) {
        data.b = this.b;
        data.a = this.a;
        data.d = this.d;
        data.f = this.f;
        data.c = this.c;
        data.e = new IntPtr(this.getScan0().toPointer());
    }

    public void getPixel(int x2, int y2, int[] dstPixelSamples) {
        if (x2 < 0 || x2 > this.a - 1 || y2 < 0 || y2 > this.b - 1) {
            throw new ArrayIndexOutOfBoundsException("x or y out of locked area");
        }
        int n2 = Image.getPixelFormatSize(this.d);
        int n3 = n2 >> 3;
        if (n3 != 0) {
            int n4 = this.c;
            byte[] byArray = (byte[])this.e.toPointer().getData();
            int n5 = x2 * n3 + y2 * n4;
            for (int i2 = 0; i2 < n3; ++i2) {
                dstPixelSamples[i2] = byArray[n5++];
            }
        }
    }
}

