/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing.Imaging;

import com.aspose.html.drawing.Color;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Drawing.Imaging.ColorMap;
import com.aspose.html.internal.ms.System.Drawing.Imaging.ColorMatrix;
import com.aspose.html.internal.ms.System.Drawing.Imaging.ColorPalette;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.IDisposable;

public final class ImageAttributes
implements ICloneable,
IDisposable {
    private ImageAttribute a;
    private ImageAttribute b;
    private ImageAttribute c;
    private ImageAttribute d;
    private ImageAttribute e;
    public int wrapMode = 4;
    public Color color;

    @Override
    public void dispose() {
    }

    @Override
    public Object deepClone() {
        ImageAttributes imageAttributes = new ImageAttributes();
        imageAttributes.a = this.a != null ? this.a.Clone() : null;
        imageAttributes.b = this.b != null ? this.b.Clone() : null;
        imageAttributes.c = this.c != null ? this.c.Clone() : null;
        imageAttributes.d = this.d != null ? this.d.Clone() : null;
        imageAttributes.e = this.e != null ? this.e.Clone() : null;
        imageAttributes.color = this.color != null ? this.color.Clone() : null;
        imageAttributes.wrapMode = this.wrapMode;
        return imageAttributes;
    }

    public ImageAttribute getAttribute(int type) {
        ImageAttribute imageAttribute = this.a != null ? this.a : new ImageAttribute();
        switch (type) {
            case 0: {
                this.a = imageAttribute.Clone();
                return this.a;
            }
            case 1: {
                if (this.b == null) {
                    this.b = imageAttribute.Clone();
                }
                return this.b;
            }
            case 2: {
                if (this.c == null) {
                    this.c = imageAttribute.Clone();
                }
                return this.c;
            }
            case 3: {
                if (this.d == null) {
                    this.d = imageAttribute.Clone();
                }
                return this.d;
            }
            case 4: {
                if (this.e == null) {
                    this.e = imageAttribute.Clone();
                }
                return this.e;
            }
        }
        return null;
    }

    ImageAttribute a(int n2) {
        ImageAttribute imageAttribute = this.a != null ? this.a : new ImageAttribute();
        switch (n2) {
            case 0: {
                this.a = imageAttribute.Clone();
                return this.a;
            }
            case 1: {
                if (this.b == null) {
                    return imageAttribute.Clone();
                }
                return this.b;
            }
            case 2: {
                if (this.c == null) {
                    return imageAttribute.Clone();
                }
                return this.c;
            }
            case 3: {
                if (this.d == null) {
                    return imageAttribute.Clone();
                }
                return this.d;
            }
            case 4: {
                if (this.e == null) {
                    return imageAttribute.Clone();
                }
                return this.e;
            }
        }
        return null;
    }

    public void setColorMatrix(ColorMatrix newColorMatrix) {
        this.setColorMatrix(newColorMatrix, 0, 0);
    }

    public void setColorMatrix(ColorMatrix newColorMatrix, int flags) {
        this.setColorMatrix(newColorMatrix, flags, 0);
    }

    public void setColorMatrix(ColorMatrix newColorMatrix, int mode, int type) {
        this.getAttribute((int)type).clrMatrix = newColorMatrix;
        this.getAttribute((int)type).clrMatrixFlag = mode;
    }

    public void clearColorMatrix() {
        this.clearColorMatrix(0);
    }

    public void clearColorMatrix(int type) {
        ColorMatrix colorMatrix;
        this.getAttribute((int)type).clrMatrix = colorMatrix = new ColorMatrix();
    }

    public void setColorMatrices(ColorMatrix newColorMatrix, ColorMatrix gMatrix) {
        this.setColorMatrices(newColorMatrix, gMatrix, 0, 0);
    }

    public void setColorMatrices(ColorMatrix newColorMatrix, ColorMatrix gMatrix, int flags) {
        this.setColorMatrices(newColorMatrix, gMatrix, flags, 0);
    }

    public void setColorMatrices(ColorMatrix newColorMatrix, ColorMatrix gMatrix, int mode, int type) {
        this.getAttribute((int)type).clrMatrix = newColorMatrix;
        this.getAttribute((int)type).gMatrix = gMatrix;
        this.getAttribute((int)type).clrMatrixFlag = mode;
    }

    public void setThreshold(float thresh) {
        this.setThreshold(thresh, 0);
    }

    public void setThreshold(float thresh, int type) {
        ImageAttribute imageAttribute = this.getAttribute(type);
        imageAttribute.thresh = thresh;
        imageAttribute.a = true;
    }

    public void clearThreshold() {
        this.clearThreshold(0);
    }

    public void clearThreshold(int type) {
        ImageAttribute imageAttribute = this.getAttribute(type);
        imageAttribute.thresh = 1.0f;
        imageAttribute.a = false;
    }

    public void setGamma(float gamma) {
        this.setGamma(gamma, 0);
    }

    public void setGamma(float gamma, int type) {
        if (gamma <= 0.0f) {
            throw new ArgumentException();
        }
        ImageAttribute imageAttribute = this.getAttribute(type);
        imageAttribute.gamma = gamma;
    }

    public void clearGamma() {
        this.clearGamma(0);
    }

    public void clearGamma(int type) {
        this.a((int)type).gamma = 1.0f;
    }

    public void setNoOp() {
        this.setNoOp(0);
    }

    public void setNoOp(int type) {
        this.getAttribute((int)type).bNoOp = true;
    }

    public void clearNoOp() {
        this.clearNoOp(0);
    }

    public void clearNoOp(int type) {
        this.getAttribute((int)type).bNoOp = false;
    }

    public void setColorKey(Color clrLow, Color clrHigh) {
        this.setColorKey(clrLow.Clone(), clrHigh.Clone(), 0);
    }

    public void setColorKey(Color clrLow, Color clrHigh, int type) {
        if ((clrLow.getR() & 0xFF) > (clrHigh.getR() & 0xFF) || (clrLow.getG() & 0xFF) > (clrHigh.getG() & 0xFF) || (clrLow.getB() & 0xFF) > (clrHigh.getB() & 0xFF)) {
            throw new ArgumentException();
        }
        clrLow.CloneTo(this.getAttribute((int)type).clrLow);
        clrHigh.CloneTo(this.getAttribute((int)type).clrHigh);
    }

    public void clearColorKey() {
        this.clearColorKey(0);
    }

    public void clearColorKey(int type) {
    }

    public void setOutputChannel(int flags) {
        this.setOutputChannel(flags, 0);
    }

    public void setOutputChannel(int flags, int type) {
        if (flags != 0 && flags != 1 && flags != 2 && flags != 3 && flags != 4) {
            throw new ArgumentException();
        }
        if (type == 5 || type == 6) {
            throw new ArgumentException();
        }
        this.getAttribute((int)type).clrChannelFlags = flags;
    }

    public void clearOutputChannel() {
        this.clearOutputChannel(0);
    }

    public void clearOutputChannel(int type) {
        if (type == 5 || type == 6) {
            throw new ArgumentException();
        }
        this.getAttribute((int)type).clrChannelFlags = 0;
    }

    public void setOutputChannelColorProfile(String clrProfileFilename) {
        this.setOutputChannelColorProfile(clrProfileFilename, 0);
    }

    public void setOutputChannelColorProfile(String clrProfileFilename, int type) {
        this.getAttribute((int)type).clrProfileFilename = clrProfileFilename;
    }

    public void clearOutputChannelColorProfile() {
        this.clearOutputChannelColorProfile(0);
    }

    public void clearOutputChannelColorProfile(int type) {
        this.getAttribute((int)type).clrProfileFilename = null;
    }

    public void setRemapTable(ColorMap[] map) {
        this.setRemapTable(map, 0);
    }

    public void setRemapTable(ColorMap[] map, int type) {
        this.getAttribute((int)type).clrMap = map;
    }

    public void clearRemapTable() {
        this.clearRemapTable(0);
    }

    public void clearRemapTable(int type) {
        this.getAttribute((int)type).clrMap = null;
    }

    public void setBrushRemapTable(ColorMap[] map) {
        this.setRemapTable(map, 2);
    }

    public void clearBrushRemapTable() {
        this.clearRemapTable(2);
    }

    public void setWrapMode(int mode) {
        this.setWrapMode(mode, new Color(), false);
    }

    public void setWrapMode(int mode, Color clr) {
        this.setWrapMode(mode, clr.Clone(), false);
    }

    public void setWrapMode(int mode, Color clr, boolean bClamp) {
        this.wrapMode = mode;
        if (this.color == null) {
            this.color = clr.Clone();
        } else {
            clr.CloneTo(this.color);
        }
        this.getAttribute((int)0).bClamp = bClamp;
    }

    public void getAdjustedPalette(ColorPalette palette, int type) {
        if (!palette.a()) {
            throw new ArgumentException();
        }
        if (type == 6 || type == 0 || type == 5) {
            throw new ArgumentException();
        }
        ImageAttribute imageAttribute = this.a(type);
        imageAttribute.clrPalette = palette;
        this.a(imageAttribute);
        this.b(imageAttribute);
        this.c(imageAttribute);
    }

    private void a(ImageAttribute imageAttribute) {
        if (!imageAttribute.clrLow.isEmpty() && !imageAttribute.clrHigh.isEmpty()) {
            for (int i2 = 0; i2 < imageAttribute.clrPalette.getEntries().length; ++i2) {
                Color color = imageAttribute.clrPalette.getEntries()[i2];
                if ((color.getB() & 0xFF) < (imageAttribute.clrLow.getB() & 0xFF) || (color.getB() & 0xFF) > (imageAttribute.clrHigh.getB() & 0xFF) || (color.getG() & 0xFF) < (imageAttribute.clrLow.getG() & 0xFF) || (color.getG() & 0xFF) > (imageAttribute.clrHigh.getG() & 0xFF) || (color.getR() & 0xFF) < (imageAttribute.clrLow.getR() & 0xFF) || (color.getR() & 0xFF) > (imageAttribute.clrHigh.getR() & 0xFF)) continue;
                imageAttribute.clrPalette.a(i2, Color.fromArgb(0, color.getR() & 0xFF, color.getG() & 0xFF, color.getB() & 0xFF));
            }
        }
    }

    private void b(ImageAttribute imageAttribute) {
        if (imageAttribute.gamma != 1.0f && imageAttribute.gamma > 0.0f) {
            for (int i2 = 0; i2 < imageAttribute.clrPalette.getEntries().length; ++i2) {
                Color color = imageAttribute.clrPalette.getEntries()[i2];
                imageAttribute.clrPalette.a(i2, Color.fromArgb(color.getA() & 0xFF, (int)(Math.round(255.0 * Math.pow((float)(color.getR() & 0xFF) / 255.0f, imageAttribute.gamma)) & 0xFFL), (int)(Math.round(255.0 * Math.pow((float)(color.getG() & 0xFF) / 255.0f, imageAttribute.gamma)) & 0xFFL), (int)(Math.round(255.0 * Math.pow((float)(color.getB() & 0xFF) / 255.0f, imageAttribute.gamma)) & 0xFFL)));
            }
        }
    }

    private void c(ImageAttribute imageAttribute) {
        if (!imageAttribute.a) {
            return;
        }
        float f2 = imageAttribute.thresh;
        float f3 = Math.abs(f2);
        float f4 = f3 - (float)((int)f3);
        boolean bl2 = false;
        if (f2 < 0.0f) {
            if (f4 == 0.0f) {
                f2 = 0.0f;
                bl2 = true;
            } else {
                f2 = 1.0f - f4;
            }
        }
        if (f2 > 1.0f) {
            f2 = f4 == 1.0f ? 1.0f : f4;
        }
        float f5 = f2 < 1.0f ? f2 * 256.0f : f2 * 255.0f;
        for (int i2 = 0; i2 < imageAttribute.clrPalette.getEntries().length; ++i2) {
            Color color = imageAttribute.clrPalette.getEntries()[i2];
            int n2 = color.getR() & 0xFF;
            int n3 = color.getG() & 0xFF;
            int n4 = color.getB() & 0xFF;
            imageAttribute.clrPalette.a(i2, Color.fromArgb(color.getA() & 0xFF, n2 == 0 && bl2 ? 0 : (n2 == 1 ? 255 : ((float)n2 < f5 ? 0 : 255)), n3 == 0 && bl2 ? 0 : (n3 == 1 ? 255 : ((float)n3 < f5 ? 0 : 255)), n4 == 0 && bl2 ? 0 : (n4 == 1 ? 255 : ((float)n4 < f5 ? 0 : 255))));
        }
    }

    public final class ImageAttribute {
        public ColorMatrix clrMatrix;
        public int clrMatrixFlag;
        public ColorMatrix gMatrix;
        public float thresh;
        boolean a = false;
        public float gamma;
        public int clrChannelFlags;
        public String clrProfileFilename;
        public Color clrLow = new Color();
        public Color clrHigh = new Color();
        public ColorMap[] clrMap;
        public boolean bClamp;
        public ColorPalette clrPalette;
        public boolean bNoOp;

        public ImageAttribute Clone() {
            ImageAttribute imageAttribute = new ImageAttribute();
            imageAttribute.clrMatrix = this.clrMatrix;
            imageAttribute.clrMatrixFlag = this.clrMatrixFlag;
            imageAttribute.gMatrix = this.gMatrix;
            imageAttribute.thresh = this.thresh;
            imageAttribute.a = this.a;
            imageAttribute.gamma = this.gamma;
            imageAttribute.clrChannelFlags = this.clrChannelFlags;
            imageAttribute.clrProfileFilename = this.clrProfileFilename;
            this.clrLow.CloneTo(imageAttribute.clrLow);
            this.clrHigh.CloneTo(imageAttribute.clrHigh);
            imageAttribute.clrMap = this.clrMap;
            imageAttribute.bClamp = this.bClamp;
            imageAttribute.clrPalette = this.clrPalette;
            imageAttribute.bNoOp = this.bNoOp;
            return imageAttribute;
        }
    }
}

