/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing;

import com.aspose.html.drawing.Color;
import com.aspose.html.drawing.z10;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.ComponentModel.InvalidEnumArgumentException;
import com.aspose.html.internal.ms.System.Drawing.Brush;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.CustomLineCap;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.HatchBrush;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.LinearGradientBrush;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.PathGradientBrush;
import com.aspose.html.internal.ms.System.Drawing.Graphics;
import com.aspose.html.internal.ms.System.Drawing.StrokeFactory;
import com.aspose.html.internal.ms.System.Drawing.TextureBrush;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.NullReferenceException;
import com.aspose.html.internal.ms.System.OutOfMemoryException;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.MatrixUtil;
import com.aspose.html.internal.ms.lang.Ref;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public final class Pen
implements ICloneable,
IDisposable,
Stroke,
Cloneable {
    static float[] a = new float[]{1.0f, 1.0f};
    static float[] b = new float[]{3.0f, 1.0f};
    static float[] c = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static float[] d = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private float[] h = new float[0];
    boolean e = true;
    private Brush i;
    private int j;
    private int k;
    private int l;
    private int m;
    CustomLineCap f;
    CustomLineCap g;
    private int n;
    private int o;
    private Matrix p;
    private float q;
    private float r;
    private Ref<float[]> s;
    private float t;
    private boolean u = false;

    public Pen(Brush brush) {
        this(brush, 1.0f);
    }

    public Pen(Color color) {
        this(color.Clone(), 1.0f);
    }

    public Pen(Color color, float width) {
        this(new z10(color.Clone()), width);
    }

    public Pen(Brush brush, float width) {
        if (brush == null) {
            throw new ArgumentNullException("Value of 'brush' cannot be null");
        }
        this.i = Pen.a(brush);
        this.q = width;
        this.j = 0;
        this.l = 0;
        this.k = 0;
        this.m = 0;
        this.o = 0;
        this.n = 0;
        this.t = 10.0f;
        this.p = new Matrix();
    }

    private static float[] a(int n2) {
        switch (n2) {
            case 0: {
                return new float[0];
            }
            case 3: {
                return c;
            }
            case 4: {
                return d;
            }
            case 2: {
                return a;
            }
            case 1: {
                return b;
            }
            case 5: {
                return new float[0];
            }
        }
        throw new RuntimeException();
    }

    private void b(int n2) {
        switch (n2) {
            case 0: {
                this.s = new Ref<float[]>(new float[0]);
                break;
            }
            case 3: {
                this.s = new Ref<float[]>(c);
                break;
            }
            case 4: {
                this.s = new Ref<float[]>(d);
                break;
            }
            case 2: {
                this.s = new Ref<float[]>(a);
                break;
            }
            case 1: {
                this.s = new Ref<float[]>(b);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.j = n2;
    }

    public int getAlignment() {
        return this.o;
    }

    public void setAlignment(int value) {
        this.d();
        if (value < 0 || value > 4) {
            throw new InvalidEnumArgumentException("alignment value");
        }
        if (this.u) {
            throw new ArgumentException("Pen is already disposed");
        }
        this.o = value;
    }

    public Brush getBrush() {
        return (Brush)this.i.deepClone();
    }

    public void setBrush(Brush value) {
        this.d();
        if (value == null) {
            throw new ArgumentNullException("brush");
        }
        this.i = value;
    }

    private static Brush a(Brush brush) {
        if (brush instanceof z10) {
            return ((z10)brush).m1992();
        }
        if (brush instanceof HatchBrush) {
            return (Brush)((HatchBrush)brush).deepClone();
        }
        return (Brush)brush.deepClone();
    }

    private static Color b(Brush brush) {
        if (brush instanceof z10) {
            return ((z10)brush).getColor();
        }
        if (brush instanceof HatchBrush) {
            return ((HatchBrush)brush).getForegroundColor();
        }
        return Color.Empty.Clone();
    }

    public Color getColor() {
        return Pen.b(this.i);
    }

    public void setColor(Color value) {
        this.d();
        this.i = new z10(value.Clone());
    }

    public float[] getCompoundArray() {
        return this.h;
    }

    public void setCompoundArray(float[] value) {
        if (value == null) {
            throw new NullReferenceException();
        }
        if (value.length == 0 || value.length % 2 == 1) {
            throw new ArgumentException();
        }
        float f2 = 0.0f;
        for (float f3 : value) {
            if (f3 < f2 || f3 > 1.0f) {
                throw new ArgumentException();
            }
            f2 = f3;
        }
        this.h = new float[value.length];
        Array.copy(Array.boxing(value), 0, Array.boxing(this.h), 0, value.length);
    }

    private CustomLineCap b() {
        return this.f != null ? (CustomLineCap)this.f.deepClone() : null;
    }

    private CustomLineCap c() {
        return this.g != null ? (CustomLineCap)this.g.deepClone() : null;
    }

    public CustomLineCap getCustomEndCap() {
        if (this.g == null) {
            throw new ArgumentException("customEndCap member is null");
        }
        return this.c();
    }

    public void setCustomEndCap(CustomLineCap value) {
        if (value == null) {
            throw new ArgumentException("Parameter 'value' cannot be null");
        }
        if (!this.e) {
            throw new ArgumentException("Pen object is immutable");
        }
        this.setEndCap(255);
        this.g = (CustomLineCap)value.deepClone();
    }

    public CustomLineCap getCustomStartCap() {
        if (this.f == null) {
            throw new ArgumentException("customStartCap member is null");
        }
        return this.b();
    }

    public void setCustomStartCap(CustomLineCap value) {
        if (value == null) {
            throw new ArgumentException("Parameter 'value' cannot be null");
        }
        if (!this.e) {
            throw new ArgumentException("Pen object is immutable");
        }
        this.setStartCap(255);
        this.f = (CustomLineCap)value.deepClone();
    }

    public CustomLineCap[] getCustomCaps() {
        return new CustomLineCap[]{this.b(), this.c()};
    }

    public int getDashCap() {
        return this.k;
    }

    public void setDashCap(int value) {
        if (value != 0 && value != 2 && value != 3) {
            throw new InvalidEnumArgumentException("DashCap value");
        }
        this.d();
        this.k = value;
    }

    public float getDashOffset() {
        return this.r;
    }

    public void setDashOffset(float value) {
        this.d();
        this.r = value;
    }

    public float[] getDashPattern() {
        if (this.s == null) {
            throw new OutOfMemoryException("dashPattern");
        }
        return (float[])((float[])this.s.value).clone();
    }

    public void setDashPattern(float[] value) {
        this.d();
        if (value == null || value.length == 0) {
            throw new ArgumentException("Argument 'value' is invalid");
        }
        for (float f2 : value) {
            if (!(f2 <= 0.0f)) continue;
            throw new ArgumentException("Parameter is invalid");
        }
        this.j = 5;
        this.s = new Ref<float[]>(value);
    }

    public int getDashStyle() {
        return this.j;
    }

    public void setDashStyle(int value) {
        if (value < 0 || value > 5) {
            throw new InvalidEnumArgumentException("DashStyle value");
        }
        this.d();
        this.b(value);
        if (value == 5 && (this.s == null || this.s.value == null || ((float[])this.s.value).length == 0)) {
            this.s = new Ref<float[]>(new float[]{1.0f});
        }
    }

    public int getStartCap() {
        return this.l;
    }

    public void setStartCap(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 240: 
            case 255: {
                break;
            }
            default: {
                throw new InvalidEnumArgumentException("StartCap value");
            }
        }
        this.d();
        this.f = null;
        this.l = value;
    }

    public int getEndCap() {
        return this.m;
    }

    public void setEndCap(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 240: 
            case 255: {
                break;
            }
            default: {
                throw new InvalidEnumArgumentException("EndCap value");
            }
        }
        this.d();
        this.g = null;
        this.m = value;
    }

    public int getLineJoin() {
        return this.n;
    }

    public void setLineJoin(int value) {
        if (value < 0 || value > 3) {
            throw new InvalidEnumArgumentException("LineJoin");
        }
        this.d();
        this.n = value;
    }

    public float getMiterLimit() {
        return this.t;
    }

    public void setMiterLimit(float value) {
        this.d();
        this.t = value < 1.0f ? 1.0f : value;
    }

    public int getPenType() {
        if (this.getBrush() instanceof TextureBrush) {
            return 2;
        }
        if (this.getBrush() instanceof HatchBrush) {
            return 1;
        }
        if (this.getBrush() instanceof LinearGradientBrush) {
            return 4;
        }
        if (this.getBrush() instanceof PathGradientBrush) {
            return 3;
        }
        return 0;
    }

    public Matrix getTransform() {
        return this.p.deepClone();
    }

    public void setTransform(Matrix value) {
        this.d();
        if (value == null) {
            throw new ArgumentNullException("Value of 'value' cannot be null");
        }
        if (!value.isInvertible()) {
            throw new ArgumentException("Matrix 'value' must be invertible");
        }
        value.copyTo(this.p);
    }

    public float getWidth() {
        return this.q;
    }

    public float getEffectiveWidth() {
        return this.q < 0.0f ? 0.0f : this.q;
    }

    public void setWidth(float value) {
        this.d();
        this.q = value;
    }

    @Override
    public Object deepClone() {
        Pen pen = (Pen)this.memberwiseClone();
        if (pen.p != null) {
            pen.p = pen.p.deepClone();
        }
        if (pen.s != null && pen.s.value != null) {
            pen.s.value = ((float[])pen.s.value).clone();
        }
        pen.e = true;
        return pen;
    }

    public Pen cloneWithoutCustomCap() {
        Pen pen = (Pen)this.deepClone();
        if (pen.getEndCap() == 255 || pen.g != null) {
            pen.setEndCap(0);
            pen.g = null;
        }
        if (pen.getStartCap() == 255 || pen.f != null) {
            pen.setStartCap(0);
            pen.f = null;
        }
        return pen;
    }

    @Override
    public void dispose() {
        this.a(true);
    }

    private void a(boolean bl2) {
        if (!this.e && bl2) {
            throw new ArgumentException("You may not change this Pen because it does not belong to you.");
        }
        this.u = true;
        if (!bl2) {
            this.e = true;
        }
    }

    public void multiplyTransform(Matrix matrix) {
        this.multiplyTransform(matrix, 0);
    }

    public void multiplyTransform(Matrix matrix, int order) {
        if (order != 0) {
            order = 1;
        }
        if (matrix == null) {
            throw new ArgumentNullException("Value of 'matrix' cannot be null");
        }
        if (!matrix.isInvertible()) {
            throw new ArgumentException("Parameter is not valid");
        }
        this.p.multiply(matrix, order);
    }

    public void resetTransform() {
        this.p.reset();
    }

    public void rotateTransform(float angle) {
        this.p.rotate(angle);
    }

    public void rotateTransform(float angle, int order) {
        this.p.rotate(angle, order);
    }

    public void scaleTransform(float sx, float sy) {
        this.p.scale(sx, sy);
    }

    public void scaleTransform(float sx, float sy, int order) {
        this.p.scale(sx, sy, order);
    }

    public void translateTransform(float dx2, float dy2) {
        this.p.translate(dx2, dy2);
    }

    public void translateTransform(float dx2, float dy2, int order) {
        this.p.translate(dx2, dy2, order);
    }

    public void setLineCap(int startCap, int endCap, int dashCap) {
        if (!this.e) {
            throw new ArgumentException("Pen is not modifiable");
        }
        this.l = startCap;
        this.m = endCap;
        if (dashCap == 2 || dashCap == 3) {
            this.setDashCap(dashCap);
        } else {
            this.setDashCap(0);
        }
    }

    private void d() {
        if (!this.e) {
            throw new ArgumentException("You may not change this Pen because it does not belong to you.");
        }
    }

    double a(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.p.getNativeObject();
        double d2 = affineTransform2.getScaleX();
        double d3 = affineTransform2.getShearY();
        double d4 = affineTransform2.getShearX();
        double d5 = affineTransform2.getScaleY();
        double d6 = affineTransform.getScaleX();
        double d7 = affineTransform.getShearY();
        double d8 = affineTransform.getShearX();
        double d9 = affineTransform.getScaleY();
        double d10 = d2 * d5;
        double d11 = d3 * d4;
        double d12 = d6 * d9;
        double d13 = d7 * d8;
        double d14 = d12 - d13;
        return Math.abs((double)(this.getWidth() * this.getWidth()) * (d10 * d14 - d11 * d14));
    }

    boolean a() {
        return this.p.isIdentity();
    }

    Stroke a(AffineTransform affineTransform, int n2) {
        return this.a(null, affineTransform, n2, false, false, false, null);
    }

    Stroke a(AffineTransform affineTransform, int n2, Graphics graphics) {
        return this.a(null, affineTransform, n2, false, false, true, graphics);
    }

    Stroke a(AffineTransform affineTransform, AffineTransform affineTransform2, int n2, boolean bl2) {
        return this.a(affineTransform, affineTransform2, n2, bl2, false, true, null);
    }

    Stroke b(AffineTransform affineTransform, AffineTransform affineTransform2, int n2, boolean bl2) {
        return this.a(affineTransform, affineTransform2, n2, bl2, false, false, null);
    }

    Stroke a(AffineTransform affineTransform, AffineTransform affineTransform2, int n2, boolean bl2, boolean bl3, boolean bl4, Graphics graphics) {
        Object object = null;
        int n3 = this.getDashCap();
        float f2 = this.getDashOffset();
        switch (this.getDashStyle()) {
            case 5: {
                if (this.s == null) break;
                object = ((float[])this.s.value).length == 1 ? null : (((float[])this.s.value).length % 2 != 0 ? new float[((float[])this.s.value).length + 1] : new float[((float[])this.s.value).length]);
                float f3 = (double)this.getWidth() < 1.0 ? 1.0f : this.getWidth();
                f2 *= f3;
                if (object == null) break;
                int n4 = 0;
                int n5 = 0;
                while (n4 < ((float[])this.s.value).length) {
                    object[n5] = this.getDashCap() == 2 ? Math.max(1.0f, ((float[])this.s.value)[n4]) * f3 : ((float[])this.s.value)[n4] * f3;
                    ++n4;
                    ++n5;
                }
                break;
            }
            case 1: {
                object = new float[b.length];
                for (int i2 = 0; i2 < ((float[])object).length; ++i2) {
                    object[i2] = b[i2] * this.getEffectiveWidth();
                }
                break;
            }
            case 3: {
                object = new float[c.length];
                for (int i3 = 0; i3 < ((float[])object).length; ++i3) {
                    object[i3] = c[i3] * this.getEffectiveWidth();
                }
                break;
            }
            case 4: {
                object = new float[d.length];
                for (int i4 = 0; i4 < ((float[])object).length; ++i4) {
                    object[i4] = d[i4] * this.getEffectiveWidth();
                }
                break;
            }
            case 2: {
                object = new float[a.length];
                for (int i5 = 0; i5 < ((float[])object).length; ++i5) {
                    object[i5] = a[i5] * this.getEffectiveWidth();
                }
                break;
            }
            case 0: {
                n3 = 0;
            }
        }
        int n6 = this.getLineJoin();
        AffineTransform affineTransform3 = this.p.getNativeObject();
        if (bl2) {
            affineTransform3 = this.getDotNetScalingByMatrix(this.p).getNativeObject();
        }
        float f4 = this.getWidth() <= 0.0f ? 1.0f : this.getWidth();
        return bl3 ? StrokeFactory.a(f4, this.getStartCap(), this.getEndCap(), n6, this.getMiterLimit(), object, f2, affineTransform3, affineTransform2, n2) : StrokeFactory.a(f4, this.getStartCap(), this.getEndCap(), n6, this.getMiterLimit(), object, f2, n3, affineTransform3, affineTransform2, n2, graphics);
    }

    public Matrix getDotNetScalingByMatrix(Matrix t2) {
        float[] fArray = MatrixUtil.getOriginalScalingCoeff(t2);
        double d2 = fArray[0];
        double d3 = fArray[1];
        double d4 = Math.abs(d2);
        double d5 = Math.abs(d3);
        if (d4 < 1.0 && d4 > 0.0) {
            d2 = 1.0 / ((double)this.getWidth() * d2);
        }
        if (d5 < 1.0 && d5 > 0.0) {
            d3 = 1.0 / ((double)this.getWidth() * d3);
        }
        float[] fArray2 = t2.getElements();
        return new Matrix((float)d3, fArray2[1], fArray2[2], (float)d2, fArray2[4], fArray2[5]);
    }

    @Override
    public Shape createStrokedShape(Shape arg_0) {
        return this.a(null, 0).createStrokedShape(arg_0);
    }

    public Shape createWidenShape(Shape arg_0) {
        return this.a(null, null, 0, false, true, false, null).createStrokedShape(arg_0);
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

