/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing;

import com.aspose.html.internal.ms.System.ComponentModel.BrowsableAttribute;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.Size;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.lang.Struct;

@SerializableAttribute
public class Point
extends Struct<Point> {
    private java.awt.Point b = new java.awt.Point(0, 0);
    public static Point Empty = new Point();

    public Point() {
    }

    private Point(java.awt.Point point) {
        this.b = point;
    }

    public static Point ceiling(PointF value) {
        int n2 = (int)Math.ceil(value.getX());
        int n3 = (int)Math.ceil(value.getY());
        return new Point(n2, n3);
    }

    public static Point round(PointF value) {
        int n2 = (int)msMath.round(value.getX());
        int n3 = (int)msMath.round(value.getY());
        return new Point(n2, n3);
    }

    public static Point truncate(PointF value) {
        int n2 = (int)value.getX();
        int n3 = (int)value.getY();
        return new Point(n2, n3);
    }

    public static Point op_Addition(Point pt, Size sz) {
        return new Point(pt.getX() + sz.getWidth(), pt.getY() + sz.getHeight());
    }

    public static boolean op_Equality(Point left, Point right) {
        return left.getX() == right.getX() && left.getY() == right.getY();
    }

    public static boolean op_Inequality(Point left, Point right) {
        return left.getX() != right.getX() || left.getY() != right.getY();
    }

    public static Point op_Subtraction(Point pt, Size sz) {
        return new Point(pt.getX() - sz.getWidth(), pt.getY() - sz.getHeight());
    }

    public static Size to_Size(Point p2) {
        return new Size(p2.getX(), p2.getY());
    }

    public static PointF to_PointF(Point p2) {
        return new PointF(p2.getX(), p2.getY());
    }

    public static PointF toPointF(java.awt.Point p2) {
        return new PointF(p2.x, p2.y);
    }

    public Point(int dw2) {
        this.b = new java.awt.Point(dw2 >> 16, dw2 & 0xFFFF);
    }

    public Point(Size sz) {
        this.b = new java.awt.Point(sz.getWidth(), sz.getHeight());
    }

    public Point(int x2, int y2) {
        this.b = new java.awt.Point(x2, y2);
    }

    @BrowsableAttribute(browsable=false)
    public boolean isEmpty() {
        return this.getX() == 0 && this.getY() == 0;
    }

    public int getX() {
        return this.b.x;
    }

    public void setX(int value) {
        this.b.x = value;
    }

    public int getY() {
        return this.b.y;
    }

    public void setY(int value) {
        this.b.y = value;
    }

    public int hashCode() {
        return this.getX() ^ this.getY();
    }

    public void offset(int dx2, int dy2) {
        this.b.x += dx2;
        this.b.y += dy2;
    }

    public String toString() {
        return StringExtensions.format("{{X={0},Y={1}}}", Int32Extensions.toString(this.getX(), CultureInfo.getInvariantCulture()), Int32Extensions.toString(this.getY(), CultureInfo.getInvariantCulture()));
    }

    public static Point add(Point pt, Size sz) {
        return new Point(pt.getX() + sz.getWidth(), pt.getY() + sz.getHeight());
    }

    public void offset(Point p2) {
        this.offset(p2.getX(), p2.getY());
    }

    public static Point subtract(Point pt, Size sz) {
        return new Point(pt.getX() - sz.getWidth(), pt.getY() - sz.getHeight());
    }

    @Override
    public void CloneTo(Point that) {
        that.setX(this.getX());
        that.setY(this.getY());
    }

    @Override
    public Point Clone() {
        Point point = new Point();
        this.CloneTo(point);
        return point;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean a(Point point) {
        return point.getX() == this.getX() && point.getY() == this.getY();
    }

    public boolean equals(Object obj) {
        assert (obj != null);
        if (ObjectExtensions.referenceEquals(null, obj)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, obj)) {
            return true;
        }
        if (!(obj instanceof Point)) {
            return false;
        }
        return this.a((Point)obj);
    }

    public static boolean equals(Point obj1, Point obj2) {
        return obj1.equals(obj2);
    }

    public static Point fromJava(java.awt.Point point) {
        if (point == null) {
            return new Point(0, 0);
        }
        return new Point(point);
    }

    public static java.awt.Point toJava(Point point) {
        if (point == null) {
            return null;
        }
        return point.b;
    }

    public PointF toPointF() {
        return PointF.fromPoint(this);
    }

    public static Point fromPointF(PointF p2) {
        return p2.toPoint();
    }

    public static Point roundedFromPointF(PointF p2) {
        return p2.toPointRounded();
    }

    public static Point[] fromPointFs(PointF[] points) {
        if (points == null) {
            return null;
        }
        if (points.length == 0) {
            return new Point[0];
        }
        Point[] pointArray = new Point[points.length];
        for (int i2 = 0; i2 < points.length; ++i2) {
            pointArray[i2] = points[i2].toPoint();
        }
        return pointArray;
    }
}

