/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Globalization;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Globalization.msCalendar;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.core.mscorlib.b.a;

@SerializableAttribute
public class HijriCalendar
extends msCalendar {
    static final DateTime a = DateTime.MaxValue.Clone();
    static final DateTime b = new DateTime(622, 7, 18);
    public static final int HijriEra = 1;
    static final int[] c = new int[]{0, 30, 59, 89, 118, 148, 177, 207, 236, 266, 295, 325, 355};
    private int d = 0;

    @Override
    public int getAlgorithmType() {
        return 2;
    }

    @Override
    public int[] getEras() {
        return new int[]{1};
    }

    public int get_HijriAdjustment() {
        return this.d;
    }

    public void set_HijriAdjustment(int value) {
        if (value < -2 || value > 2) {
            throw new ArgumentOutOfRangeException("HijriAdjustment");
        }
        super.e();
        this.d = value;
    }

    @Override
    public DateTime getMaxSupportedDateTime() {
        return a;
    }

    @Override
    public DateTime getMinSupportedDateTime() {
        return b;
    }

    @Override
    public int getTwoDigitYearMax() {
        if (this.f == -1) {
            this.f = 1451;
        }
        return this.f;
    }

    @Override
    public void setTwoDigitYearMax(int value) {
        super.e();
        if (value < 99 || value > 9666) {
            throw new ArgumentOutOfRangeException("value");
        }
        this.f = value;
    }

    @Override
    public DateTime addMonths(DateTime time, int months) {
        if (months < -120000 || months > 120000) {
            throw new ArgumentOutOfRangeException("months");
        }
        int n2 = this.a(time.getTicks(), 0);
        int n3 = this.a(time.getTicks(), 2);
        int n4 = this.a(time.getTicks(), 3);
        int n5 = n3 - 1 + months;
        if (n5 < 0) {
            n3 = 12 + (n5 + 1) % 12;
            n2 += (n5 - 11) / 12;
        } else {
            n3 = n5 % 12 + 1;
            n2 += n5 / 12;
        }
        int n6 = this.getDaysInMonth(n2, n3);
        if (n4 > n6) {
            n4 = n6;
        }
        long l2 = this.b(n2, n3, n4) * 864000000000L + time.getTicks() % 864000000000L;
        com.aspose.html.internal.ms.core.mscorlib.b.a.a(l2, this.getMinSupportedDateTime(), this.getMaxSupportedDateTime());
        return new DateTime(l2);
    }

    @Override
    public DateTime addYears(DateTime time, int years) {
        return this.addMonths(time, years * 12);
    }

    @Override
    public int getDayOfMonth(DateTime time) {
        return this.a(time.getTicks(), 3);
    }

    @Override
    public int getDayOfWeek(DateTime time) {
        return (int)(time.getTicks() / 864000000000L + 1L) % 7;
    }

    @Override
    public int getDayOfYear(DateTime time) {
        return this.a(time.getTicks(), 1);
    }

    @Override
    public int getDaysInMonth(int year, int month, int era) {
        HijriCalendar.a(year, month, era);
        if (month == 12) {
            if (!this.isLeapYear(year, 0)) {
                return 29;
            }
            return 30;
        }
        if (month % 2 != 1) {
            return 29;
        }
        return 30;
    }

    @Override
    public int getDaysInYear(int year, int era) {
        HijriCalendar.b(year, era);
        if (!this.isLeapYear(year, 0)) {
            return 354;
        }
        return 355;
    }

    @Override
    public int getEra(DateTime time) {
        HijriCalendar.a(time.getTicks());
        return 1;
    }

    @Override
    public int getLeapMonth(int year, int era) {
        HijriCalendar.b(year, era);
        return 0;
    }

    @Override
    public int getMonth(DateTime time) {
        return this.a(time.getTicks(), 2);
    }

    @Override
    public int getMonthsInYear(int year, int era) {
        HijriCalendar.b(year, era);
        return 12;
    }

    @Override
    public int getYear(DateTime time) {
        return this.a(time.getTicks(), 0);
    }

    @Override
    public boolean isLeapDay(int year, int month, int day, int era) {
        int n2 = this.getDaysInMonth(year, month, era);
        if (day < 1 || day > n2) {
            throw new ArgumentOutOfRangeException("day");
        }
        return this.isLeapYear(year, era) && month == 12 && day == 30;
    }

    @Override
    public boolean isLeapMonth(int year, int month, int era) {
        HijriCalendar.a(year, month, era);
        return false;
    }

    @Override
    public boolean isLeapYear(int year, int era) {
        HijriCalendar.b(year, era);
        return (year * 11 + 14) % 30 < 11;
    }

    @Override
    public DateTime toDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era) {
        int n2 = this.getDaysInMonth(year, month, era);
        if (day < 1 || day > n2) {
            throw new ArgumentOutOfRangeException("day");
        }
        long l2 = this.b(year, month, day);
        if (l2 < 0L) {
            throw new ArgumentOutOfRangeException(null);
        }
        return new DateTime(l2 * 864000000000L + msCalendar.b(hour, minute, second, millisecond));
    }

    @Override
    public int toFourDigitYear(int year) {
        if (year < 100) {
            return super.toFourDigitYear(year);
        }
        if (year > 9666) {
            throw new ArgumentOutOfRangeException("year");
        }
        return year;
    }

    @Override
    public int get_current_era_internal() {
        return 1;
    }

    @Override
    public Object deepClone() {
        HijriCalendar hijriCalendar = new HijriCalendar();
        hijriCalendar.set_HijriAdjustment(this.get_HijriAdjustment());
        hijriCalendar.setTwoDigitYearMax(this.getTwoDigitYearMax());
        return hijriCalendar;
    }

    private static void a(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new ArgumentOutOfRangeException("era");
        }
    }

    private static void a(long l2) {
        if (l2 < b.getTicks() || l2 > a.getTicks()) {
            throw new ArgumentOutOfRangeException("time");
        }
    }

    private static void a(int n2, int n3, int n4) {
        HijriCalendar.b(n2, n4);
        if (n2 == 9666 && n3 > 4) {
            throw new ArgumentOutOfRangeException("month");
        }
        if (n3 < 1 || n3 > 12) {
            throw new ArgumentOutOfRangeException("month");
        }
    }

    private static void b(int n2, int n3) {
        HijriCalendar.a(n3);
        if (n2 < 1 || n2 > 9666) {
            throw new ArgumentOutOfRangeException("year");
        }
    }

    private long b(int n2) {
        int n3 = (n2 - 1) / 30 * 30;
        long l2 = (long)n3 * 10631L / 30L + 227013L;
        for (int i2 = n2 - n3 - 1; i2 > 0; --i2) {
            l2 += (long)(354 + (this.isLeapYear(i2, 0) ? 1 : 0));
        }
        return l2;
    }

    private long b(int n2, int n3, int n4) {
        return this.b(n2) + (long)c[n3 - 1] + (long)n4 - 1L - (long)this.get_HijriAdjustment();
    }

    private int a(long l2, int n2) {
        HijriCalendar.a(l2);
        long l3 = l2 / 864000000000L + 1L;
        int n3 = (int)(((l3 += (long)this.get_HijriAdjustment()) - 227013L) * 30L / 10631L) + 1;
        long l4 = this.b(n3);
        long l5 = this.getDaysInYear(n3, 0);
        if (l3 < l4) {
            l4 -= l5;
            --n3;
        } else if (l3 == l4) {
            l4 -= (long)this.getDaysInYear(--n3, 0);
        } else if (l3 > l4 + l5) {
            l4 += l5;
            ++n3;
        }
        if (n2 == 0) {
            return n3;
        }
        int n4 = 1;
        l3 -= l4;
        if (n2 == 1) {
            return (int)l3;
        }
        while (true) {
            if (n4 > 12 || l3 <= (long)c[n4 - 1]) {
                --n4;
                if (n2 == 2) {
                    return n4;
                }
                int n5 = (int)l3 - c[n4 - 1];
                if (n2 != 3) {
                    throw new InvalidOperationException("InvalidOperation_DateTimeParsing");
                }
                return n5;
            }
            ++n4;
        }
    }
}

