/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.IO;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.IO.Directory;
import com.aspose.html.internal.ms.System.IO.DirectoryNotFoundException;
import com.aspose.html.internal.ms.System.IO.FileInfo;
import com.aspose.html.internal.ms.System.IO.FileSystemInfo;
import com.aspose.html.internal.ms.System.IO.IOException;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import java.io.File;

@SerializableAttribute
public final class DirectoryInfo
extends FileSystemInfo {
    private String b;
    private String c;

    public DirectoryInfo(String path) {
        this(path, false);
    }

    DirectoryInfo(String path, boolean simpleOriginalPath) {
        this.checkPath(path);
        this.FullPath = Path.getFullPath(path);
        this.OriginalPath = simpleOriginalPath ? Path.getFileName(path) : path;
        this.a();
    }

    private void a() {
        int n2;
        int n3 = this.FullPath.length() - 1;
        if (n3 > 1 && this.FullPath.charAt(n3) == Path.DirectorySeparatorChar) {
            --n3;
        }
        if ((n2 = StringExtensions.lastIndexOf(this.FullPath, Path.DirectorySeparatorChar, n3)) == -1 || n2 == 0 && n3 == 0) {
            this.b = this.FullPath;
            this.c = null;
        } else {
            this.b = StringExtensions.substring(this.FullPath, n2 + 1, n3 - n2);
            this.c = n2 == 0 && !Environment.IsRunningOnWindows ? StringExtensions.newString(Character.valueOf(Path.DirectorySeparatorChar)) : StringExtensions.substring(this.FullPath, 0, n2);
            if (Environment.IsRunningOnWindows && this.c.length() == 2 && this.c.charAt(1) == ':' && Character.isLetter(this.c.charAt(0))) {
                this.c = StringExtensions.plusEqOperator(this.c, Path.DirectorySeparatorChar);
            }
        }
    }

    @Override
    public boolean exists() {
        return new File(this.FullPath).exists();
    }

    @Override
    public String getName() {
        return this.b;
    }

    public DirectoryInfo getParent() {
        if (this.c == null || this.c.length() == 0) {
            return null;
        }
        return new DirectoryInfo(this.c);
    }

    public DirectoryInfo getRoot() {
        String string = Path.getPathRoot(this.FullPath);
        if (string == null) {
            return null;
        }
        return new DirectoryInfo(string);
    }

    public void create() {
        Directory.createDirectory(this.FullPath);
    }

    public DirectoryInfo createSubdirectory(String path) {
        this.checkPath(path);
        path = Path.combine(this.FullPath, path);
        Directory.createDirectory(path);
        return new DirectoryInfo(path);
    }

    public FileInfo[] getFiles() {
        return this.getFiles("*");
    }

    public FileInfo[] getFiles(String searchPattern) {
        if (searchPattern == null) {
            throw new ArgumentNullException("searchPattern");
        }
        if (!this.exists()) {
            throw new DirectoryNotFoundException(this.FullPath);
        }
        String[] stringArray = Directory.getFiles(this.FullPath, searchPattern);
        FileInfo[] fileInfoArray = new FileInfo[stringArray.length];
        int n2 = 0;
        for (String string : stringArray) {
            fileInfoArray[n2++] = new FileInfo(string);
        }
        return fileInfoArray;
    }

    public DirectoryInfo[] getDirectories() {
        return this.getDirectories("*");
    }

    public DirectoryInfo[] getDirectories(String searchPattern) {
        if (searchPattern == null) {
            throw new ArgumentNullException("searchPattern");
        }
        if (!this.exists()) {
            throw new DirectoryNotFoundException(this.FullPath);
        }
        String[] stringArray = Directory.getDirectories(this.FullPath, searchPattern);
        DirectoryInfo[] directoryInfoArray = new DirectoryInfo[stringArray.length];
        int n2 = 0;
        for (String string : stringArray) {
            directoryInfoArray[n2++] = new DirectoryInfo(string);
        }
        return directoryInfoArray;
    }

    public FileSystemInfo[] getFileSystemInfos() {
        return this.getFileSystemInfos("*");
    }

    public FileSystemInfo[] getFileSystemInfos(String searchPattern) {
        return this.a(searchPattern, 0);
    }

    private FileSystemInfo[] a(String string, int n2) {
        if (string == null) {
            throw new ArgumentNullException("searchPattern");
        }
        if (n2 != 0 && n2 != 1) {
            throw new ArgumentOutOfRangeException("searchOption", "Must be TopDirectoryOnly or AllDirectories");
        }
        if (!Directory.exists(this.FullPath)) {
            throw new IOException("Invalid directory");
        }
        List<FileSystemInfo> list = new List<FileSystemInfo>();
        this.a(string, n2, list);
        return list.toArray((FileSystemInfo[])new FileSystemInfo[0]);
    }

    private void a(String string, int n2, List<FileSystemInfo> list) {
        String[] stringArray = Directory.getDirectories(this.FullPath, string);
        String[] stringArray2 = Directory.getFiles(this.FullPath, string);
        for (String string2 : stringArray) {
            list.addItem(new DirectoryInfo(string2));
        }
        for (String string2 : stringArray2) {
            list.addItem(new FileInfo(string2));
        }
        if (n2 == 1) {
            for (String string2 : stringArray) {
                DirectoryInfo directoryInfo = new DirectoryInfo(string2);
                directoryInfo.a(string, n2, list);
            }
        }
    }

    @Override
    public void delete() {
        this.delete(false);
    }

    public void delete(boolean recursive) {
        Directory.delete(this.FullPath, recursive);
    }

    public void moveTo(String destDirName) {
        if (destDirName == null) {
            throw new ArgumentNullException("destDirName");
        }
        if (StringExtensions.trim(destDirName).length() == 0) {
            throw new ArgumentException("An empty file name is not valid.");
        }
        Directory.move(this.FullPath, Path.getFullPath(destDirName));
    }

    public String toString() {
        return this.OriginalPath;
    }

    public DirectoryInfo[] getDirectories(String searchPattern, int searchOption) {
        switch (searchOption) {
            case 0: {
                return this.getDirectories(searchPattern);
            }
            case 1: {
                String[] stringArray = Directory.getDirectories(this.FullPath, searchPattern, 1);
                DirectoryInfo[] directoryInfoArray = new DirectoryInfo[stringArray.length];
                int n2 = 0;
                for (String string : stringArray) {
                    directoryInfoArray[n2++] = new DirectoryInfo(string);
                }
                return directoryInfoArray;
            }
        }
        String string = StringExtensions.format("Invalid enum value '{0}' for '{1}'.", searchOption, "SearchOption");
        throw new ArgumentOutOfRangeException("searchOption", string);
    }

    public FileInfo[] getFiles(String searchPattern, int searchOption) {
        switch (searchOption) {
            case 0: {
                return this.getFiles(searchPattern);
            }
            case 1: {
                String[] stringArray = Directory.getFiles(this.FullPath, searchPattern, 1);
                FileInfo[] fileInfoArray = new FileInfo[stringArray.length];
                int n2 = 0;
                for (String string : stringArray) {
                    fileInfoArray[n2++] = new FileInfo(string);
                }
                return fileInfoArray;
            }
        }
        String string = StringExtensions.format("Invalid enum value '{0}' for '{1}'.", searchOption, "SearchOption");
        throw new ArgumentOutOfRangeException("searchOption", string);
    }
}

