/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.IO;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.IO.Directory;
import com.aspose.html.internal.ms.System.IO.DirectoryNotFoundException;
import com.aspose.html.internal.ms.System.IO.FileNotFoundException;
import com.aspose.html.internal.ms.System.IO.FileStream;
import com.aspose.html.internal.ms.System.IO.IOException;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.IO.StreamReader;
import com.aspose.html.internal.ms.System.IO.StreamWriter;
import com.aspose.html.internal.ms.System.IO.TextWriter;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class File {
    public static void appendAllText(String path, String contents) {
        StreamWriter streamWriter = new StreamWriter(path, true);
        try {
            ((TextWriter)streamWriter).write(contents);
        }
        finally {
            if (streamWriter != null) {
                streamWriter.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendAllText(String path, String contents, Encoding encoding) {
        StreamWriter streamWriter = new StreamWriter(path, true, encoding);
        try {
            ((TextWriter)streamWriter).write(contents);
        }
        finally {
            if (streamWriter != null) {
                streamWriter.dispose();
            }
        }
    }

    public static StreamWriter appendText(String path) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        return new StreamWriter(path, true);
    }

    public static void copy(String sourceFileName, String destFileName) {
        File.copy(sourceFileName, destFileName, false);
    }

    public static void copy(String sourceFileName, String destFileName, boolean overwrite) {
        Object object;
        Object object2;
        if (sourceFileName == null) {
            throw new ArgumentNullException("sourceFileName");
        }
        if (destFileName == null) {
            throw new ArgumentNullException("destFileName");
        }
        if (sourceFileName.length() == 0) {
            throw new ArgumentException("An empty file name is not valid.", "sourceFileName");
        }
        if (StringExtensions.trim(sourceFileName).length() == 0) {
            throw new ArgumentException("The file name is not valid.");
        }
        if (destFileName.length() == 0) {
            throw new ArgumentException("An empty file name is not valid.", "destFileName");
        }
        if (StringExtensions.trim(destFileName).length() == 0) {
            throw new ArgumentException("The file name is not valid.");
        }
        java.io.File file = new java.io.File(sourceFileName);
        java.io.File file2 = new java.io.File(destFileName);
        if (!file.exists()) {
            throw new FileNotFoundException("FileCopy: no such source file: " + sourceFileName, sourceFileName);
        }
        if (!file.isFile()) {
            throw new IOException("FileCopy: can't copy directory: " + sourceFileName);
        }
        if (!file.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + sourceFileName);
        }
        if (sourceFileName.equals(destFileName)) {
            throw new IOException("Can't copy file to itsalf : " + sourceFileName);
        }
        if (file2.isDirectory()) {
            file2 = new java.io.File(file2, file.getName());
        }
        if (file2.exists()) {
            if (!overwrite) {
                throw new IOException("Destination file alresdy exist :" + file2.getAbsolutePath());
            }
        } else {
            object2 = file2.getParent();
            if (object2 == null) {
                object2 = System.getProperty("user.dir");
            }
            if (!((java.io.File)(object = new java.io.File((String)object2))).exists()) {
                throw new IOException("FileCopy: destination directory doesn't exist: " + (String)object2);
            }
            if (((java.io.File)object).isFile()) {
                throw new IOException("FileCopy: destination is not a directory: " + (String)object2);
            }
            if (!((java.io.File)object).canWrite()) {
                throw new IOException("FileCopy: destination directory is unwriteable: " + (String)object2);
            }
        }
        object2 = null;
        object = null;
        try {
            int n2;
            object2 = new FileInputStream(file);
            object = new FileOutputStream(file2);
            byte[] byArray = new byte[4096];
            while ((n2 = ((FileInputStream)object2).read(byArray)) != -1) {
                ((FileOutputStream)object).write(byArray, 0, n2);
            }
        }
        catch (java.io.FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException(fileNotFoundException.getMessage());
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        finally {
            if (object2 != null) {
                try {
                    ((FileInputStream)object2).close();
                }
                catch (java.io.IOException iOException) {}
            }
            if (object != null) {
                try {
                    ((FileOutputStream)object).close();
                }
                catch (java.io.IOException iOException) {}
            }
        }
    }

    public static FileStream create(String path) {
        return new FileStream(path, 2, 3);
    }

    public static StreamWriter createText(String path) {
        return new StreamWriter(path, false);
    }

    public static void delete(String path) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        if (StringExtensions.trim(path).length() == 0) {
            throw new ArgumentException("path");
        }
        String string = Path.getDirectoryName(path);
        if (!StringExtensions.isNullOrEmpty(string) && !Directory.exists(string)) {
            throw new DirectoryNotFoundException(StringExtensions.format("Could not find a part of the path \"{0}\".", path));
        }
        java.io.File file = new java.io.File(path);
        if (file.isFile() && file.exists() && !file.delete()) {
            throw new IOException("File was not deleted: " + path);
        }
    }

    public static boolean exists(String path) {
        boolean bl2 = false;
        if (path == null) {
            return bl2;
        }
        if (path.length() == 0) {
            return bl2;
        }
        java.io.File file = new java.io.File(path);
        bl2 = file.isFile() && file.exists();
        return bl2;
    }

    public static void move(String sourceFileName, String destFileName) {
        if (sourceFileName == null) {
            throw new ArgumentNullException("sourceFileName");
        }
        if (destFileName == null) {
            throw new ArgumentNullException("destFileName");
        }
        if (sourceFileName.length() == 0) {
            throw new ArgumentException("An empty file name is not valid.", "sourceFileName");
        }
        if (StringExtensions.trim(sourceFileName).length() == 0) {
            throw new ArgumentException("The file name is not valid.");
        }
        if (destFileName.length() == 0) {
            throw new ArgumentException("An empty file name is not valid.", "destFileName");
        }
        if (StringExtensions.trim(destFileName).length() == 0) {
            throw new ArgumentException("The file name is not valid.");
        }
        java.io.File file = new java.io.File(sourceFileName);
        java.io.File file2 = new java.io.File(destFileName);
        if (!file.exists()) {
            throw new FileNotFoundException("No such source file: " + sourceFileName, sourceFileName);
        }
        if (!file.isFile()) {
            throw new IOException("Can't move directory: " + sourceFileName);
        }
        if (file2.exists()) {
            throw new IOException("Such directory already exist: " + file2.getAbsolutePath());
        }
        boolean bl2 = false;
        bl2 = file.renameTo(file2);
        if (!bl2) {
            throw new IOException("File was not moved");
        }
    }

    public static FileStream open(String path, int mode) {
        return new FileStream(path, mode, mode == 6 ? 2 : 3, 0);
    }

    public static FileStream open(String path, int mode, int access) {
        return new FileStream(path, mode, access, 0);
    }

    public static FileStream open(String path, int mode, int access, int share) {
        return new FileStream(path, mode, access, share);
    }

    public static FileStream openRead(String path) {
        return new FileStream(path, 3, 1, 1);
    }

    public static StreamReader openText(String path) {
        return new StreamReader(path);
    }

    public static FileStream openWrite(String path) {
        return new FileStream(path, 4, 2, 0);
    }

    public static void replace(String sourceFileName, String destinationFileName, String destinationBackupFileName) {
        File.replace(sourceFileName, destinationFileName, destinationBackupFileName, false);
    }

    public static void replace(String sourceFileName, String destinationFileName, String destinationBackupFileName, boolean ignoreMetadataErrors) {
        if (sourceFileName == null) {
            throw new ArgumentNullException("sourceFileName");
        }
        if (destinationFileName == null) {
            throw new ArgumentNullException("destinationFileName");
        }
        if (StringExtensions.trim(sourceFileName).length() == 0) {
            throw new ArgumentException("sourceFileName");
        }
        if (StringExtensions.trim(destinationFileName).length() == 0) {
            throw new ArgumentException("destinationFileName");
        }
        java.io.File file = new java.io.File(sourceFileName);
        java.io.File file2 = new java.io.File(destinationFileName);
        java.io.File file3 = new java.io.File(destinationBackupFileName);
        if (file.isDirectory()) {
            throw new IOException(StringExtensions.format("{0} is a directory", sourceFileName));
        }
        if (file2.isDirectory()) {
            throw new IOException(StringExtensions.format("{0} is a directory", destinationFileName));
        }
        if (file3.isDirectory()) {
            throw new IOException(StringExtensions.format("{0} is a directory", destinationBackupFileName));
        }
        if (!file.exists()) {
            throw new FileNotFoundException(StringExtensions.format("{0} does not exist", sourceFileName), sourceFileName);
        }
        if (!file2.exists()) {
            throw new FileNotFoundException(StringExtensions.format("{0} does not exist", destinationFileName), destinationFileName);
        }
        if (StringExtensions.equals(file.getAbsolutePath(), file2.getAbsolutePath())) {
            throw new IOException(StringExtensions.format("Source and destination arguments are the same file.", new Object[0]));
        }
        File.copy(destinationFileName, destinationBackupFileName);
        File.copy(sourceFileName, destinationFileName);
        File.delete(sourceFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAllBytes(String path) {
        FileStream fileStream = File.openRead(path);
        try {
            int n2;
            long l2 = fileStream.getLength();
            if (l2 > Integer.MAX_VALUE) {
                throw new IOException("Reading more than 2GB with this call is not supported");
            }
            int n3 = 0;
            byte[] byArray = new byte[(int)l2];
            for (int i2 = (int)l2; i2 > 0; i2 -= n2) {
                n2 = fileStream.read(byArray, n3, i2);
                if (n2 == 0) {
                    throw new IOException("Unexpected end of stream");
                }
                n3 += n2;
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            if (fileStream != null) {
                fileStream.dispose();
            }
        }
    }

    public static String[] readAllLines(String path) {
        StreamReader streamReader = File.openText(path);
        try {
            String[] stringArray = File.a(streamReader);
            return stringArray;
        }
        finally {
            if (streamReader != null) {
                streamReader.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readAllLines(String path, Encoding encoding) {
        StreamReader streamReader = new StreamReader(path, encoding);
        try {
            String[] stringArray = File.a(streamReader);
            return stringArray;
        }
        finally {
            if (streamReader != null) {
                streamReader.dispose();
            }
        }
    }

    static String[] a(StreamReader streamReader) {
        List<String> list = new List<String>();
        while (!streamReader.getEndOfStream()) {
            list.addItem(streamReader.readLine());
        }
        return list.toArray(new String[0]);
    }

    public static String readAllText(String path) {
        StreamReader streamReader = new StreamReader(path);
        try {
            String string = streamReader.readToEnd();
            return string;
        }
        finally {
            if (streamReader != null) {
                streamReader.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAllText(String path, Encoding encoding) {
        StreamReader streamReader = new StreamReader(path, encoding);
        try {
            String string = streamReader.readToEnd();
            return string;
        }
        finally {
            if (streamReader != null) {
                streamReader.dispose();
            }
        }
    }

    public static void writeAllBytes(String path, byte[] bytes) {
        FileStream fileStream = File.create(path);
        try {
            ((Stream)fileStream).write(bytes, 0, bytes.length);
        }
        finally {
            if (fileStream != null) {
                fileStream.dispose();
            }
        }
    }

    public static void writeAllLines(String path, String[] contents) {
        StreamWriter streamWriter = new StreamWriter(path);
        try {
            File.a(streamWriter, contents);
        }
        finally {
            if (streamWriter != null) {
                streamWriter.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAllLines(String path, String[] contents, Encoding encoding) {
        StreamWriter streamWriter = new StreamWriter(path, false, encoding);
        try {
            File.a(streamWriter, contents);
        }
        finally {
            if (streamWriter != null) {
                streamWriter.dispose();
            }
        }
    }

    static void a(StreamWriter streamWriter, String[] stringArray) {
        for (String string : stringArray) {
            streamWriter.writeLine(string);
        }
    }

    public static void writeAllText(String path, String contents) {
        File.writeAllText(path, contents, Encoding.getUTF8());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAllText(String path, String contents, Encoding encoding) {
        StreamWriter streamWriter = new StreamWriter(path, false, encoding);
        try {
            streamWriter.write(contents);
        }
        finally {
            if (streamWriter != null) {
                streamWriter.dispose();
            }
        }
    }
}

