/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net;

import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Int64Extensions;
import com.aspose.html.internal.ms.System.Net.Cookie;
import com.aspose.html.internal.ms.System.Net.CookieCollection;
import com.aspose.html.internal.ms.System.Net.CookieContainer;
import com.aspose.html.internal.ms.System.Net.CookieParser;
import com.aspose.html.internal.ms.System.Net.HttpDate;
import com.aspose.html.internal.ms.System.Net.HttpStatusCode;
import com.aspose.html.internal.ms.System.Net.WebConnectionData;
import com.aspose.html.internal.ms.System.Net.WebConnectionStream;
import com.aspose.html.internal.ms.System.Net.WebHeaderCollection;
import com.aspose.html.internal.ms.System.Net.WebResponse;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.Runtime.Serialization.ISerializable;
import com.aspose.html.internal.ms.System.Runtime.Serialization.SerializationInfo;
import com.aspose.html.internal.ms.System.Runtime.Serialization.StreamingContext;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Uri;
import com.aspose.html.internal.ms.System.Version;
import com.aspose.html.internal.ms.core.compression.zlib.DeflateStream;
import com.aspose.html.internal.ms.core.compression.zlib.GZipStream;
import com.aspose.html.internal.ms.lang.Operators;

@SerializableAttribute
public class HttpWebResponse
extends WebResponse
implements IDisposable,
ISerializable {
    private Uri a;
    private WebHeaderCollection b;
    private CookieCollection c;
    private String d;
    private Version e;
    private int f;
    private String g;
    private long h;
    private String i;
    private CookieContainer j;
    private boolean k;
    private Stream l;

    HttpWebResponse(Uri uri, String method, WebConnectionData data, CookieContainer container) {
        String string;
        this.a = uri;
        this.d = method;
        this.b = data.c;
        this.e = data.d;
        this.f = data.a;
        this.g = data.b;
        this.l = data.f;
        this.h = Operators.castToInt64(-1, 9);
        try {
            string = this.b.get_Item("Content-Length");
            long[] lArray = new long[]{this.h};
            boolean bl2 = StringExtensions.isNullOrEmpty(string) || !Int64Extensions.tryParse(string, lArray);
            this.h = lArray[0];
            if (bl2) {
                this.h = Operators.castToInt64(-1, 9);
            }
        }
        catch (RuntimeException runtimeException) {
            this.h = Operators.castToInt64(-1, 9);
        }
        if (container != null) {
            this.j = container;
            this.e();
        }
        if ("gzip".equals(string = this.b.get_Item("Content-Encoding")) && (data.a().getAutomaticDecompression() & 1) != 0) {
            this.l = new GZipStream(this.l, 1);
        } else if ("deflate".equals(string) && (data.a().getAutomaticDecompression() & 2) != 0) {
            this.l = new DeflateStream(this.l, 1);
        }
    }

    @Deprecated
    protected HttpWebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext) {
        SerializationInfo serializationInfo2 = serializationInfo;
        this.a = (Uri)serializationInfo2.getValue("uri", Operators.typeOf(Uri.class));
        this.h = serializationInfo2.getInt64("contentLength");
        this.i = serializationInfo2.getString("contentType");
        this.d = serializationInfo2.getString("method");
        this.g = serializationInfo2.getString("statusDescription");
        this.c = (CookieCollection)serializationInfo2.getValue("cookieCollection", Operators.typeOf(CookieCollection.class));
        this.e = (Version)serializationInfo2.getValue("version", Operators.typeOf(Version.class));
        this.f = (Integer)serializationInfo2.getValue("statusCode", Operators.typeOf(HttpStatusCode.class));
    }

    public String getCharacterSet() {
        String string = this.getContentType();
        if (string == null) {
            return "ISO-8859-1";
        }
        String string2 = StringExtensions.toLower(string);
        int n2 = StringExtensions.indexOf(string2, "charset=", (short)4);
        if (n2 == -1) {
            return "ISO-8859-1";
        }
        int n3 = StringExtensions.indexOf(string2, ';', n2 += 8);
        return n3 == -1 ? StringExtensions.substring(string, n2) : StringExtensions.substring(string, n2, n3 - n2);
    }

    public String getContentEncoding() {
        this.d();
        String string = this.b.get_Item("Content-Encoding");
        return string != null ? string : "";
    }

    @Override
    public long getContentLength() {
        return this.h;
    }

    @Override
    public String getContentType() {
        this.d();
        if (this.i == null) {
            this.i = this.b.get_Item("Content-Type");
        }
        return this.i;
    }

    public CookieCollection getCookies() {
        this.d();
        if (this.c == null) {
            this.c = new CookieCollection();
        }
        return this.c;
    }

    public void setCookies(CookieCollection value) {
        this.d();
        this.c = value;
    }

    @Override
    public WebHeaderCollection getHeaders() {
        return this.b;
    }

    static Exception a() {
        return new NotImplementedException();
    }

    @Override
    public boolean isMutuallyAuthenticated() {
        throw HttpWebResponse.a();
    }

    public DateTime getLastModified() {
        this.d();
        try {
            String string = this.b.get_Item("Last-Modified");
            return HttpDate.a(string);
        }
        catch (RuntimeException runtimeException) {
            return DateTime.getNow();
        }
    }

    public String getMethod() {
        this.d();
        return this.d;
    }

    public Version getProtocolVersion() {
        this.d();
        return this.e;
    }

    @Override
    public Uri getResponseUri() {
        this.d();
        return this.a;
    }

    public String getServer() {
        this.d();
        return this.b.get_Item("Server");
    }

    public int getStatusCode() {
        return this.f;
    }

    public String getStatusDescription() {
        this.d();
        return this.g;
    }

    public String getResponseHeader(String headerName) {
        this.d();
        String string = this.b.get_Item(headerName);
        return string != null ? string : "";
    }

    void b() {
        WebConnectionStream webConnectionStream = Operators.as(this.l, WebConnectionStream.class);
        if (webConnectionStream == null) {
            return;
        }
        try {
            webConnectionStream.i();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public Stream getResponseStream() {
        this.d();
        if (this.l == null) {
            return Stream.Null;
        }
        if (StringExtensions.equals(this.d, "HEAD", (short)5)) {
            return Stream.Null;
        }
        return this.l;
    }

    @Override
    public void getObjectData_Rename_Namesake(SerializationInfo serializationInfo, StreamingContext streamingContext) {
        this.getObjectData(serializationInfo, streamingContext.Clone());
    }

    @Override
    public void getObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext) {
        SerializationInfo serializationInfo2 = serializationInfo;
        serializationInfo2.addValue("uri", this.a);
        serializationInfo2.addValue("contentLength", this.h);
        serializationInfo2.addValue("contentType", this.i);
        serializationInfo2.addValue("method", this.d);
        serializationInfo2.addValue("statusDescription", this.g);
        serializationInfo2.addValue("cookieCollection", this.c);
        serializationInfo2.addValue("version", this.e);
        serializationInfo2.addValue("statusCode", Operators.boxing(this.f));
    }

    @Override
    public void close() {
        if (this.l != null) {
            Stream stream = this.l;
            this.l = null;
            if (stream != null) {
                stream.close();
            }
        }
    }

    @Override
    public void dispose() {
        this.a(true);
    }

    private void a(boolean bl2) {
        this.k = true;
        if (bl2) {
            this.close();
        }
    }

    private void d() {
        if (this.k) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).getFullName());
        }
    }

    private void e() {
        String string;
        if (this.b == null) {
            return;
        }
        try {
            string = this.b.get("Set-Cookie");
            if (string != null && this.a(string)) {
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            string = this.b.get("Set-Cookie2");
            if (string != null) {
                this.a(string);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private boolean a(String string) {
        if (this.c == null) {
            this.c = new CookieCollection();
        }
        boolean bl2 = false;
        CookieParser cookieParser = new CookieParser(string);
        for (Cookie cookie : cookieParser.a()) {
            if ("".equals(cookie.getDomain())) {
                cookie.setDomain(this.a.getHost());
                cookie.a(false);
            }
            if (cookie.a() && !CookieContainer.a(this.a, cookie.getDomain())) continue;
            this.c.add(cookie);
            if (this.j == null) continue;
            this.j.add(this.a, cookie);
            bl2 = true;
        }
        return bl2;
    }
}

