/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net.NetworkInformation;

import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Net.NetworkInformation.IPInterfaceProperties;
import com.aspose.html.internal.ms.System.Net.NetworkInformation.IPv4InterfaceStatistics;
import com.aspose.html.internal.ms.System.Net.NetworkInformation.NetworkInformationException;
import com.aspose.html.internal.ms.System.Net.NetworkInformation.PhysicalAddress;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.core.logger.Log4jLogger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;

public abstract class NetworkInterface {
    protected NetworkInterface() {
    }

    public static NetworkInterface[] getAllNetworkInterfaces() {
        try {
            Enumeration<java.net.NetworkInterface> enumeration = java.net.NetworkInterface.getNetworkInterfaces();
            List<NetworkInterface> list = new List<NetworkInterface>();
            for (java.net.NetworkInterface networkInterface : Collections.list(enumeration)) {
                if (!networkInterface.getInetAddresses().hasMoreElements()) continue;
                list.add(new SystemNetworkInterface(networkInterface));
            }
            return list.toArray(new NetworkInterface[0]);
        }
        catch (SocketException socketException) {
            Log4jLogger.debug(socketException.toString(), socketException);
            throw new NetworkInformationException();
        }
    }

    public static boolean getIsNetworkAvailable() {
        NetworkInterface[] networkInterfaceArray = NetworkInterface.getAllNetworkInterfaces();
        for (int i2 = 0; i2 < networkInterfaceArray.length; ++i2) {
            try {
                if (!networkInterfaceArray[i2].a().isUp()) continue;
                return true;
            }
            catch (SocketException socketException) {
                return false;
            }
        }
        return false;
    }

    public static int getLoopbackInterfaceIndex() {
        NetworkInterface[] networkInterfaceArray = NetworkInterface.getAllNetworkInterfaces();
        for (int i2 = 0; i2 < networkInterfaceArray.length; ++i2) {
        }
        return -1;
    }

    abstract java.net.NetworkInterface a();

    public abstract IPInterfaceProperties getIPProperties();

    public abstract IPv4InterfaceStatistics getIPv4Statistics();

    public abstract PhysicalAddress getPhysicalAddress();

    public abstract boolean supports(int var1);

    public abstract String getDescription();

    public abstract String getId();

    public abstract boolean isReceiveOnly();

    public abstract String getName();

    public abstract int getNetworkInterfaceType();

    public abstract int getOperationalStatus();

    public abstract long getSpeed();

    public abstract boolean getSupportsMulticast();

    private static class SystemNetworkInterface
    extends NetworkInterface {
        java.net.NetworkInterface a;

        SystemNetworkInterface(java.net.NetworkInterface internal) {
            this.a = internal;
        }

        @Override
        public IPInterfaceProperties getIPProperties() {
            throw new NotImplementedException();
        }

        @Override
        public IPv4InterfaceStatistics getIPv4Statistics() {
            throw new NotImplementedException();
        }

        @Override
        public PhysicalAddress getPhysicalAddress() {
            try {
                return new PhysicalAddress(this.a.getHardwareAddress());
            }
            catch (SocketException socketException) {
                Log4jLogger.debug(socketException.toString(), socketException);
                return null;
            }
        }

        @Override
        public boolean supports(int networkInterfaceComponent) {
            Enumeration<InetAddress> enumeration = this.a.getInetAddresses();
            switch (networkInterfaceComponent) {
                case 0: {
                    while (enumeration.hasMoreElements()) {
                        InetAddress inetAddress = enumeration.nextElement();
                        if (!(inetAddress instanceof Inet4Address)) continue;
                        return true;
                    }
                    break;
                }
                case 1: {
                    while (enumeration.hasMoreElements()) {
                        InetAddress inetAddress = enumeration.nextElement();
                        if (!(inetAddress instanceof Inet6Address)) continue;
                        return true;
                    }
                    break;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.a.getDisplayName();
        }

        @Override
        public String getId() {
            throw new NotImplementedException("not supported");
        }

        @Override
        public boolean isReceiveOnly() {
            return false;
        }

        @Override
        public String getName() {
            return this.a.getDisplayName();
        }

        @Override
        public int getNetworkInterfaceType() {
            try {
                if (this.a.isPointToPoint()) {
                    return 23;
                }
                if (this.a.isLoopback()) {
                    return 24;
                }
                if (this.a.getName().startsWith("eth")) {
                    return 6;
                }
            }
            catch (SocketException socketException) {
                Log4jLogger.debug(socketException.toString(), socketException);
            }
            return 1;
        }

        @Override
        public int getOperationalStatus() {
            try {
                if (this.a.isUp()) {
                    return 1;
                }
            }
            catch (SocketException socketException) {
                Log4jLogger.debug(socketException.toString(), socketException);
            }
            return 4;
        }

        @Override
        public long getSpeed() {
            try {
                if (!this.a.isUp()) {
                    return 0L;
                }
            }
            catch (SocketException socketException) {
                Log4jLogger.debug(socketException.toString(), socketException);
            }
            throw new NotImplementedException();
        }

        @Override
        public boolean getSupportsMulticast() {
            try {
                return this.a.supportsMulticast();
            }
            catch (SocketException socketException) {
                return false;
            }
        }

        @Override
        java.net.NetworkInterface a() {
            return this.a;
        }
    }
}

