/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net.NetworkInformation;

import com.aspose.html.internal.ms.System.ByteExtensions;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.IndexOutOfRangeException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.lang.Operators;

public class PhysicalAddress {
    public static final PhysicalAddress None = new PhysicalAddress(new byte[0]);
    private static final int a = 6;
    private byte[] b;

    public PhysicalAddress(byte[] address) {
        this.b = address;
    }

    public static PhysicalAddress parseEthernet(String address) {
        if (address == null) {
            return None;
        }
        String[] stringArray = StringExtensions.split(address, ':');
        byte[] byArray = new byte[stringArray.length];
        int n2 = 0;
        for (String string : stringArray) {
            byArray[n2++] = ByteExtensions.parse(string, 515);
        }
        return new PhysicalAddress(byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static PhysicalAddress parse(String address) {
        int n2;
        int n3;
        if (address == null) {
            return None;
        }
        if (StringExtensions.equals(address, StringExtensions.Empty)) {
            throw new FormatException("An invalid physical address was specified.");
        }
        String[] stringArray = StringExtensions.split(address, '-');
        if (stringArray.length == 1) {
            void objectArray;
            if (address.length() != 12) {
                throw new FormatException("An invalid physical address was specified.");
            }
            stringArray = new String[6];
            boolean i2 = false;
            while (objectArray < stringArray.length) {
                stringArray[objectArray] = StringExtensions.substring(address, (int)(objectArray * 2), 2);
                ++objectArray;
            }
        }
        if (stringArray.length == 6) {
            String[] stringArray2 = stringArray;
            n3 = stringArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                String string = stringArray2[n2];
                if (string.length() > 2) {
                    throw new FormatException("An invalid physical address was specified.");
                }
                if (string.length() >= 2) continue;
                throw new IndexOutOfRangeException("An invalid physical address was specified.");
            }
        } else {
            throw new FormatException("An invalid physical address was specified.");
        }
        byte[] byArray = new byte[6];
        for (n3 = 0; n3 < 6; ++n3) {
            n2 = Operators.castToByte(Operators.castToInt32(PhysicalAddress.a(stringArray[n3].charAt(0)), 6) << 4, 9);
            byArray[n3] = n2 = (byte)(Operators.castToInt32((byte)n2, 6) + Operators.castToInt32(PhysicalAddress.a(stringArray[n3].charAt(1)), 6));
        }
        return new PhysicalAddress(byArray);
    }

    static byte a(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return Operators.castToByte(c2 - 48, 9);
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return Operators.castToByte(c2 - 97 + 10, 9);
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return Operators.castToByte(c2 - 65 + 10, 9);
        }
        throw new FormatException("Invalid physical address.");
    }

    public boolean equals(Object comparand) {
        PhysicalAddress physicalAddress = Operators.as(comparand, PhysicalAddress.class);
        if (physicalAddress == null) {
            return false;
        }
        if (this.b.length != physicalAddress.b.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            if (Operators.castToInt32(this.b[i2], 6) == Operators.castToInt32(physicalAddress.b[i2], 6)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Operators.castToInt32(this.b[5], 6) << 8 ^ Operators.castToInt32(this.b[4], 6) ^ Operators.castToInt32(this.b[3], 6) << 24 ^ Operators.castToInt32(this.b[2], 6) << 16 ^ Operators.castToInt32(this.b[1], 6) << 8 ^ Operators.castToInt32(this.b[0], 6);
    }

    public byte[] getAddressBytes() {
        return this.b;
    }

    public String toString() {
        if (this.b == null) {
            return "";
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        for (byte by2 : this.b) {
            msStringBuilder2.appendFormat("{0:X2}", Operators.boxing(by2));
        }
        return msStringBuilder2.toString();
    }
}

