/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.EnumExtensions;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.Net.Sockets.AddressFamily;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;

public class SocketAddress {
    private byte[] a;

    public SocketAddress(int family, int size) {
        if (size < 2) {
            throw new ArgumentOutOfRangeException("size is too small");
        }
        this.a = new byte[size];
        this.a[0] = (byte)family;
        this.a[1] = Operators.castToByte(family >> 8, 9);
    }

    public SocketAddress(int family) {
        this(family, 32);
    }

    public int getFamily() {
        return Operators.castToInt32(this.a[0], 6) + (Operators.castToInt32(this.a[1], 6) << 8);
    }

    public int getSize() {
        return Array.boxing(this.a).getLength();
    }

    public byte get_Item(int offset) {
        return this.a[offset];
    }

    public void set_Item(int offset, byte value) {
        this.a[offset] = value;
    }

    public String toString() {
        String string = EnumExtensions.toString(AddressFamily.class, Operators.castToInt32(this.a[0], 6));
        int n2 = Array.boxing(this.a).getLength();
        String string2 = StringExtensions.concat(string, ":", Int32Extensions.toString(n2), ":{");
        for (int i2 = 2; i2 < n2; ++i2) {
            int n3 = Operators.castToInt32(this.a[i2], 6);
            string2 = StringExtensions.concat(string2, Int32Extensions.toString(n3));
            if (i2 >= n2 - 1) continue;
            string2 = StringExtensions.concat(string2, ",");
        }
        string2 = StringExtensions.concat(string2, "}");
        return string2;
    }

    public boolean equals(Object comparand) {
        SocketAddress socketAddress = Operators.as(comparand, SocketAddress.class);
        if (socketAddress != null && Array.boxing(socketAddress.a).getLength() == Array.boxing(this.a).getLength()) {
            byte[] byArray = socketAddress.a;
            for (int i2 = 0; i2 < Array.boxing(this.a).getLength(); ++i2) {
                if (Operators.castToInt32(byArray[i2], 6) == Operators.castToInt32(this.a[i2], 6)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < Array.boxing(this.a).getLength(); ++i2) {
            n2 += Operators.castToInt32(this.a[i2], 6) + i2;
        }
        return n2;
    }
}

