/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net.Sockets;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.AsyncCallback;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IAsyncResult;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.Net.Dns;
import com.aspose.html.internal.ms.System.Net.EndPoint;
import com.aspose.html.internal.ms.System.Net.IPAddress;
import com.aspose.html.internal.ms.System.Net.IPEndPoint;
import com.aspose.html.internal.ms.System.Net.Sockets.IPv6MulticastOption;
import com.aspose.html.internal.ms.System.Net.Sockets.MulticastOption;
import com.aspose.html.internal.ms.System.Net.Sockets.Socket;
import com.aspose.html.internal.ms.System.Net.Sockets.SocketException;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;

public class UdpClient
implements IDisposable {
    private boolean a = false;
    private boolean b = false;
    private Socket c;
    private int d = 2;
    private byte[] e;

    public UdpClient() {
        this(2, false);
    }

    public UdpClient(int family, boolean fake) {
        if (family != 2 && family != 23) {
            throw new ArgumentException("Family must be InterNetwork or InterNetworkV6", "family");
        }
        this.d = family;
        this.a((EndPoint)null);
    }

    public static UdpClient ctor_AddressFamily(int family) {
        return new UdpClient(family, false);
    }

    public UdpClient(int port, float fake) {
        if (port < 0 || port > 65535) {
            throw new ArgumentOutOfRangeException("port");
        }
        this.d = 2;
        IPEndPoint iPEndPoint = new IPEndPoint(IPAddress.Any, port);
        this.a((EndPoint)iPEndPoint);
    }

    public static UdpClient ctor_Port(int port) {
        return new UdpClient(port, 0.0f);
    }

    public UdpClient(IPEndPoint localEP) {
        if (localEP == null) {
            throw new ArgumentNullException("localEP");
        }
        this.d = localEP.getAddressFamily();
        this.a((EndPoint)localEP);
    }

    public UdpClient(int port, int family) {
        if (family != 2 && family != 23) {
            throw new ArgumentException("Family must be InterNetwork or InterNetworkV6", "family");
        }
        if (port < 0 || port > 65535) {
            throw new ArgumentOutOfRangeException("port");
        }
        this.d = family;
        IPEndPoint iPEndPoint = family == 2 ? new IPEndPoint(IPAddress.Any, port) : new IPEndPoint(IPAddress.IPv6Any, port);
        this.a((EndPoint)iPEndPoint);
    }

    public UdpClient(String hostname, int port) {
        if (hostname == null) {
            throw new ArgumentNullException("hostname");
        }
        if (port < 0 || port > 65535) {
            throw new ArgumentOutOfRangeException("port");
        }
        this.a((EndPoint)null);
        this.connect(hostname, port);
    }

    private void a(EndPoint endPoint) {
        if (this.c != null) {
            this.c.close();
            this.c = null;
        }
        this.c = new Socket(this.d, 2, 17);
        if (endPoint != null) {
            this.c.bind(endPoint);
        }
    }

    public void close() {
        this.dispose();
    }

    private void a(IPEndPoint iPEndPoint) {
        try {
            this.c.connect(iPEndPoint);
        }
        catch (SocketException socketException) {
            if (socketException.getErrorCode() == 10013) {
                this.c.setSocketOption(65535, 32, 1);
                this.c.connect(iPEndPoint);
            }
            throw socketException;
        }
    }

    public void connect(IPEndPoint endPoint) {
        this.a();
        if (endPoint == null) {
            throw new ArgumentNullException("endPoint");
        }
        this.a(endPoint);
        this.b = true;
    }

    public void connect(IPAddress addr, int port) {
        if (addr == null) {
            throw new ArgumentNullException("addr");
        }
        if (port < 0 || port > 65535) {
            throw new ArgumentOutOfRangeException("port");
        }
        this.connect(new IPEndPoint(addr, port));
    }

    public void connect(String hostname, int port) {
        if (port < 0 || port > 65535) {
            throw new ArgumentOutOfRangeException("port");
        }
        IPAddress[] iPAddressArray = Dns.getHostAddresses(hostname);
        for (int i2 = 0; i2 < Array.boxing(iPAddressArray).getLength(); ++i2) {
            try {
                this.d = iPAddressArray[i2].getAddressFamily();
                this.connect(new IPEndPoint(iPAddressArray[i2], port));
                break;
            }
            catch (RuntimeException runtimeException) {
                if (i2 != Array.boxing(iPAddressArray).getLength() - 1) continue;
                if (this.c != null) {
                    this.c.close();
                    this.c = null;
                }
                throw runtimeException;
            }
        }
    }

    public void dropMulticastGroup(IPAddress multicastAddr) {
        this.a();
        if (multicastAddr == null) {
            throw new ArgumentNullException("multicastAddr");
        }
        if (this.d == 2) {
            this.c.setSocketOption(0, 13, new MulticastOption(multicastAddr));
        } else {
            this.c.setSocketOption(41, 13, new IPv6MulticastOption(multicastAddr));
        }
    }

    public void dropMulticastGroup(IPAddress multicastAddr, int ifindex) {
        this.a();
        if (multicastAddr == null) {
            throw new ArgumentNullException("multicastAddr");
        }
        if (this.d == 23) {
            this.c.setSocketOption(41, 13, new IPv6MulticastOption(multicastAddr, Operators.castToInt64(ifindex, 9)));
        }
    }

    public void joinMulticastGroup(IPAddress multicastAddr) {
        this.a();
        if (multicastAddr == null) {
            throw new ArgumentNullException("multicastAddr");
        }
        if (this.d == 2) {
            this.c.setSocketOption(0, 12, new MulticastOption(multicastAddr));
        } else {
            this.c.setSocketOption(41, 12, new IPv6MulticastOption(multicastAddr));
        }
    }

    public void joinMulticastGroup(int ifindex, IPAddress multicastAddr) {
        this.a();
        if (multicastAddr == null) {
            throw new ArgumentNullException("multicastAddr");
        }
        if (this.d != 23) {
            throw new SocketException(10045);
        }
        this.c.setSocketOption(41, 12, new IPv6MulticastOption(multicastAddr, Operators.castToInt64(ifindex, 9)));
    }

    public void joinMulticastGroup(IPAddress multicastAddr, int timeToLive) {
        this.a();
        if (multicastAddr == null) {
            throw new ArgumentNullException("multicastAddr");
        }
        if (timeToLive < 0 || timeToLive > 255) {
            throw new ArgumentOutOfRangeException("timeToLive");
        }
        this.joinMulticastGroup(multicastAddr);
        if (this.d == 2) {
            this.c.setSocketOption(0, 10, timeToLive);
        } else {
            this.c.setSocketOption(41, 10, timeToLive);
        }
    }

    public void joinMulticastGroup(IPAddress multicastAddr, IPAddress localAddress) {
        this.a();
        if (this.d != 2) {
            throw new SocketException(10045);
        }
        this.c.setSocketOption(0, 12, new MulticastOption(multicastAddr, localAddress));
    }

    public byte[] receive(IPEndPoint[] remoteEP) {
        this.a();
        byte[] byArray = new byte[65536];
        EndPoint endPoint = new IPEndPoint(IPAddress.Any, 0);
        EndPoint[] endPointArray = new EndPoint[]{endPoint};
        int n2 = this.c.receiveFrom(byArray, endPointArray);
        endPoint = endPointArray[0];
        if (n2 < Array.boxing(byArray).getLength()) {
            byArray = this.a(byArray, n2);
        }
        remoteEP[0] = endPoint;
        return byArray;
    }

    private int a(byte[] byArray, int n2, IPEndPoint iPEndPoint) {
        try {
            if (iPEndPoint == null) {
                return this.c.send(byArray, 0, n2, 0);
            }
            return this.c.sendTo(byArray, 0, n2, 0, iPEndPoint);
        }
        catch (SocketException socketException) {
            if (socketException.getErrorCode() == 10013) {
                this.c.setSocketOption(65535, 32, 1);
                if (iPEndPoint == null) {
                    return this.c.send(byArray, 0, n2, 0);
                }
                return this.c.sendTo(byArray, 0, n2, 0, iPEndPoint);
            }
            throw socketException;
        }
    }

    public int send(byte[] dgram, int bytes) {
        this.a();
        if (dgram == null) {
            throw new ArgumentNullException("dgram");
        }
        if (!this.b) {
            throw new InvalidOperationException(StringExtensions.concat("Operation not allowed on ", "non-connected sockets."));
        }
        return this.a(dgram, bytes, null);
    }

    public int send(byte[] dgram, int bytes, IPEndPoint endPoint) {
        this.a();
        if (dgram == null) {
            throw new ArgumentNullException("dgram is null");
        }
        if (this.b) {
            if (endPoint != null) {
                throw new InvalidOperationException(StringExtensions.concat("Cannot send packets to an ", "arbitrary host while connected."));
            }
            return this.a(dgram, bytes, null);
        }
        return this.a(dgram, bytes, endPoint);
    }

    public int send(byte[] dgram, int bytes, String hostname, int port) {
        return this.send(dgram, bytes, new IPEndPoint(Dns.getHostAddresses(hostname)[0], port));
    }

    private byte[] a(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(byArray2), 0, n2);
        return byArray2;
    }

    private IAsyncResult a(byte[] byArray, int n2, IPEndPoint iPEndPoint, AsyncCallback asyncCallback, Object object) {
        try {
            if (iPEndPoint == null) {
                return this.c.beginSend(byArray, 0, n2, 0, asyncCallback, object);
            }
            return this.c.beginSendTo(byArray, 0, n2, 0, iPEndPoint, asyncCallback, object);
        }
        catch (SocketException socketException) {
            if (socketException.getErrorCode() == 10013) {
                this.c.setSocketOption(65535, 32, 1);
                if (iPEndPoint == null) {
                    return this.c.beginSend(byArray, 0, n2, 0, asyncCallback, object);
                }
                return this.c.beginSendTo(byArray, 0, n2, 0, iPEndPoint, asyncCallback, object);
            }
            throw socketException;
        }
    }

    public IAsyncResult beginSend(byte[] datagram, int bytes, AsyncCallback requestCallback, Object state) {
        return this.beginSend(datagram, bytes, null, requestCallback, state);
    }

    public IAsyncResult beginSend(byte[] datagram, int bytes, IPEndPoint endPoint, AsyncCallback requestCallback, Object state) {
        this.a();
        if (datagram == null) {
            throw new ArgumentNullException("datagram");
        }
        return this.a(datagram, bytes, endPoint, requestCallback, state);
    }

    public IAsyncResult beginSend(byte[] datagram, int bytes, String hostname, int port, AsyncCallback requestCallback, Object state) {
        return this.beginSend(datagram, bytes, new IPEndPoint(Dns.getHostAddresses(hostname)[0], port), requestCallback, state);
    }

    public int endSend(IAsyncResult asyncResult) {
        this.a();
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult is a null reference");
        }
        return this.c.endSend(asyncResult);
    }

    public IAsyncResult beginReceive(AsyncCallback requestCallback, Object state) {
        this.a();
        this.e = new byte[8192];
        IPEndPoint iPEndPoint = this.d == 2 ? new IPEndPoint(IPAddress.Any, 0) : new IPEndPoint(IPAddress.IPv6Any, 0);
        EndPoint[] endPointArray = new EndPoint[]{iPEndPoint};
        return this.c.beginReceiveFrom(this.e, 0, 8192, 0, endPointArray, requestCallback, state);
    }

    public byte[] endReceive(IAsyncResult asyncResult, IPEndPoint[] remoteEP) {
        this.a();
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult is a null reference");
        }
        EndPoint endPoint = this.d == 2 ? new IPEndPoint(IPAddress.Any, 0) : new IPEndPoint(IPAddress.IPv6Any, 0);
        EndPoint[] endPointArray = new EndPoint[]{endPoint};
        int n2 = this.c.endReceiveFrom(asyncResult, endPointArray);
        remoteEP[0] = endPoint = endPointArray[0];
        byte[] byArray = new byte[n2];
        Array.copy(Array.boxing(this.e), Array.boxing(byArray), n2);
        return byArray;
    }

    protected boolean getActive() {
        return this.b;
    }

    protected void setActive(boolean value) {
        this.b = value;
    }

    public Socket getClient() {
        return this.c;
    }

    public void setClient(Socket value) {
        this.c = value;
    }

    public int getAvailable() {
        return this.c.getAvailable();
    }

    public boolean getDontFragment() {
        return this.c.getDontFragment();
    }

    public void setDontFragment(boolean value) {
        this.c.setDontFragment(value);
    }

    public boolean getEnableBroadcast() {
        return this.c.getEnableBroadcast();
    }

    public void setEnableBroadcast(boolean value) {
        this.c.setEnableBroadcast(value);
    }

    public boolean getExclusiveAddressUse() {
        return this.c.getExclusiveAddressUse();
    }

    public void setExclusiveAddressUse(boolean value) {
        this.c.setExclusiveAddressUse(value);
    }

    public boolean getMulticastLoopback() {
        return this.c.getMulticastLoopback();
    }

    public void setMulticastLoopback(boolean value) {
        this.c.setMulticastLoopback(value);
    }

    public short getTtl() {
        return this.c.getTtl();
    }

    public void setTtl(short value) {
        this.c.setTtl(value);
    }

    @Override
    public void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    protected void dispose(boolean disposing) {
        if (this.a) {
            return;
        }
        this.a = true;
        if (disposing) {
            if (this.c != null) {
                this.c.close();
            }
            this.c = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose(false);
        super.finalize();
    }

    private void a() {
        if (this.a) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).getFullName());
        }
    }
}

