/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Runtime.InteropServices;

import com.aspose.html.internal.ms.System.AccessViolationException;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.IntPtr;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.core.Win32.Kernel32;
import com.aspose.html.internal.ms.core.memory.Pointer;
import com.aspose.html.internal.ms.core.memory.PointerToArray;

public class Marshal {
    public static long sizeOf(Object obj) {
        if (obj instanceof IntPtr) {
            return ((IntPtr)obj).toPointer().getSize();
        }
        if (obj instanceof Pointer) {
            return ((Pointer)obj).getSize();
        }
        throw new NotImplementedException("");
    }

    public static void copy(byte[] source, int startIndex, IntPtr destination, int length) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(source, 1, startIndex, destination, destination.toPointer().getOffset(), length);
    }

    public static void copy(short[] source, int startIndex, IntPtr destination, int length) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(source, 2, startIndex, destination, destination.toPointer().getOffset(), length);
    }

    public static void copy(int[] source, int startIndex, IntPtr destination, int length) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(source, 4, startIndex, destination, destination.toPointer().getOffset(), length);
    }

    public static void copy(long[] source, int startIndex, IntPtr destination, int length) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(source, 8, startIndex, destination, destination.toPointer().getOffset(), length);
    }

    public static void copy(float[] source, int startIndex, IntPtr destination, int length) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(source, 4, startIndex, destination, destination.toPointer().getOffset(), length);
    }

    public static void copy(char[] source, int startIndex, IntPtr destination, int length) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(source, 2, startIndex, destination, destination.toPointer().getOffset(), length);
    }

    public static void copy(IntPtr source, char[] destination, int startIndex, int length) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(source, source.toPointer().getOffset(), destination, 2, startIndex, length);
    }

    public static void copy(double[] source, int startIndex, IntPtr destination, int length) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(source, 8, startIndex, destination, destination.toPointer().getOffset(), length);
    }

    public static void copy(IntPtr source, double[] destination, int startIndex, int length) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(source, source.toPointer().getOffset(), destination, 8, startIndex, length);
    }

    public static void copy(IntPtr source, float[] destination, int startIndex, int length) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(source, source.toPointer().getOffset(), destination, 4, startIndex, length);
    }

    public static void copy(IntPtr source, byte[] destination, int startIndex, int length) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(source, source.toPointer().getOffset(), destination, 1, startIndex, length);
    }

    public static void copy(IntPtr source, short[] destination, int startIndex, int length) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(source, source.toPointer().getOffset(), destination, 2, startIndex, length);
    }

    public static void copy(IntPtr source, int[] destination, int startIndex, int length) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(source, source.toPointer().getOffset(), destination, 4, startIndex, length);
    }

    public static void copy(IntPtr source, long[] destination, int startIndex, int length) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(source, source.toPointer().getOffset(), destination, 8, startIndex, length);
    }

    public static IntPtr allocHGlobal(int cb2) {
        if (cb2 <= 0) {
            throw new ArgumentOutOfRangeException("cb", "Non-negative number required.");
        }
        return new IntPtr(Pointer.create(new byte[cb2]));
    }

    public static IntPtr allocHGlobal(IntPtr cb2) {
        if (cb2 == null || cb2.toPointer() == null || cb2.toPointer().getData() == null) {
            throw new ArgumentNullException("cb cannot be null");
        }
        if (cb2.toPointer().getData() instanceof byte[]) {
            return Marshal.allocHGlobal(((byte[])cb2.toPointer().getData()).length);
        }
        if (cb2.toPointer().getData() instanceof short[]) {
            return Marshal.allocHGlobal(((short[])cb2.toPointer().getData()).length * 2);
        }
        if (cb2.toPointer().getData() instanceof int[]) {
            return Marshal.allocHGlobal(((int[])cb2.toPointer().getData()).length * 4);
        }
        if (cb2.toPointer().getData() instanceof long[]) {
            return Marshal.allocHGlobal(((long[])cb2.toPointer().getData()).length * 8);
        }
        throw new NotSupportedException();
    }

    public static void freeHGlobal(IntPtr hglobal) {
        hglobal.toPointer().cleanup();
    }

    public static byte readByte(IntPtr source) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        byte[] byArray = new byte[1];
        Marshal.a(source, source.toPointer().getOffset(), byArray, 1, 0, 1);
        return byArray[0];
    }

    public static byte readByte(IntPtr source, int ofs) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        byte[] byArray = new byte[1];
        Marshal.a(source, source.toPointer().getOffset() + ofs, byArray, 1, 0, 1);
        return byArray[0];
    }

    public static void writeByte(IntPtr destination, byte val) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new byte[]{val}, Marshal.sizeOf(Byte.TYPE), 0, destination, destination.toPointer().getOffset(), 1);
    }

    public static void writeByte(IntPtr destination, int ofs, byte val) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new byte[]{val}, Marshal.sizeOf(Byte.TYPE), 0, destination, destination.toPointer().getOffset() + ofs, 1);
    }

    public static byte readByte(Object ptr, int ofs) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static void writeByte(Object ptr, int ofs, byte val) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static short readInt16(IntPtr source) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        short[] sArray = new short[1];
        Marshal.a(source, source.toPointer().getOffset(), sArray, 2, 0, 1);
        return sArray[0];
    }

    public static short readInt16(IntPtr source, int ofs) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        short[] sArray = new short[1];
        Marshal.a(source, source.toPointer().getOffset() + ofs, sArray, 2, 0, 1);
        return sArray[0];
    }

    public static short readInt16(Object ptr, int ofs) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static void writeInt16(IntPtr destination, short val) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new short[]{val}, 2, 0, destination, destination.toPointer().getOffset(), 1);
    }

    public static void writeInt16(IntPtr destination, int ofs, short val) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new short[]{val}, 2, 0, destination, destination.toPointer().getOffset() + ofs, 1);
    }

    public static void writeInt16(Object ptr, int ofs, byte val) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static int readInt32(IntPtr source) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        int[] nArray = new int[1];
        Marshal.a(source, source.toPointer().getOffset(), nArray, 4, 0, 1);
        return nArray[0];
    }

    public static int readInt32(IntPtr source, int ofs) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        int[] nArray = new int[1];
        Marshal.a(source, source.toPointer().getOffset() + ofs, nArray, 4, 0, 1);
        return nArray[0];
    }

    public static int readInt32(Object ptr, int ofs) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static void writeInt32(IntPtr destination, int val) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new int[]{val}, 4, 0, destination, destination.toPointer().getOffset(), 1);
    }

    public static void writeInt32(IntPtr destination, int ofs, int val) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new int[]{val}, 4, 0, destination, destination.toPointer().getOffset() + ofs, 1);
    }

    public static void writeInt32(Object ptr, int ofs, int val) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static long readInt64(IntPtr source) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        long[] lArray = new long[1];
        Marshal.a(source, source.toPointer().getOffset(), lArray, 8, 0, 1);
        return lArray[0];
    }

    public static long readInt64(IntPtr source, int ofs) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        long[] lArray = new long[1];
        Marshal.a(source, source.toPointer().getOffset() + ofs, lArray, 8, 0, 1);
        return lArray[0];
    }

    public static int readInt64(Object ptr, int ofs) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static void writeInt64(IntPtr destination, long val) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new long[]{val}, 8, 0, destination, destination.toPointer().getOffset(), 1);
    }

    public static void writeInt64(IntPtr destination, int ofs, long val) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new long[]{val}, 8, 0, destination, destination.toPointer().getOffset() + ofs, 1);
    }

    public static void writeInt64(Object ptr, int ofs, long val) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static IntPtr readIntPtr(IntPtr source) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        return new IntPtr(Marshal.readInt64(source));
    }

    public static IntPtr readIntPtr(IntPtr source, int ofs) {
        if (source == null || source.toPointer() == null) {
            throw new ArgumentNullException();
        }
        return new IntPtr(Marshal.readInt64(source, ofs));
    }

    public static int readIntPtr(Object ptr, int ofs) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static void writeIntPtr(IntPtr destination, IntPtr val) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.writeInt64(destination, val.toInt64());
    }

    public static void writeIntPtr(IntPtr destination, int ofs, IntPtr val) {
        if (destination == null || destination.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.writeInt64(destination, ofs, val.toInt64());
    }

    public static int sizeOf(Class parameterType) {
        if (parameterType == IntPtr.class || parameterType == Long.TYPE || parameterType == Long.class) {
            return 8;
        }
        if (parameterType == Integer.TYPE || parameterType == Integer.class) {
            return 4;
        }
        if (parameterType == Short.TYPE || parameterType == Short.class) {
            return 2;
        }
        if (parameterType == Byte.TYPE || parameterType == Byte.class) {
            return 1;
        }
        if (parameterType == Character.TYPE || parameterType == Character.class) {
            return 2;
        }
        if (parameterType == Boolean.TYPE || parameterType == Boolean.class) {
            return 1;
        }
        if (parameterType == Float.TYPE || parameterType == Float.class) {
            return 4;
        }
        if (parameterType == Double.TYPE || parameterType == Double.class) {
            return 8;
        }
        throw new NotSupportedException(parameterType + " type is not supported");
    }

    private static void a(Object object, int n2, int n3, IntPtr intPtr, int n4, int n5) {
        if (intPtr == null || intPtr.isNull()) {
            throw new ArgumentNullException("Destination cannot be null");
        }
        if (object == null) {
            throw new ArgumentNullException("Source cannot be null");
        }
        Pointer pointer = intPtr.toPointer();
        if (!(pointer instanceof PointerToArray)) {
            throw new ArgumentException("invalid type of destination", "destination");
        }
        PointerToArray pointerToArray = (PointerToArray)pointer;
        Array array = Array.boxing(object);
        Array array2 = Array.boxing(pointer.getData());
        if (n5 < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("sourceStartIndex", "Non-negative number required.");
        }
        if (n3 > array.getLength() - n5) {
            throw new ArgumentOutOfRangeException("Source array was not long enough");
        }
        if (n4 > array2.getLength() - n5) {
            throw new AccessViolationException("Source array was not long enough");
        }
        if (pointer.getOffset() > (array2.getLength() - n5) * pointerToArray.getElementSize()) {
            throw new ArgumentOutOfRangeException("Destination array was not long enough");
        }
        try {
            Buffer.blockCopy(array, n3 * n2, array2, n4, n5 * n2);
        }
        catch (ArgumentException argumentException) {
            throw new AccessViolationException("Cannot write. Address inaccessible");
        }
    }

    private static void a(IntPtr intPtr, int n2, Object object, int n3, int n4, int n5) {
        if (intPtr == null || intPtr.isNull()) {
            throw new ArgumentNullException("Destination cannot be null");
        }
        if (object == null) {
            throw new ArgumentNullException("Source cannot be null");
        }
        Pointer pointer = intPtr.toPointer();
        if (!(pointer instanceof PointerToArray)) {
            throw new ArgumentException("invalid type of source", "source");
        }
        PointerToArray pointerToArray = (PointerToArray)pointer;
        Array array = Array.boxing(pointer.getData());
        Array array2 = Array.boxing(object);
        if (n5 < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (n2 > array.getLength() - n5) {
            throw new ArgumentOutOfRangeException("Source array was not long enough");
        }
        if (n4 < 0) {
            throw new ArgumentOutOfRangeException("destinationStartIndex", "Non-negative number required.");
        }
        if (n4 > array2.getLength() - n5) {
            throw new ArgumentOutOfRangeException("Destination array was not long enough");
        }
        if (pointer.getOffset() > (array.getLength() - n5) * pointerToArray.getElementSize()) {
            throw new ArgumentOutOfRangeException("Source array was not long enough");
        }
        try {
            Buffer.blockCopy(array, n2, array2, n4 * n3, n5 * n3);
        }
        catch (ArgumentException argumentException) {
            throw new AccessViolationException("Cannot read. Address inaccessible");
        }
    }

    public static int getLastWin32Error() {
        return Kernel32.GetLastError();
    }
}

